/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.Calendar;
import java.util.HashMap;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomUtils;
import org.xcmis.restatom.collections.CmisTypeCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.model.TypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesChildrenCollection
extends CmisTypeCollection {
    public TypesChildrenCollection() {
        this.setHref("/types");
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        String typeId = request.getTarget().getParameter("typeId");
        boolean includePropertyDefinitions = this.getBooleanParameter(request, "includePropertyDefinitions", false);
        int maxItems = this.getIntegerParameter(request, "maxItems", Integer.MAX_VALUE);
        int skipCount = this.getIntegerParameter(request, "skipCount", 0);
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            ItemsList list = conn.getTypeChildren(typeId, includePropertyDefinitions, maxItems, skipCount);
            this.addPageLinks(typeId, feed, "types", maxItems, skipCount, list.getNumItems(), list.isHasMoreItems(), request);
            String down = this.getTypeDescendantsLink(typeId, request);
            feed.addLink(down, "down", "application/cmistree+xml", null, null, -1L);
            if (typeId != null) {
                String typeLink = this.getObjectTypeLink(typeId, request);
                feed.addLink(typeLink, "via", "application/atom+xml;type=entry", null, null, -1L);
                TypeDefinition type = conn.getTypeDefinition(typeId);
                String parentType = type.getParentId();
                if (parentType != null) {
                    String parent = this.getObjectTypeLink(parentType, request);
                    feed.addLink(parent, "up", "application/atom+xml;type=entry", null, null, -1L);
                }
            }
            for (TypeDefinition type : list.getItems()) {
                Entry e = feed.addEntry();
                IRI feedIri = new IRI(this.getFeedIriForEntry(type, request));
                this.addEntryDetails(request, e, feedIri, type);
            }
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (TypeNotFoundException tnfe) {
            throw new ResponseContextException(this.createErrorResponse(tnfe, 404));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public Iterable<TypeDefinition> getEntries(RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("entries");
    }

    @Override
    public String getTitle(RequestContext request) {
        return "Types Children";
    }

    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        Factory factory = request.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        feed.setId(this.getId(request));
        feed.setTitle(this.getTitle(request));
        feed.addAuthor(this.getAuthor(request));
        feed.setUpdated(AtomUtils.getAtomDate(Calendar.getInstance()));
        feed.addLink(this.getServiceLink(request), "service", "application/atomsvc+xml", null, null, -1L);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", "types");
        params.put("id", request.getTarget().getParameter("typeid"));
        String self = request.absoluteUrlFor((Object)"ENTRY", params);
        feed.addLink(self, "self", "application/atom+xml;type=feed", null, null, -1L);
        return feed;
    }
}

