/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.xcmis.spi.CmisRegistryFactory;
import org.xcmis.spi.CmisRegistryFactoryFinder;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.Connection;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.StorageProvider;
import org.xcmis.spi.model.RepositoryShortInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisRegistry {
    static final String XCMIS_REGISTRY_FACTORY = "org.xcmis.CmisRegistryFactory";
    private static AtomicReference<CmisRegistryFactory> crfs = new AtomicReference();
    protected List<String> renditionProviders = new ArrayList<String>();
    protected Map<String, StorageProvider> storageProviders = new TreeMap<String, StorageProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmisRegistry getInstance() {
        CmisRegistryFactory crf = crfs.get();
        if (crf != null) {
            return crf.getRegistry();
        }
        AtomicReference<CmisRegistryFactory> atomicReference = crfs;
        synchronized (atomicReference) {
            crf = crfs.get();
            if (crf != null) {
                return crf.getRegistry();
            }
            crf = CmisRegistryFactoryFinder.findCmisRegistry();
            if (crf == null) {
                crf = new CmisRegistryFactory0(new CmisRegistry());
            }
            crfs.compareAndSet(null, crf);
        }
        return crfs.get().getRegistry();
    }

    public static void setFactory(CmisRegistryFactory factory) {
        crfs.set(factory);
    }

    public void addStorage(StorageProvider storageProvider) {
        String id = storageProvider.getStorageID();
        if (this.storageProviders.get(id) != null) {
            throw new CmisRuntimeException("Storage " + id + " already registered.");
        }
        this.storageProviders.put(id, storageProvider);
    }

    public Connection getConnection(String storageId) {
        StorageProvider storageProvider = this.storageProviders.get(storageId);
        if (storageProvider == null) {
            throw new InvalidArgumentException("Storage '" + storageId + "' does not exist.");
        }
        return storageProvider.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RepositoryShortInfo> getStorageInfos() {
        TreeSet<RepositoryShortInfo> set = new TreeSet<RepositoryShortInfo>();
        for (String id : this.storageProviders.keySet()) {
            RepositoryShortInfo info = new RepositoryShortInfo(id, id);
            Connection connection = null;
            try {
                connection = this.storageProviders.get(id).getConnection();
                info.setRootFolderId(connection.getStorage().getRepositoryInfo().getRootFolderId());
                set.add(info);
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
        return Collections.unmodifiableSortedSet(set);
    }

    public void addRenditionProvider(String provider) {
        if (provider != null) {
            this.renditionProviders.add(provider);
        }
    }

    private static class CmisRegistryFactory0
    implements CmisRegistryFactory {
        CmisRegistry registry;

        public CmisRegistryFactory0(CmisRegistry registry) {
            this.registry = registry;
        }

        public CmisRegistry getRegistry() {
            return this.registry;
        }
    }
}

