/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.spi.CmisRegistryFactory;
import org.xcmis.spi.CmisRuntimeException;

class CmisRegistryFactoryFinder {
    private static final Log LOG = ExoLogger.getLogger(CmisRegistryFactoryFinder.class);

    CmisRegistryFactoryFinder() {
    }

    public static CmisRegistryFactory findCmisRegistry() {
        block8: {
            ClassLoader classLoader = null;
            try {
                classLoader = CmisRegistryFactoryFinder.class.getClassLoader();
            }
            catch (Exception e) {
                // empty catch block
            }
            String name = null;
            try {
                name = System.getProperty("org.xcmis.CmisRegistryFactory");
                if (name != null) {
                    return CmisRegistryFactoryFinder.createInstance(classLoader, name);
                }
            }
            catch (SecurityException se) {
                // empty catch block
            }
            String file = "META-INF/services/xcmis/org.xcmis.CmisRegistryFactory";
            InputStream in = null;
            in = classLoader != null ? classLoader.getResourceAsStream(file) : ClassLoader.getSystemResourceAsStream(file);
            if (in != null) {
                try {
                    name = null;
                    BufferedReader rd = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
                    name = rd.readLine();
                    rd.close();
                    return CmisRegistryFactoryFinder.createInstance(classLoader, name);
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private static CmisRegistryFactory createInstance(ClassLoader classLoader, String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Try to create " + name));
        }
        try {
            Class<?> cls = null;
            cls = classLoader != null ? classLoader.loadClass(name) : Class.forName(name);
            return (CmisRegistryFactory)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CmisRuntimeException("Registry " + name + " not found. ", e);
        }
        catch (Exception e1) {
            throw new CmisRuntimeException("Can't instantiate factory " + name, e1);
        }
    }
}

