/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.jdbm;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.jdbm.JdbmCacheLoader;
import org.jboss.cache.loader.jdbm.JdbmCacheLoader2Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class JdbmCacheLoader2
extends JdbmCacheLoader {
    private static final Log log = LogFactory.getLog(JdbmCacheLoader2.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int PARENT_CACHE_SIZE = 100;
    private Set<Fqn> parents = Collections.synchronizedSet(new HashSet());

    @Override
    JdbmCacheLoader2Config createConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        return new JdbmCacheLoader2Config(base);
    }

    private Fqn withDepth(Fqn name) {
        return this.withDepth(name, name.size());
    }

    private Fqn withDepth(Fqn name, int depth) {
        Fqn<Integer> n = Fqn.fromElements(depth);
        return Fqn.fromRelativeList(n, name.peekElements());
    }

    @Override
    Set<Object> getChildrenNames0(Fqn name) throws IOException {
        Fqn fqn;
        Fqn name2 = this.withDepth(name, name.size() + 1);
        TupleBrowser browser = this.tree.browse((Object)name2);
        Tuple t = new Tuple();
        HashSet<Object> set = new HashSet<Object>();
        while (browser.getNext(t) && (fqn = (Fqn)t.getKey()).isChildOf(name2)) {
            set.add(fqn.getLastElement());
        }
        if (set.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Map get(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        return (Map)this.tree.find((Object)this.withDepth(name));
    }

    @Override
    public boolean exists(Fqn name) throws IOException {
        return this.tree.find((Object)this.withDepth(name)) != null;
    }

    @Override
    Object put0(Fqn name, Object key, Object value) throws Exception {
        this.checkNonNull(name, "name");
        this.ensureParent(name);
        Fqn dname = this.withDepth(name);
        HashMap<Object, Object> map = (HashMap<Object, Object>)this.tree.find((Object)dname);
        Object oldValue = null;
        if (map != null) {
            oldValue = map.put(key, value);
            this.tree.insert((Object)dname, map, true);
        } else {
            map = new HashMap<Object, Object>();
            map.put(key, value);
            this.tree.insert((Object)dname, map, false);
        }
        return oldValue;
    }

    @Override
    void put0(Fqn name, Map<?, ?> values) throws IOException {
        if (trace) {
            log.trace((Object)("put " + name + " values=" + values));
        }
        this.ensureParent(name);
        Fqn dname = this.withDepth(name);
        values = values == null ? this.emptyMap() : new HashMap(values);
        this.tree.insert((Object)dname, values, true);
    }

    private Map emptyMap() {
        return new HashMap(0);
    }

    private void ensureParent(Fqn name) throws IOException {
        if (name.size() <= 1) {
            return;
        }
        Fqn parent = name.getParent();
        if (this.parents.contains(parent)) {
            return;
        }
        if (!this.exists(parent)) {
            this.put0(parent, this.emptyMap());
        }
        this.parents.add(parent);
        if (this.parents.size() > 100) {
            this.parents.clear();
        }
    }

    @Override
    void erase0(Fqn name, boolean prune) throws IOException {
        if (trace) {
            log.trace((Object)("erase " + name + " prune=" + prune));
        }
        if (!prune) {
            this.put0(name, this.emptyMap());
            return;
        }
        Set<?> children = this.getChildrenNames(name);
        if (children != null) {
            log.trace((Object)("remove children: " + children));
            for (Object child : children) {
                this.erase0(Fqn.fromRelativeElements(name, child), true);
            }
        }
        this.parents.remove(name);
        try {
            this.tree.remove((Object)this.withDepth(name));
        }
        catch (IllegalArgumentException e) {
            log.trace((Object)("remove non-existant key? " + e));
        }
    }

    @Override
    Object eraseKey0(Fqn name, Object key) throws IOException {
        Fqn dname = this.withDepth(name);
        Map map = (Map)this.tree.find((Object)dname);
        Object oldValue = null;
        if (map != null) {
            oldValue = map.remove(key);
            this.tree.insert((Object)dname, (Object)map, true);
        }
        return oldValue;
    }
}

