/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.hibernate;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.hibernate.HibernateUserListAccess;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleHibernateUserListAccess
extends HibernateUserListAccess {
    public SimpleHibernateUserListAccess(HibernateService service, String findQuery, String countQuery) {
        super(service, findQuery, countQuery);
    }

    public SimpleHibernateUserListAccess(HibernateService service, String findQuery, String countQuery, Map<String, Object> binding) {
        super(service, findQuery, countQuery, binding);
    }

    @Override
    protected int getSize(Session session) throws Exception {
        Query query = session.createQuery(this.countQuery);
        this.bindFields(query);
        List l = query.list();
        Number count = (Number)l.get(0);
        return count.intValue();
    }

    @Override
    protected User[] load(Session session, int index, int length) throws Exception {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: index must be a positive number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: length must be a positive number");
        }
        User[] users = new User[length];
        Query query = session.createQuery(this.findQuery);
        this.bindFields(query);
        Iterator results = query.iterate();
        int p = 0;
        int counter = 0;
        while (counter < length) {
            if (!results.hasNext()) {
                throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
            }
            Object result = results.next();
            if (p >= index) {
                users[counter++] = (User)result;
            }
            ++p;
        }
        return users;
    }

    private void bindFields(Query query) {
        for (Map.Entry entry : this.binding.entrySet()) {
            query.setParameter((String)entry.getKey(), entry.getValue());
        }
    }
}

