/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.payload;

import java.io.Serializable;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.EventInfo;
import org.gatein.pc.api.info.EventingInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.container.PortletApplication;
import org.gatein.pc.portlet.container.PortletApplicationContext;
import org.gatein.pc.portlet.container.PortletContainer;
import org.gatein.pc.portlet.impl.info.ContainerTypeInfo;
import org.gatein.wsrp.payload.SerializablePayload;
import org.gatein.wsrp.payload.SerializableSimplePayload;
import org.w3c.dom.Node;

public class WSRPEventPayloadInterceptor
extends PortletInvokerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WSRPEventPayloadInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        if (invocation instanceof EventInvocation) {
            Serializable srcPayload;
            EventInvocation eventInvocation = (EventInvocation)invocation;
            Serializable dstPayload = srcPayload = eventInvocation.getPayload();
            if (srcPayload instanceof SerializablePayload) {
                PortletContainer container = (PortletContainer)invocation.getAttribute("PORTLET_CONTAINER");
                String containerId = container.getId();
                QName eventName = eventInvocation.getName();
                boolean trace = log.isTraceEnabled();
                PortletInfo info = container.getInfo();
                EventingInfo eventingInfo = info.getEventing();
                Map consumedEventInfos = eventingInfo.getConsumedEvents();
                EventInfo eventInfo = (EventInfo)consumedEventInfos.get(eventName);
                if (eventInfo != null) {
                    ContainerTypeInfo typeInfo = (ContainerTypeInfo)eventInfo.getType();
                    if (typeInfo != null) {
                        Class dstPayloadClass = typeInfo.getType();
                        if (trace) {
                            log.trace((Object)("Obtained for event " + eventName + " its payload class " + dstPayloadClass.getName() + " declared by the portlet meta data " + containerId));
                        }
                        PortletApplication application = container.getPortletApplication();
                        PortletApplicationContext applicationContext = application.getContext();
                        ClassLoader loader = applicationContext.getClassLoader();
                        if (srcPayload instanceof SerializableSimplePayload) {
                            dstPayload = ((SerializableSimplePayload)srcPayload).getPayload();
                        } else {
                            SerializablePayload scp = (SerializablePayload)srcPayload;
                            try {
                                Class<Serializable> clazz = loader.loadClass(dstPayloadClass.getName()).asSubclass(Serializable.class);
                                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                                JAXBElement result = unmarshaller.unmarshal((Node)scp.getElement(), clazz);
                                dstPayload = (Serializable)result.getValue();
                            }
                            catch (Exception e) {
                                throw new PortletInvokerException("Couldn't unmarshall event from payload!", (Throwable)e);
                            }
                        }
                    } else if (trace) {
                        log.trace((Object)("No type declared for event " + eventName + " declared by the portlet meta data " + containerId));
                    }
                }
            }
            eventInvocation.setPayload(dstPayload);
            try {
                PortletInvocationResponse portletInvocationResponse = super.invoke(invocation);
                return portletInvocationResponse;
            }
            finally {
                eventInvocation.setPayload(srcPayload);
            }
        }
        return super.invoke(invocation);
    }
}

