/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.client.OAuthClient;
import net.oauth.client.URLConnectionResponse;

public class OAuthURLConnectionClient
extends OAuthClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuthMessage invoke(OAuthMessage request) throws IOException, OAuthException {
        HttpURLConnection http;
        int statusCode;
        URLConnection connection;
        URL url;
        if ("GET".equals(request.method)) {
            url = new URL(OAuth.addParameters(request.URL, request.getParameters()));
            connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod(request.method);
            }
            connection.setDoInput(true);
        } else {
            url = new URL(request.URL);
            connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod(request.method);
            }
            connection.setDoInput(true);
            String form = OAuth.formEncode(request.getParameters());
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStream output = connection.getOutputStream();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(output, "ISO-8859-1");
                writer.write(form);
                ((Writer)writer).close();
            }
            finally {
                output.close();
            }
        }
        URLConnectionResponse response = new URLConnectionResponse(request, connection);
        if (connection instanceof HttpURLConnection && (statusCode = (http = (HttpURLConnection)connection).getResponseCode()) != 200) {
            Map<String, Object> dump = response.getDump();
            OAuthProblemException problem = new OAuthProblemException((String)dump.get("oauth_problem"));
            problem.getParameters().putAll(dump);
            throw problem;
        }
        return response;
    }
}

