/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.MarkupInfo;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.portlet.impl.spi.AbstractPortletInvocationContext;

class ExoPortletInvocationContext
extends AbstractPortletInvocationContext {
    private HttpServletResponse response;
    private HttpServletRequest request;
    private String portalRequestURI;
    private String portletId;
    static final String INTERACTION_STATE_PARAM_NAME = "interactionstate";
    static final String NAVIGATIONAL_STATE_PARAM_NAME = "navigationalstate";
    static final String RESOURCE_STATE_PARAM_NAME = "resourcestate";
    private static final String QMARK = "?";
    private static final String EQ = "=";
    private static final String AMP = "&";
    private static final String XMLAMP = "&amp;";

    public ExoPortletInvocationContext(PortalRequestContext portalRequestContext, UIPortlet portlet) {
        super(new MarkupInfo(MediaType.TEXT_HTML, "UTF-8"));
        this.request = portalRequestContext.getRequest();
        this.response = portalRequestContext.getResponse();
        this.portalRequestURI = portalRequestContext.getRequestURI();
        this.portletId = portlet.getId();
    }

    public HttpServletRequest getClientRequest() throws IllegalStateException {
        return this.request;
    }

    public HttpServletResponse getClientResponse() throws IllegalStateException {
        return this.response;
    }

    public String encodeResourceURL(String url) throws IllegalArgumentException {
        return this.response.encodeURL(url);
    }

    public MarkupInfo getMarkupInfo() {
        return this.markupInfo;
    }

    public String renderURL(ContainerURL containerURL, URLFormat format) {
        Mode mode;
        WindowState windowState;
        StateString navigationalState;
        String type;
        boolean wantEscapeXML = false;
        if (format != null && format.getWantEscapeXML() != null) {
            wantEscapeXML = format.getWantEscapeXML();
        }
        StringBuilder baseURL = new StringBuilder(this.portalRequestURI).append(QMARK).append("portal:componentId").append(EQ).append(this.portletId);
        if (containerURL instanceof RenderURL) {
            type = "render";
        } else if (containerURL instanceof ResourceURL) {
            type = "resource";
        } else if (containerURL instanceof ActionURL) {
            type = "action";
        } else {
            throw new Error("Unrecognized containerURL type");
        }
        if (!type.equals("render")) {
            this.appendParameter(baseURL, "portal:type", type, wantEscapeXML);
        }
        if (format != null && format.getWantSecure() != null) {
            this.appendParameter(baseURL, "portal:isSecure", format.getWantSecure().toString(), wantEscapeXML);
        }
        if ((navigationalState = containerURL.getNavigationalState()) != null && !navigationalState.getStringValue().equals("JBPNS_")) {
            this.appendParameter(baseURL, NAVIGATIONAL_STATE_PARAM_NAME, navigationalState.getStringValue(), wantEscapeXML);
        }
        if ((windowState = containerURL.getWindowState()) != null) {
            this.appendParameter(baseURL, "portal:windowState", windowState.toString(), wantEscapeXML);
        }
        if ((mode = containerURL.getMode()) != null) {
            this.appendParameter(baseURL, "portal:portletMode", mode.toString(), wantEscapeXML);
        }
        if (containerURL instanceof ActionURL) {
            ActionURL actionURL = (ActionURL)containerURL;
            StateString state = actionURL.getInteractionState();
            if (state != null && !state.getStringValue().equals("JBPNS_")) {
                this.appendParameter(baseURL, INTERACTION_STATE_PARAM_NAME, state.getStringValue(), wantEscapeXML);
            }
        } else if (containerURL instanceof ResourceURL) {
            StateString resourceState;
            ResourceURL resourceURL = (ResourceURL)containerURL;
            this.appendParameter(baseURL, "portal:resourceID", resourceURL.getResourceId(), wantEscapeXML);
            CacheLevel cachability = resourceURL.getCacheability();
            if (cachability != null) {
                this.appendParameter(baseURL, "portal:cacheLevel", cachability.name(), wantEscapeXML);
            }
            if ((resourceState = resourceURL.getResourceState()) != null && !resourceState.getStringValue().equals("JBPNS_")) {
                this.appendParameter(baseURL, RESOURCE_STATE_PARAM_NAME, resourceState.getStringValue(), wantEscapeXML);
            }
        } else {
            RenderURL renderURL = (RenderURL)containerURL;
            Map publicNSChanges = renderURL.getPublicNavigationalStateChanges();
            if (ParameterValidation.existsAndIsNotEmpty((Map)publicNSChanges)) {
                for (String key : publicNSChanges.keySet()) {
                    String[] values = (String[])publicNSChanges.get(key);
                    if (values != null && values.length > 0) {
                        for (String value : values) {
                            this.appendParameter(baseURL, key, value, wantEscapeXML);
                        }
                        continue;
                    }
                    this.appendParameter(baseURL, "removePP", key, wantEscapeXML);
                }
            }
        }
        return baseURL.toString();
    }

    private void appendParameter(StringBuilder builder, String name, String value, boolean wantEscapeXML) {
        if (value != null) {
            if (wantEscapeXML) {
                builder.append(XMLAMP).append(name).append(EQ).append(value);
            } else {
                builder.append(AMP).append(name).append(EQ).append(value);
            }
        }
    }
}

