/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.lock.LockException;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UIViewSearchResult;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/search/UIShowAllFavouriteResult.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={OpenFolderActionListener.class}), @EventConfig(listeners={SortASCActionListener.class}), @EventConfig(listeners={SortDESCActionListener.class}), @EventConfig(listeners={StarClickActionListener.class})})
public class UIShowAllFavouriteResult
extends UIComponentDecorator {
    public static final int SHOW_ALL_FAVOURITE = 0;
    public static final int SHOW_ALL_FAVOURITE_BY_USER = 1;
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.search.UIShowAllFavouriteResult");
    private static final int FILE_PER_PAGE = 10;
    private static String iconType = "BlueDownArrow";
    private static String iconName = "";
    private long searchTime_ = 0L;
    private List<Node> favouriteNodes_ = new ArrayList<Node>();
    private Map<Integer, Node> mapIndexNode = new Hashtable<Integer, Node>();
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIShowAllFavouriteIterator");
    private boolean favouriteChange = false;
    private int showNodeCase;
    private static FavoriteService favoriteService_ = null;

    public UIShowAllFavouriteResult() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public FavoriteService getFavouriteService() {
        return favoriteService_;
    }

    public DateFormat getSimpleDateFormat() {
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        return SimpleDateFormat.getDateTimeInstance(3, 3, locale);
    }

    public void setShowNodeCase(int value) {
        this.showNodeCase = value;
    }

    public long getSearchTime() {
        return this.searchTime_;
    }

    public void setSearchTime(long time) {
        this.searchTime_ = time;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public Map<Integer, Node> getMapIndexNode() {
        return this.mapIndexNode;
    }

    public Date getDateCreated(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            return node.getProperty("exo:dateCreated").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public List<Node> getAllFavouriteNodes() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    protected List<Node> getNewFavouriteNodeList() throws Exception {
        ArrayList<Node> ret = new ArrayList();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ret = favoriteService_.getAllFavoriteNodesByUser(uiExplorer.getCurrentWorkspace(), uiExplorer.getRepositoryName(), uiExplorer.getSession().getUserID());
        return ret;
    }

    public void updateList() throws Exception {
        List<Node> nodeList = this.getNewFavouriteNodeList();
        ObjectPageList pageList = new ObjectPageList(nodeList, 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
        this.favouriteNodes_ = nodeList;
        this.favouriteChange = false;
    }

    static {
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        favoriteService_ = (FavoriteService)myContainer.getComponentInstanceOfType(FavoriteService.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchComparator
    implements Comparator<Node> {
        private SearchComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            try {
                if (iconType.equals("BlueUpArrow") || iconType.equals("BlueDownArrow")) {
                    String s1 = node1.getProperty("jcr:primaryType").getString();
                    String s2 = node2.getProperty("jcr:primaryType").getString();
                    if (iconType.trim().equals("BlueUpArrow")) {
                        return s2.compareTo(s1);
                    }
                    return s1.compareTo(s2);
                }
                if (iconName.equals("BlueUpArrow") || iconName.equals("BlueDownArrow")) {
                    String name1 = node1.getName();
                    String name2 = node2.getName();
                    if (iconName.trim().equals("BlueUpArrow")) {
                        return name2.compareTo(name1);
                    }
                    return name1.compareTo(name2);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot compare nodes", (Throwable)e);
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StarClickActionListener
    extends EventListener<UIShowAllFavouriteResult> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(Event<UIShowAllFavouriteResult> event) throws Exception {
            String index = event.getRequestContext().getRequestParameter("objectId");
            int id = Integer.parseInt(index);
            UIShowAllFavouriteResult uiShow = (UIShowAllFavouriteResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiShow.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiShow.getAncestorOfType(UIApplication.class);
            Node node = (Node)uiShow.mapIndexNode.get(id);
            try {
                uiExplorer.addLockToken(node);
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            try {
                if (favoriteService_.isFavoriter(node.getSession().getUserID(), node)) {
                    if (!PermissionUtil.canRemoveNode((Node)node)) throw new AccessDeniedException();
                    favoriteService_.removeFavorite(node, node.getSession().getUserID());
                    uiShow.favouriteChange = true;
                } else {
                    if (!PermissionUtil.canSetProperty((Node)node)) throw new AccessDeniedException();
                    favoriteService_.addFavorite(node, node.getSession().getUserID());
                    uiShow.favouriteChange = true;
                }
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiShow);
                return;
            }
            catch (LockException e) {
                LOG.error((Object)("node is locked, can't remove change favourite property of node :" + node.getPath()));
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                uiExplorer.updateAjax(event);
                return;
            }
            catch (AccessDeniedException e) {
                LOG.error((Object)("Access denied! No permission for modifying property exo:favouriter of node: " + node.getPath()));
                uiApp.addMessage(new ApplicationMessage("UIShowAllFavouriteResult.msg.accessDenied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"An unexpected error occurs!");
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewActionListener
    extends EventListener<UIShowAllFavouriteResult> {
        public void execute(Event<UIShowAllFavouriteResult> event) throws Exception {
            Node node;
            UIShowAllFavouriteResult uiShowAllFavouriteResult = (UIShowAllFavouriteResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiShowAllFavouriteResult.getAncestorOfType(UIJCRExplorer.class);
            String repository = uiExplorer.getRepositoryName();
            String path = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uiShowAllFavouriteResult.getAncestorOfType(UIApplication.class);
            try {
                node = uiExplorer.getNodeByPath(path, uiExplorer.getTargetSession());
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIShowAllFavouriteResult.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            TemplateService templateService = (TemplateService)uiShowAllFavouriteResult.getApplicationComponent(TemplateService.class);
            if (!templateService.isManagedNodeType(node.getPrimaryNodeType().getName(), repository)) {
                uiApp.addMessage(new ApplicationMessage("UIShowAllFavouriteResult.msg.not-support", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            UIPopupWindow uiPopup = (UIPopupWindow)uiExplorer.getChildById("ViewSearch");
            if (uiPopup == null) {
                uiPopup = (UIPopupWindow)uiExplorer.addChild(UIPopupWindow.class, null, "ViewSearch");
            }
            uiPopup.setResizable(true);
            UIViewSearchResult uiViewSearch = (UIViewSearchResult)uiPopup.createUIComponent(UIViewSearchResult.class, null, null);
            uiViewSearch.setNode(node);
            uiPopup.setWindowSize(600, 750);
            uiPopup.setUIComponent((UIComponent)uiViewSearch);
            uiPopup.setRendered(true);
            uiPopup.setShow(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenFolderActionListener
    extends EventListener<UIShowAllFavouriteResult> {
        public void execute(Event<UIShowAllFavouriteResult> event) throws Exception {
            UIShowAllFavouriteResult uiShowAllFavouriteResult = (UIShowAllFavouriteResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiShowAllFavouriteResult.getAncestorOfType(UIJCRExplorer.class);
            String path = event.getRequestContext().getRequestParameter("objectId");
            String folderPath = LinkUtils.getParentPath((String)path);
            Node node = null;
            try {
                node = uiExplorer.getNodeByPath(folderPath, uiExplorer.getTargetSession());
            }
            catch (AccessDeniedException ace) {
                UIApplication uiApp = (UIApplication)uiShowAllFavouriteResult.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIShowAllFavouriteResult.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot access the node at " + folderPath), (Throwable)e);
            }
            uiExplorer.setSelectNode(node.getSession().getWorkspace().getName(), folderPath);
            uiExplorer.updateAjax(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortDESCActionListener
    extends EventListener<UIShowAllFavouriteResult> {
        public void execute(Event<UIShowAllFavouriteResult> event) throws Exception {
            UIShowAllFavouriteResult uiShowAllFavouriteResult = (UIShowAllFavouriteResult)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            if (objectId.equals("type")) {
                iconType = "BlueUpArrow";
                iconName = "";
            } else if (objectId.equals("name")) {
                iconType = "";
                iconName = "BlueUpArrow";
            }
            int currentPage = uiShowAllFavouriteResult.getUIPageIterator().getCurrentPage();
            if (uiShowAllFavouriteResult.favouriteChange) {
                uiShowAllFavouriteResult.updateList();
                uiShowAllFavouriteResult.favouriteChange = false;
            }
            Collections.sort(uiShowAllFavouriteResult.favouriteNodes_, new SearchComparator());
            ObjectPageList pageList = new ObjectPageList(uiShowAllFavouriteResult.favouriteNodes_, 10);
            UIPageIterator uiPageIterator = uiShowAllFavouriteResult.uiPageIterator_;
            uiPageIterator.setPageList((PageList)pageList);
            uiPageIterator.setPageList((PageList)pageList);
            if (uiPageIterator.getAvailablePage() >= currentPage) {
                uiPageIterator.setCurrentPage(currentPage);
            } else {
                uiPageIterator.setCurrentPage(uiPageIterator.getAvailablePage());
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiShowAllFavouriteResult.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortASCActionListener
    extends EventListener<UIShowAllFavouriteResult> {
        public void execute(Event<UIShowAllFavouriteResult> event) throws Exception {
            UIShowAllFavouriteResult uiShowAllFavouriteResult = (UIShowAllFavouriteResult)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            if (objectId.equals("type")) {
                iconType = "BlueDownArrow";
                iconName = "";
            } else if (objectId.equals("name")) {
                iconType = "";
                iconName = "BlueDownArrow";
            }
            int currentPage = uiShowAllFavouriteResult.getUIPageIterator().getCurrentPage();
            if (uiShowAllFavouriteResult.favouriteChange) {
                uiShowAllFavouriteResult.updateList();
                uiShowAllFavouriteResult.favouriteChange = false;
            }
            Collections.sort(uiShowAllFavouriteResult.favouriteNodes_, new SearchComparator());
            ObjectPageList pageList = new ObjectPageList(uiShowAllFavouriteResult.favouriteNodes_, 10);
            UIPageIterator uiPageIterator = uiShowAllFavouriteResult.uiPageIterator_;
            uiPageIterator.setPageList((PageList)pageList);
            if (uiPageIterator.getAvailablePage() >= currentPage) {
                uiPageIterator.setCurrentPage(currentPage);
            } else {
                uiPageIterator.setCurrentPage(uiPageIterator.getAvailablePage());
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiShowAllFavouriteResult.getParent());
        }
    }
}

