/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.io;

import java.io.IOException;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.io.TelnetIO;
import net.wimpi.telnetd.io.terminal.Terminal;
import net.wimpi.telnetd.io.terminal.TerminalManager;
import net.wimpi.telnetd.net.Connection;
import net.wimpi.telnetd.net.ConnectionData;
import net.wimpi.telnetd.net.ConnectionEvent;
import net.wimpi.telnetd.util.Mutex;
import net.wimpi.telnetd.util.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TerminalIO
implements BasicTerminalIO {
    private static Log log = LogFactory.getLog((Class)(class$net$wimpi$telnetd$io$TerminalIO == null ? (class$net$wimpi$telnetd$io$TerminalIO = TerminalIO.class$("net.wimpi.telnetd.io.TerminalIO")) : class$net$wimpi$telnetd$io$TerminalIO));
    private TelnetIO m_TelnetIO;
    private Connection m_Connection;
    private ConnectionData m_ConnectionData;
    private Terminal m_Terminal;
    private ReentrantLock m_WriteLock;
    private Mutex m_ReadLock;
    private boolean m_AcousticSignalling;
    private boolean m_Autoflush;
    private boolean m_ForceBold;
    private boolean m_LineWrapping;
    public static final int[] HOME = new int[]{0, 0};
    public static final int IOERROR = -1;
    public static final int UP = 1001;
    public static final int DOWN = 1002;
    public static final int RIGHT = 1003;
    public static final int LEFT = 1004;
    public static final int STORECURSOR = 1051;
    public static final int RESTORECURSOR = 1052;
    public static final int EEOL = 1100;
    public static final int EBOL = 1101;
    public static final int EEL = 1103;
    public static final int EEOS = 1104;
    public static final int EBOS = 1105;
    public static final int EES = 1106;
    public static final int ESCAPE = 1200;
    public static final int BYTEMISSING = 1201;
    public static final int UNRECOGNIZED = 1202;
    public static final int ENTER = 1300;
    public static final int TABULATOR = 1301;
    public static final int DELETE = 1302;
    public static final int BACKSPACE = 1303;
    public static final int COLORINIT = 1304;
    public static final int HANDLED = 1305;
    public static final int LOGOUTREQUEST = 1306;
    public static final int LineUpdate = 475;
    public static final int CharacterUpdate = 476;
    public static final int ScreenpartUpdate = 477;
    public static final int EditBuffer = 575;
    public static final int LineEditBuffer = 576;
    public static final int BEL = 7;
    public static final int BS = 8;
    public static final int DEL = 127;
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int FCOLOR = 10001;
    public static final int BCOLOR = 10002;
    public static final int STYLE = 10003;
    public static final int RESET = 10004;
    public static final int BOLD = 1;
    public static final int BOLD_OFF = 22;
    public static final int ITALIC = 3;
    public static final int ITALIC_OFF = 23;
    public static final int BLINK = 5;
    public static final int BLINK_OFF = 25;
    public static final int UNDERLINED = 4;
    public static final int UNDERLINED_OFF = 24;
    public static final int DEVICERESET = 10005;
    public static final int LINEWRAP = 10006;
    public static final int NOLINEWRAP = 10007;
    static /* synthetic */ Class class$net$wimpi$telnetd$io$TerminalIO;

    public TerminalIO(Connection con) {
        this.m_Connection = con;
        this.m_AcousticSignalling = true;
        this.m_Autoflush = true;
        this.m_WriteLock = new ReentrantLock();
        this.m_ReadLock = new Mutex();
        this.m_ConnectionData = this.m_Connection.getConnectionData();
        try {
            this.m_TelnetIO = new TelnetIO();
            this.m_TelnetIO.setConnection(con);
            this.m_TelnetIO.initIO();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.setDefaultTerminal();
        }
        catch (Exception ex) {
            log.error((Object)"TerminalIO()", (Throwable)ex);
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        try {
            this.m_ReadLock.acquire();
            int i = this.m_TelnetIO.read();
            i = this.m_Terminal.translateControlCharacter(i);
            if (i == 1306) {
                this.m_Connection.processConnectionEvent(new ConnectionEvent(this.m_Connection, 102));
                i = 1305;
            } else if (i > 256 && i == 1200) {
                i = this.handleEscapeSequence(i);
            }
            int n = i;
            return n;
        }
        catch (InterruptedException ex) {
            int n = -1;
            return n;
        }
        finally {
            this.m_ReadLock.release();
        }
    }

    public void write(byte b) throws IOException {
        this.m_TelnetIO.write(b);
        if (this.m_Autoflush) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char ch) throws IOException {
        try {
            this.m_WriteLock.acquire();
            this.m_TelnetIO.write(ch);
            if (this.m_Autoflush) {
                this.flush();
            }
        }
        catch (InterruptedException ex) {
            log.error((Object)"write(byte)", (Throwable)ex);
        }
        finally {
            this.m_WriteLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str) throws IOException {
        try {
            this.m_WriteLock.acquire();
            if (this.m_ForceBold) {
                this.m_TelnetIO.write(this.m_Terminal.formatBold(str));
            } else {
                this.m_TelnetIO.write(this.m_Terminal.format(str));
            }
            if (this.m_Autoflush) {
                this.flush();
            }
        }
        catch (InterruptedException ex) {
            log.error((Object)"write(byte)", (Throwable)ex);
        }
        finally {
            this.m_WriteLock.release();
        }
    }

    public synchronized void eraseToEndOfLine() throws IOException {
        this.doErase(1100);
    }

    public synchronized void eraseToBeginOfLine() throws IOException {
        this.doErase(1101);
    }

    public synchronized void eraseLine() throws IOException {
        this.doErase(1103);
    }

    public synchronized void eraseToEndOfScreen() throws IOException {
        this.doErase(1104);
    }

    public synchronized void eraseToBeginOfScreen() throws IOException {
        this.doErase(1105);
    }

    public synchronized void eraseScreen() throws IOException {
        this.doErase(1106);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doErase(int funcConst) throws IOException {
        try {
            this.m_WriteLock.acquire();
            this.m_TelnetIO.write(this.m_Terminal.getEraseSequence(funcConst));
            if (this.m_Autoflush) {
                this.flush();
            }
        }
        catch (InterruptedException ex) {
            log.error((Object)"doErase(int)", (Throwable)ex);
        }
        finally {
            this.m_WriteLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveCursor(int direction, int times) throws IOException {
        try {
            this.m_WriteLock.acquire();
            this.m_TelnetIO.write(this.m_Terminal.getCursorMoveSequence(direction, times));
            if (this.m_Autoflush) {
                this.flush();
            }
        }
        catch (InterruptedException ex) {
            log.error((Object)"moveCursor(int,int)", (Throwable)ex);
        }
        finally {
            this.m_WriteLock.release();
        }
    }

    public void moveLeft(int times) throws IOException {
        this.moveCursor(1004, times);
    }

    public void moveRight(int times) throws IOException {
        this.moveCursor(1003, times);
    }

    public void moveUp(int times) throws IOException {
        this.moveCursor(1001, times);
    }

    public void moveDown(int times) throws IOException {
        this.moveCursor(1002, times);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursor(int row, int col) throws IOException {
        int[] pos = new int[]{row, col};
        try {
            this.m_WriteLock.acquire();
            this.m_TelnetIO.write(this.m_Terminal.getCursorPositioningSequence(pos));
            if (this.m_Autoflush) {
                this.flush();
            }
        }
        catch (InterruptedException ex) {
            log.error((Object)"setCursor(int,int)", (Throwable)ex);
        }
        finally {
            this.m_WriteLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void homeCursor() throws IOException {
        try {
            this.m_WriteLock.acquire();
            this.m_TelnetIO.write(this.m_Terminal.getCursorPositioningSequence(HOME));
            if (this.m_Autoflush) {
                this.flush();
            }
        }
        catch (InterruptedException ex) {
            log.error((Object)"homeCursor()", (Throwable)ex);
        }
        finally {
            this.m_WriteLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCursor() throws IOException {
        try {
            this.m_WriteLock.acquire();
            this.m_TelnetIO.write(this.m_Terminal.getSpecialSequence(1051));
        }
        catch (InterruptedException ex) {
            log.error((Object)"storeCursor()", (Throwable)ex);
        }
        finally {
            this.m_WriteLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restoreCursor() throws IOException {
        try {
            this.m_WriteLock.acquire();
            this.m_TelnetIO.write(this.m_Terminal.getSpecialSequence(1052));
        }
        catch (InterruptedException ex) {
            log.error((Object)"write(byte)", (Throwable)ex);
        }
        finally {
            this.m_WriteLock.release();
        }
    }

    public synchronized void setSignalling(boolean bool) {
        this.m_AcousticSignalling = bool;
    }

    public synchronized boolean isSignalling() {
        return this.m_AcousticSignalling;
    }

    public synchronized void bell() throws IOException {
        if (this.m_AcousticSignalling) {
            this.m_TelnetIO.write(7);
        }
        if (this.m_Autoflush) {
            this.flush();
        }
    }

    public synchronized boolean defineScrollRegion(int topmargin, int bottommargin) throws IOException {
        if (this.m_Terminal.supportsScrolling()) {
            this.m_TelnetIO.write(this.m_Terminal.getScrollMarginsSequence(topmargin, bottommargin));
            this.flush();
            return true;
        }
        return false;
    }

    public synchronized void setForegroundColor(int color) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            this.m_TelnetIO.write(this.m_Terminal.getGRSequence(10001, color));
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public synchronized void setBackgroundColor(int color) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            this.m_TelnetIO.write(this.m_Terminal.getGRSequence(10002, color + 10));
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public synchronized void setBold(boolean b) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            if (b) {
                this.m_TelnetIO.write(this.m_Terminal.getGRSequence(10003, 1));
            } else {
                this.m_TelnetIO.write(this.m_Terminal.getGRSequence(10003, 22));
            }
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public synchronized void forceBold(boolean b) {
        this.m_ForceBold = b;
    }

    public synchronized void setUnderlined(boolean b) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            if (b) {
                this.m_TelnetIO.write(this.m_Terminal.getGRSequence(10003, 4));
            } else {
                this.m_TelnetIO.write(this.m_Terminal.getGRSequence(10003, 24));
            }
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public synchronized void setItalic(boolean b) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            if (b) {
                this.m_TelnetIO.write(this.m_Terminal.getGRSequence(10003, 3));
            } else {
                this.m_TelnetIO.write(this.m_Terminal.getGRSequence(10003, 23));
            }
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public synchronized void setBlink(boolean b) throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            if (b) {
                this.m_TelnetIO.write(this.m_Terminal.getGRSequence(10003, 5));
            } else {
                this.m_TelnetIO.write(this.m_Terminal.getGRSequence(10003, 25));
            }
            if (this.m_Autoflush) {
                this.flush();
            }
        }
    }

    public synchronized void resetAttributes() throws IOException {
        if (this.m_Terminal.supportsSGR()) {
            this.m_TelnetIO.write(this.m_Terminal.getGRSequence(10004, 0));
        }
    }

    private int handleEscapeSequence(int i) throws IOException {
        if (i == 1200) {
            int[] bytebuf = new int[this.m_Terminal.getAtomicSequenceLength()];
            for (int m = 0; m < bytebuf.length; ++m) {
                bytebuf[m] = this.m_TelnetIO.read();
            }
            return this.m_Terminal.translateEscapeSequence(bytebuf);
        }
        if (i == 1201) {
            // empty if block
        }
        return 1305;
    }

    public boolean isAutoflushing() {
        return this.m_Autoflush;
    }

    public synchronized void resetTerminal() throws IOException {
        this.m_TelnetIO.write(this.m_Terminal.getSpecialSequence(10005));
    }

    public synchronized void setLinewrapping(boolean b) throws IOException {
        if (b && !this.m_LineWrapping) {
            this.m_TelnetIO.write(this.m_Terminal.getSpecialSequence(10006));
            this.m_LineWrapping = true;
            return;
        }
        if (!b && this.m_LineWrapping) {
            this.m_TelnetIO.write(this.m_Terminal.getSpecialSequence(10007));
            this.m_LineWrapping = false;
            return;
        }
    }

    public boolean isLineWrapping() {
        return this.m_LineWrapping;
    }

    public synchronized void setAutoflushing(boolean b) {
        this.m_Autoflush = b;
    }

    public synchronized void flush() throws IOException {
        this.m_TelnetIO.flush();
    }

    public synchronized void close() {
        this.m_TelnetIO.closeOutput();
        this.m_TelnetIO.closeInput();
    }

    public Terminal getTerminal() {
        return this.m_Terminal;
    }

    public void setDefaultTerminal() throws IOException {
        this.setTerminal(this.m_ConnectionData.getNegotiatedTerminalType());
    }

    public void setTerminal(String terminalName) throws IOException {
        this.m_Terminal = TerminalManager.getReference().getTerminal(terminalName);
        this.initTerminal();
        log.debug((Object)("Set terminal to " + this.m_Terminal.toString()));
    }

    private synchronized void initTerminal() throws IOException {
        this.m_TelnetIO.write(this.m_Terminal.getInitSequence());
        this.flush();
    }

    public int getRows() {
        return this.m_ConnectionData.getTerminalRows();
    }

    public int getColumns() {
        return this.m_ConnectionData.getTerminalColumns();
    }

    public boolean isTerminalGeometryChanged() {
        return this.m_ConnectionData.isTerminalGeometryChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

