/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.kex;

import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.Digest;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.digest.SHA1;
import org.apache.sshd.common.kex.DH;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDHGClient
implements KeyExchange {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ClientSessionImpl session;
    private byte[] V_S;
    private byte[] V_C;
    private byte[] I_S;
    private byte[] I_C;
    private Digest sha;
    private DH dh;
    private byte[] e;
    private byte[] f;
    private byte[] K;
    private byte[] H;

    public void init(AbstractSession s, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws Exception {
        if (!(s instanceof ClientSessionImpl)) {
            throw new IllegalStateException("Using a client side KeyExchange on a server");
        }
        this.session = (ClientSessionImpl)s;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = I_S;
        this.I_C = I_C;
        this.sha = new SHA1();
        this.sha.init();
        this.dh = new DH();
        this.initDH(this.dh);
        this.e = this.dh.getE();
        this.log.info("Send SSH_MSG_KEXDH_INIT");
        Buffer buffer = s.createBuffer(SshConstants.Message.SSH_MSG_KEXDH_INIT, 0);
        buffer.putMPInt(this.e);
        this.session.writePacket(buffer);
    }

    protected abstract void initDH(DH var1);

    public boolean next(Buffer buffer) throws Exception {
        SshConstants.Message cmd = buffer.getCommand();
        if (cmd != SshConstants.Message.SSH_MSG_KEXDH_REPLY_KEX_DH_GEX_GROUP) {
            throw new SshException(3, "Protocol error: expected packet " + (Object)((Object)SshConstants.Message.SSH_MSG_KEXDH_REPLY_KEX_DH_GEX_GROUP) + ", got " + (Object)((Object)cmd));
        }
        this.log.info("Received SSH_MSG_KEXDH_REPLY");
        byte[] K_S = buffer.getBytes();
        this.f = buffer.getMPIntAsBytes();
        byte[] sig = buffer.getBytes();
        this.dh.setF(this.f);
        this.K = this.dh.getK();
        buffer = new Buffer(K_S);
        PublicKey key = buffer.getRawPublicKey();
        String keyAlg = key instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss";
        buffer = new Buffer();
        buffer.putString(this.V_C);
        buffer.putString(this.V_S);
        buffer.putString(this.I_C);
        buffer.putString(this.I_S);
        buffer.putString(K_S);
        buffer.putMPInt(this.e);
        buffer.putMPInt(this.f);
        buffer.putMPInt(this.K);
        this.sha.update(buffer.array(), 0, buffer.available());
        this.H = this.sha.digest();
        Signature verif = (Signature)NamedFactory.Utils.create(this.session.getFactoryManager().getSignatureFactories(), keyAlg);
        verif.init(key, null);
        verif.update(this.H, 0, this.H.length);
        if (!verif.verify(sig)) {
            throw new SshException(3, "KeyExchange signature verification failed");
        }
        return true;
    }

    public Digest getHash() {
        return this.sha;
    }

    public byte[] getH() {
        return this.H;
    }

    public byte[] getK() {
        return this.K;
    }
}

