/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.shindig.oauth;

import java.io.File;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.ide.shindig.oauth.SecurityTokenGenerator;
import org.exoplatform.ide.shindig.oauth.TokenRequest;
import org.exoplatform.ide.shindig.oauth.TokenResponse;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/services/shindig/securitytoken")
public class RestSecurityTokenGenerator
implements ResourceContainer {
    private final Log log = ExoLogger.getLogger((String)"rest.RestSecurityTokenGenerator");

    @POST
    @Path(value="/createToken")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public TokenResponse createToken(TokenRequest tokenRequest) {
        try {
            return SecurityTokenGenerator.createToken(tokenRequest, this.getKeyFilePath());
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new WebApplicationException((Throwable)e);
        }
        catch (BlobCrypterException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new WebApplicationException((Throwable)e);
        }
    }

    private String getKeyFilePath() {
        File confDir;
        J2EEServerInfo info = new J2EEServerInfo();
        String confPath = info.getExoConfigurationDirectory();
        File keyFile = null;
        if (confPath != null && (confDir = new File(confPath)) != null && confDir.exists() && confDir.isDirectory()) {
            keyFile = new File(confDir, "gadgets/key.txt");
        }
        if (keyFile == null) {
            keyFile = new File("key.txt");
        }
        return keyFile.getAbsolutePath();
    }
}

