/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.queries.impl;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.queries.impl.NewUserConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewUserListener
extends UserEventListener {
    private static final String[] perms = new String[]{"read", "add_node", "set_property", "remove"};
    private NewUserConfig config_;
    private RepositoryService jcrService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String relativePath_;

    public NewUserListener(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreator, InitParams params) throws Exception {
        this.jcrService_ = jcrService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.config_ = (NewUserConfig)params.getObjectParamValues(NewUserConfig.class).get(0);
        this.relativePath_ = params.getValueParam("relativePath").getValue();
    }

    public void preSave(User user, boolean isNew) throws Exception {
        String userName = user.getUserName();
        this.prepareSystemWorkspace(userName);
    }

    private void prepareSystemWorkspace(String userName) throws Exception {
        Session session = null;
        List repositories = this.jcrService_.getConfig().getRepositoryConfigurations();
        for (RepositoryEntry repo : repositories) {
            try {
                String defaultWorkspaceName = this.jcrService_.getDefaultRepository().getConfiguration().getDefaultWorkspaceName();
                session = this.jcrService_.getRepository(repo.getName()).getSystemSession(defaultWorkspaceName);
                Node usersHome = (Node)session.getItem(this.nodeHierarchyCreator_.getJcrPath("usersPath"));
                this.initSystemData(usersHome, userName);
                session.save();
                session.logout();
            }
            catch (RepositoryException re) {
                session.logout();
                return;
            }
        }
    }

    private void initSystemData(Node usersHome, String userName) throws Exception {
        Node userHome = usersHome.getNode(userName);
        Node queriesHome = userHome.getNode(this.relativePath_);
        boolean userFound = false;
        NewUserConfig.User templateConfig = null;
        for (NewUserConfig.User userConfig : this.config_.getUsers()) {
            String currentName = userConfig.getUserName();
            if (this.config_.getTemplate().equals(currentName)) {
                templateConfig = userConfig;
            }
            if (!currentName.equals(userName)) continue;
            List<NewUserConfig.Query> queries = userConfig.getQueries();
            this.importQueries(queriesHome, queries);
            userFound = true;
            break;
        }
        if (!userFound) {
            List<NewUserConfig.Query> queries = templateConfig.getQueries();
            this.importQueries(queriesHome, queries);
        }
        usersHome.save();
    }

    public void importQueries(Node queriesHome, List<NewUserConfig.Query> queries) throws Exception {
        QueryManager manager = queriesHome.getSession().getWorkspace().getQueryManager();
        for (NewUserConfig.Query query : queries) {
            String absPath;
            String queryName = query.getQueryName();
            String language = query.getLanguage();
            String statement = query.getQuery();
            Query queryNode = manager.createQuery(statement, language);
            Node node = queryNode.storeAsNode(absPath = queriesHome.getPath() + "/" + queryName);
            if (!node.isNodeType("exo:datetime")) {
                node.addMixin("exo:datetime");
            }
            node.setProperty("exo:dateCreated", (Calendar)new GregorianCalendar());
            node.getSession().save();
        }
    }

    public void preDelete(User user) {
    }
}

