/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcache;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcache.PortletFutureCache;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="fragmentcache"), @Property(key="type", value="content")})
@ManagedDescription(value="FragmentCache Service")
@RESTEndpoint(path="fragmentcacheservice")
public class FragmentCacheService
implements Startable {
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private static final int DEFAULT_CACHE_CLEANUP = 15;
    private static final Log log = ExoLogger.getLogger(FragmentCacheService.class);
    final PortletFutureCache cache;

    public FragmentCacheService(InitParams params) {
        int cleanupCache = 15;
        int cacheSize = 10000;
        if (params.getValueParam("cleanup-cache") != null) {
            String cleanupCacheConfig = params.getValueParam("cleanup-cache").getValue();
            try {
                cleanupCache = Integer.parseInt(cleanupCacheConfig);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid cleanup-cache setting " + cleanupCacheConfig));
            }
        }
        if (params.getValueParam("cache-size") != null) {
            String cacheSizeConfig = params.getValueParam("cache-size").getValue();
            try {
                cacheSize = Integer.parseInt(cacheSizeConfig);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid cache-size setting " + cacheSizeConfig));
            }
        }
        this.cache = new PortletFutureCache(log, cleanupCache, cacheSize);
    }

    @Managed
    @ManagedDescription(value="What is the Cleanup Cache period (in seconds) ?")
    public int getCleanupCache() {
        return this.cache.getCleanupCache();
    }

    @Managed
    @ManagedDescription(value="How many Entries in Cache  ?")
    public int getCacheSize() {
        return this.cache.getCacheSize();
    }

    @Managed
    @ManagedDescription(value="Get Maximum Entries in Cache")
    public int getCacheMaxSize() {
        return this.cache.getCacheMaxSize();
    }

    @Managed
    @ManagedDescription(value="Set Maximum Entries in Cache")
    public void setCacheSize(int cacheMaxSize) {
        if (cacheMaxSize < 1) {
            throw new IllegalArgumentException("invalid value for max cache size");
        }
        this.cache.setCacheMaxSize(cacheMaxSize);
    }

    @Managed
    @ManagedDescription(value="Sets Cleanup Cache period (in seconds)")
    public void setCleanupCache(int cleanupCache) {
        this.cache.updateCleanupCache(cleanupCache);
    }

    public void start() {
        this.cache.start();
    }

    public void stop() {
        this.cache.stop();
    }

    @Managed
    @ManagedDescription(value="Clear the Fragment Cache")
    public void clearCache() {
        this.cache.clearCache();
    }
}

