/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.util;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class ReflectionUtils {
    public static Field[] getDeclaredAndInheritedFields(Class type) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Arrays.asList(type.getDeclaredFields()));
        for (Class parent = type.getSuperclass(); parent != null && parent != Object.class; parent = parent.getSuperclass()) {
            allFields.addAll(Arrays.asList(parent.getDeclaredFields()));
        }
        return allFields.toArray(new Field[allFields.size()]);
    }

    public static boolean implementsInterface(Class type, Class interfaceClass) {
        if (type.isInterface()) {
            return type == interfaceClass;
        }
        for (Class<?> ifc : type.getInterfaces()) {
            if (ifc != interfaceClass) continue;
            return true;
        }
        return false;
    }

    public static boolean extendsClass(Class type, Class superClass) {
        if (type == superClass) {
            return true;
        }
        for (Class c = type.getSuperclass(); c != null && c != Object.class; c = c.getSuperclass()) {
            if (c != superClass) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyType(Class type) {
        return ReflectionUtils.isValidMapValueType(type) || type == InputStream.class || ReflectionUtils.isArrayOfType(type, Byte.TYPE);
    }

    public static boolean isValidMapValueType(Class type) {
        return type == String.class || ReflectionUtils.isArrayOfType(type, String.class) || type == Date.class || ReflectionUtils.isArrayOfType(type, Date.class) || type == Calendar.class || ReflectionUtils.isArrayOfType(type, Calendar.class) || type == Timestamp.class || ReflectionUtils.isArrayOfType(type, Timestamp.class) || type == Integer.class || ReflectionUtils.isArrayOfType(type, Integer.class) || type == Integer.TYPE || ReflectionUtils.isArrayOfType(type, Integer.TYPE) || type == Long.class || ReflectionUtils.isArrayOfType(type, Long.class) || type == Long.TYPE || ReflectionUtils.isArrayOfType(type, Long.TYPE) || type == Double.class || ReflectionUtils.isArrayOfType(type, Double.class) || type == Double.TYPE || ReflectionUtils.isArrayOfType(type, Double.TYPE) || type == Boolean.class || ReflectionUtils.isArrayOfType(type, Boolean.class) || type == Boolean.TYPE || ReflectionUtils.isArrayOfType(type, Boolean.TYPE) || type == Locale.class || ReflectionUtils.isArrayOfType(type, Locale.class);
    }

    private static boolean isArrayOfType(Class c, Class type) {
        return c.isArray() && c.getComponentType() == type;
    }

    public static boolean isDateType(Class type) {
        return type == Date.class || type == Calendar.class || type == Timestamp.class;
    }

    public static Class getParameterizedClass(Field field) {
        return ReflectionUtils.getParameterizedClass(field, 0);
    }

    public static Class getParameterizedClass(Field field, int index) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)field.getGenericType();
            Type paramType = ptype.getActualTypeArguments()[index];
            if (paramType instanceof GenericArrayType) {
                Class arrayType = (Class)((GenericArrayType)paramType).getGenericComponentType();
                return Array.newInstance(arrayType, 0).getClass();
            }
            return (Class)paramType;
        }
        return null;
    }

    public static boolean isFieldParameterizedWithClass(Field field, Class c) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)field.getGenericType();
            for (Type type : ptype.getActualTypeArguments()) {
                if (type == c) {
                    return true;
                }
                if (!c.isInterface() || !ReflectionUtils.implementsInterface((Class)type, c)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFieldParameterizedWithPropertyType(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)field.getGenericType();
            for (Type type : ptype.getActualTypeArguments()) {
                if (!ReflectionUtils.isPropertyType((Class)type)) continue;
                return true;
            }
        }
        return false;
    }
}

