/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.impl;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Cate;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.CategoryInfo;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.DataStorage;
import org.exoplatform.faq.service.FAQEventQuery;
import org.exoplatform.faq.service.FAQServiceUtils;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.ObjectSearchResult;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionInfo;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.QuestionNodeListener;
import org.exoplatform.faq.service.QuestionPageList;
import org.exoplatform.faq.service.SubCategoryInfo;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.Watch;
import org.exoplatform.ks.common.EmailNotifyPlugin;
import org.exoplatform.ks.common.NotifyInfo;
import org.exoplatform.ks.common.UserHelper;
import org.exoplatform.ks.common.conf.RoleRulesPlugin;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRDataStorage
implements DataStorage {
    private static final Log log = ExoLogger.getLogger(JCRDataStorage.class);
    private static final String MIMETYPE_TEXTHTML = "text/html".intern();
    private Map<String, String> serverConfig_ = new HashMap<String, String>();
    private Map<String, NotifyInfo> messagesInfoMap_ = new HashMap<String, NotifyInfo>();
    final Queue<NotifyInfo> pendingMessagesQueue = new ConcurrentLinkedQueue<NotifyInfo>();
    private final String ADMIN_ = "ADMIN".intern();
    private List<RoleRulesPlugin> rulesPlugins_ = new ArrayList<RoleRulesPlugin>();
    private SessionManager sessionManager;
    private KSDataLocation dataLocator;

    public JCRDataStorage(KSDataLocation dataLocator) throws Exception {
        this.dataLocator = dataLocator;
        this.sessionManager = dataLocator.getSessionManager();
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) throws Exception {
        try {
            this.serverConfig_ = ((EmailNotifyPlugin)plugin).getServerConfiguration();
        }
        catch (Exception e) {
            log.error((Object)"\nFailed to add plugin\n ", (Throwable)e);
        }
    }

    @Override
    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        try {
            if (plugin instanceof RoleRulesPlugin) {
                this.rulesPlugins_.add((RoleRulesPlugin)plugin);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to add role plugin\n", (Throwable)e);
        }
    }

    @Override
    public void addInitRssPlugin(ComponentPlugin plugin) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdminRole(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node cateHomeNode = this.getCategoryHome(sProvider, null);
            for (int i = 0; i < this.rulesPlugins_.size(); ++i) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(this.rulesPlugins_.get(i).getRules(this.ADMIN_));
                if (cateHomeNode.hasProperty("exo:moderators")) {
                    list.addAll(Utils.valuesToList(cateHomeNode.getProperty("exo:moderators").getValues()));
                }
                if (list.contains(userName)) {
                    boolean bl = true;
                    return bl;
                }
                if (!Utils.hasPermission(list, UserHelper.getAllGroupAndMembershipOfUser((String)userName))) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Check user whether is admin: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    @Override
    public List<String> getAllFAQAdmin() throws Exception {
        List<String> list = new ArrayList<String>();
        try {
            for (int i = 0; i < this.rulesPlugins_.size(); ++i) {
                list.addAll(this.rulesPlugins_.get(i).getRules(this.ADMIN_));
            }
            list = FAQServiceUtils.getUserPermission(list.toArray(new String[0]));
        }
        catch (Exception e) {
            log.error((Object)"Failed to get all FAQ admin: ", (Throwable)e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getUserSetting(String userName, FAQSetting faqSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node userSettingHome = this.getUserSettingHome(sProvider);
            Node userSettingNode = userSettingHome.getNode(userName);
            if (userSettingNode.hasProperty("exo:ordeBy")) {
                faqSetting.setOrderBy(userSettingNode.getProperty("exo:ordeBy").getValue().getString());
            }
            if (userSettingNode.hasProperty("exo:ordeType")) {
                faqSetting.setOrderType(userSettingNode.getProperty("exo:ordeType").getValue().getString());
            }
            if (userSettingNode.hasProperty("exo:sortQuestionByVote")) {
                faqSetting.setSortQuestionByVote(userSettingNode.getProperty("exo:sortQuestionByVote").getValue().getBoolean());
            }
        }
        catch (Exception e) {
            this.saveFAQSetting(faqSetting, userName);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFAQSetting(FAQSetting faqSetting, String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node userSettingNode = this.getUserSettingHome(sProvider).getNode(userName);
            userSettingNode.setProperty("exo:ordeBy", faqSetting.getOrderBy());
            userSettingNode.setProperty("exo:ordeType", faqSetting.getOrderType());
            userSettingNode.setProperty("exo:sortQuestionByVote", faqSetting.isSortQuestionByVote());
            userSettingNode.save();
        }
        catch (PathNotFoundException e) {
            Node userSettingNode = this.getUserSettingHome(sProvider).addNode(userName, "exo:faqUserSetting");
            userSettingNode.setProperty("exo:ordeBy", faqSetting.getOrderBy());
            userSettingNode.setProperty("exo:ordeType", faqSetting.getOrderType());
            userSettingNode.setProperty("exo:sortQuestionByVote", faqSetting.isSortQuestionByVote());
            userSettingNode.getSession().save();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileAttachment getUserAvatar(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node = this.getKSUserAvatarHomeNode(sProvider).getNode(userName);
            if (node.isNodeType("nt:file")) {
                FileAttachment attachment = new FileAttachment();
                Node nodeFile = node.getNode("jcr:content");
                attachment.setId(node.getPath());
                attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
                attachment.setNodeName(node.getName());
                attachment.setName("avatar." + attachment.getMimeType());
                String workspace = node.getSession().getWorkspace().getName();
                attachment.setWorkspace(workspace);
                attachment.setPath("/" + workspace + node.getPath());
                attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                FileAttachment fileAttachment = attachment;
                return fileAttachment;
            }
        }
        catch (PathNotFoundException e) {
            FileAttachment fileAttachment = null;
            return fileAttachment;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get user avatar", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUserAvatar(String userId, FileAttachment fileAttachment) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node ksAvatarHomeNode = this.getKSUserAvatarHomeNode(sProvider);
            Node avatarNode = ksAvatarHomeNode.hasNode(userId) ? ksAvatarHomeNode.getNode(userId) : ksAvatarHomeNode.addNode(userId, "nt:file");
            FAQServiceUtils.reparePermissions(avatarNode, "any");
            Node nodeContent = avatarNode.hasNode("jcr:content") ? avatarNode.getNode("jcr:content") : avatarNode.addNode("jcr:content", "nt:resource");
            nodeContent.setProperty("jcr:mimeType", fileAttachment.getMimeType());
            nodeContent.setProperty("jcr:data", fileAttachment.getInputStream());
            nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
            if (avatarNode.isNew()) {
                ksAvatarHomeNode.getSession().save();
            } else {
                ksAvatarHomeNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save user avatar: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultAvatar(String userName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node;
            Node avatarHome = this.getKSUserAvatarHomeNode(sProvider);
            if (avatarHome.hasNode(userName) && (node = avatarHome.getNode(userName)).isNodeType("nt:file")) {
                node.remove();
                avatarHome.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to set default avatar: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeIterator getQuestionsIterator() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node faqHome = this.getFAQServiceHome(sProvider);
            NodeIterator nodeIterator = this.getQuestionsIterator(faqHome, "", true);
            return nodeIterator;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get question iterator: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    private NodeIterator getQuestionsIterator(Node parentNode, String strQuery, boolean isAll) throws Exception {
        StringBuffer queryString = new StringBuffer("/jcr:root").append(parentNode.getPath()).append(isAll ? "//" : "/").append("element(*,exo:faqQuestion)").append(strQuery);
        QueryManager qm = parentNode.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes();
    }

    protected void addRSSListener(Node node) throws Exception {
    }

    @Override
    public void reInitRSSEvenListener() throws Exception {
    }

    public void reInitQuestionNodeListeners() throws Exception {
        NodeIterator iter = this.getQuestionsIterator();
        if (iter == null) {
            return;
        }
        while (iter.hasNext()) {
            Node quesNode = iter.nextNode();
            this.registerQuestionNodeListener(quesNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initRootCategory() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node faqServiceHome = this.getFAQServiceHome(sProvider);
            if (faqServiceHome.hasNode("categories")) {
                log.error((Object)"root category is already created");
                boolean bl = false;
                return bl;
            }
            Node categoryHome = faqServiceHome.addNode("categories", "exo:faqCategory");
            categoryHome.addMixin("mix:faqSubCategory");
            categoryHome.setProperty("exo:name", "Answers");
            categoryHome.setProperty("exo:isView", true);
            faqServiceHome.save();
            log.info((Object)("Initialized root category : " + categoryHome.getPath()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize root category", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getTemplate() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node templateHome = this.getTemplateHome(sProvider);
            Node fileNode = templateHome.getNode(Utils.UI_FAQ_VIEWER);
            if (fileNode.isNodeType("nt:file")) {
                Node contentNode = fileNode.getNode("jcr:content");
                InputStream inputStream = contentNode.getProperty("jcr:data").getStream();
                byte[] data = new byte[inputStream.available()];
                inputStream.read(data);
                inputStream.close();
                byte[] byArray = data;
                return byArray;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get template", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTemplate(String str) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node fileNode;
            Node templateHome = this.getTemplateHome(sProvider);
            try {
                fileNode = templateHome.getNode(Utils.UI_FAQ_VIEWER);
            }
            catch (Exception e) {
                fileNode = templateHome.addNode(Utils.UI_FAQ_VIEWER, "nt:file");
            }
            Node nodeContent = null;
            ByteArrayInputStream inputStream = null;
            byte[] byte_ = str.getBytes();
            inputStream = new ByteArrayInputStream(byte_);
            try {
                nodeContent = fileNode.addNode("jcr:content", "nt:resource");
            }
            catch (Exception e) {
                nodeContent = fileNode.getNode("jcr:content");
            }
            nodeContent.setProperty("jcr:mimeType", "application/x-groovy+html");
            nodeContent.setProperty("jcr:data", (InputStream)inputStream);
            nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
            if (templateHome.isNew()) {
                templateHome.getSession().save();
            } else {
                templateHome.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save template: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    protected Value[] booleanToValues(Node node, Boolean[] bools) throws Exception {
        if (bools == null) {
            return new Value[]{node.getSession().getValueFactory().createValue(true)};
        }
        Value[] values = new Value[bools.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = node.getSession().getValueFactory().createValue(bools[i].booleanValue());
        }
        return values;
    }

    private boolean questionHasAnswer(Node questionNode) throws Exception {
        return questionNode.hasNode(Utils.ANSWER_HOME) && questionNode.getNode(Utils.ANSWER_HOME).hasNodes();
    }

    @Deprecated
    private void sendNotifyForQuestionWatcher(Question question, FAQSetting faqSetting) {
        ArrayList<String> emailsList = new ArrayList<String>();
        emailsList.add(question.getEmail());
        try {
            Node cate = this.getCategoryNodeById(question.getCategoryId());
            if (cate.isNodeType("exo:faqWatching")) {
                for (String email : org.exoplatform.ks.common.Utils.ValuesToList((Value[])cate.getProperty("exo:emailWatching").getValues())) {
                    emailsList.add(email);
                }
            }
            if (question.getEmailsWatch() != null) {
                for (String email : question.getEmailsWatch()) {
                    emailsList.add(email);
                }
            }
            if (emailsList != null && emailsList.size() > 0) {
                Message message = new Message();
                message.setMimeType(MIMETYPE_TEXTHTML);
                message.setFrom(question.getAuthor());
                message.setSubject(faqSetting.getEmailSettingSubject() + ": " + question.getQuestion());
                String body = faqSetting.getEmailSettingContent().replaceAll("&questionContent_", question.getDetail()).replaceAll("&questionLink_", question.getLink());
                body = question.getAnswers() != null && question.getAnswers().length > 0 ? body.replaceAll("&questionResponse_", question.getAnswers()[0].getResponses()) : body.replaceAll("&questionResponse_", "");
                message.setBody(body);
                this.sendEmailNotification(emailsList, message);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to send a notify for question watcher: ", (Throwable)e);
        }
    }

    private void sendNotifyWatcher(Question question, FAQSetting faqSetting, boolean isNew) {
        ArrayList<String> emails = new ArrayList<String>();
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> emailsList = new ArrayList<String>();
        emailsList.add(question.getEmail());
        try {
            Node cate = this.getCategoryNodeById(question.getCategoryId());
            PropertyReader reader = new PropertyReader(cate);
            emails.addAll(reader.list("exo:emailWatching", new ArrayList()));
            users.addAll(reader.list("exo:userWatching", new ArrayList()));
            if (question.getEmailsWatch() != null && question.getEmailsWatch().length > 0) {
                emails.addAll(Arrays.asList(question.getEmailsWatch()));
                users.addAll(Arrays.asList(question.getUsersWatch()));
            }
            if (!question.isActivated() || !question.isApproved() && faqSetting.getDisplayMode().equals("approved")) {
                List moderators = reader.list("exo:moderators", new ArrayList());
                ArrayList<String> temps = new ArrayList<String>();
                int i = 0;
                for (String user : users) {
                    if (!temps.contains(user)) {
                        temps.add(user);
                        if (this.isAdminRole(user) || Utils.hasPermission(moderators, UserHelper.getAllGroupAndMembershipOfUser((String)user))) {
                            emailsList.add((String)emails.get(i));
                        }
                    }
                    ++i;
                }
            } else {
                emailsList.addAll(emails);
            }
            if (emailsList != null && emailsList.size() > 0) {
                Message message = new Message();
                message.setFrom(question.getAuthor());
                message.setMimeType(MIMETYPE_TEXTHTML);
                message.setSubject(faqSetting.getEmailSettingSubject() + ": " + question.getQuestion());
                if (isNew) {
                    message.setBody(faqSetting.getEmailSettingContent().replaceAll("&categoryName_", reader.string("exo:name", "")).replaceAll("&questionContent_", question.getDetail()).replaceAll("&questionLink_", question.getLink()));
                } else {
                    String contentMail = faqSetting.getEmailSettingContent().replaceAll("&questionContent_", question.getQuestion());
                    contentMail = question.getAnswers().length > 0 ? contentMail.replaceAll("&questionResponse_", question.getAnswers()[0].getResponses()) : contentMail.replaceAll("&questionResponse_", "");
                    contentMail = contentMail.replaceAll("&questionLink_", question.getLink());
                    message.setBody(contentMail);
                }
                this.sendEmailNotification(emailsList, message);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to send a nofify for category watcher: ", (Throwable)e);
        }
    }

    @Override
    public void sendMessage(Message message) throws Exception {
        try {
            MailService mService = (MailService)PortalContainer.getComponent(MailService.class);
            mService.sendMessage(message);
        }
        catch (NullPointerException e) {
            MailService mService = (MailService)StandaloneContainer.getInstance().getComponentInstanceOfType(MailService.class);
            mService.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QuestionLanguage> getQuestionLanguages(String questionId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<QuestionLanguage> listQuestionLanguage = new ArrayList<QuestionLanguage>();
        try {
            Node questionNode = this.getFAQServiceHome(sProvider).getNode(questionId);
            try {
                listQuestionLanguage.add(this.getQuestionLanguage(questionNode));
            }
            catch (Exception e) {
                log.debug((Object)"Adding a question node failed: ", (Throwable)e);
            }
            if (questionNode.hasNode(Utils.LANGUAGE_HOME)) {
                Node languageNode = questionNode.getNode(Utils.LANGUAGE_HOME);
                NodeIterator nodeIterator = languageNode.getNodes();
                while (nodeIterator.hasNext()) {
                    try {
                        listQuestionLanguage.add(this.getQuestionLanguage(nodeIterator.nextNode()));
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get question language: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return listQuestionLanguage;
    }

    private QuestionLanguage getQuestionLanguage(Node questionNode) throws Exception {
        QuestionLanguage questionLanguage = new QuestionLanguage();
        questionLanguage.setState(QuestionLanguage.VIEW);
        questionLanguage.setId(questionNode.getName());
        questionLanguage.setLanguage(questionNode.getProperty("exo:language").getValue().getString());
        questionLanguage.setQuestion(questionNode.getProperty("exo:title").getValue().getString());
        if (questionNode.hasProperty("exo:name")) {
            questionLanguage.setDetail(questionNode.getProperty("exo:name").getValue().getString());
        }
        Comment[] comments = this.getComment(questionNode);
        Answer[] answers = this.getAnswers(questionNode);
        questionLanguage.setComments(comments);
        questionLanguage.setAnswers(answers);
        return questionLanguage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAnswer(String questionId, String answerId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.getFAQServiceHome(sProvider).getNode(questionId);
            Node answerNode = questionNode.getNode(Utils.ANSWER_HOME).getNode(answerId);
            answerNode.remove();
            questionNode.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to delete a answer: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteComment(String questionId, String commentId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.getFAQServiceHome(sProvider).getNode(questionId);
            Node commnetNode = questionNode.getNode(Utils.COMMENT_HOME).getNode(commentId);
            commnetNode.remove();
            questionNode.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to delete a commnent: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private Answer[] getAnswers(Node questionNode) throws Exception {
        try {
            if (!questionNode.hasNode(Utils.ANSWER_HOME)) {
                return new Answer[0];
            }
            NodeIterator nodeIterator = questionNode.getNode(Utils.ANSWER_HOME).getNodes();
            ArrayList<Answer> answers = new ArrayList<Answer>();
            String language = questionNode.getProperty("exo:language").getString();
            while (nodeIterator.hasNext()) {
                try {
                    Node node = nodeIterator.nextNode();
                    Answer ans = this.getAnswerByNode(node);
                    ans.setLanguage(language);
                    answers.add(ans);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to get anwser", (Throwable)e);
                }
            }
            return answers.toArray(new Answer[0]);
        }
        catch (Exception e) {
            log.error((Object)"Failed to get answer: ", (Throwable)e);
            return new Answer[0];
        }
    }

    private Answer getAnswerByNode(Node answerNode) throws Exception {
        Answer answer = new Answer();
        answer.setId(answerNode.getName());
        if (answerNode.hasProperty("exo:responses")) {
            answer.setResponses(answerNode.getProperty("exo:responses").getValue().getString());
        }
        if (answerNode.hasProperty("exo:responseBy")) {
            answer.setResponseBy(answerNode.getProperty("exo:responseBy").getValue().getString());
        }
        if (answerNode.hasProperty("exo:fullName")) {
            answer.setFullName(answerNode.getProperty("exo:fullName").getValue().getString());
        }
        if (answerNode.hasProperty("exo:dateResponse")) {
            answer.setDateResponse(answerNode.getProperty("exo:dateResponse").getValue().getDate().getTime());
        }
        if (answerNode.hasProperty("exo:usersVoteAnswer")) {
            answer.setUsersVoteAnswer(Utils.valuesToArray(answerNode.getProperty("exo:usersVoteAnswer").getValues()));
        }
        if (answerNode.hasProperty("exo:MarkVotes")) {
            answer.setMarkVotes(answerNode.getProperty("exo:MarkVotes").getValue().getLong());
        }
        if (answerNode.hasProperty("exo:approveResponses")) {
            answer.setApprovedAnswers(answerNode.getProperty("exo:approveResponses").getValue().getBoolean());
        }
        if (answerNode.hasProperty("exo:activateResponses")) {
            answer.setActivateAnswers(answerNode.getProperty("exo:activateResponses").getValue().getBoolean());
        }
        if (answerNode.hasProperty("exo:postId")) {
            answer.setPostId(answerNode.getProperty("exo:postId").getString());
        }
        String path = answerNode.getPath();
        answer.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getPageListAnswer(String questionId, Boolean isSortByVote) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            QuestionPageList pageList;
            Node answerHome = this.getFAQServiceHome(sProvider).getNode(questionId + "/" + Utils.ANSWER_HOME);
            QueryManager qm = answerHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(answerHome.getPath()).append("//element(*,exo:answer)");
            if (isSortByVote == null) {
                queryString.append("order by @exo:dateResponse ascending");
            } else if (isSortByVote.booleanValue()) {
                queryString.append("order by @exo:MarkVotes ascending");
            } else {
                queryString.append("order by @exo:MarkVotes descending");
            }
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            QuestionPageList questionPageList = pageList = new QuestionPageList(result.getNodes(), 10L, queryString.toString(), true);
            return questionPageList;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get page list answers", (Throwable)e);
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public void saveAnswer(String questionId, Answer answer, boolean isNew) throws Exception {
        Answer[] answers = new Answer[]{answer};
        this.saveAnswer(questionId, answers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAnswer(String questionId, Answer[] answers) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node quesNode = this.getFAQServiceHome(sProvider).getNode(questionId);
            if (!quesNode.isNodeType("mix:faqi18n")) {
                quesNode.addMixin("mix:faqi18n");
            }
            String qId = quesNode.getName();
            String categoryId = quesNode.getProperty("exo:categoryId").getString();
            String defaultLang = quesNode.getProperty("exo:language").getString();
            for (Answer answer : answers) {
                Node answerHome;
                if (answer.getLanguage().equals(defaultLang)) {
                    try {
                        answerHome = quesNode.getNode(Utils.ANSWER_HOME);
                    }
                    catch (Exception e) {
                        answerHome = quesNode.addNode(Utils.ANSWER_HOME, "exo:answerHome");
                    }
                } else {
                    Node langNode = this.getLanguageNodeByLanguage(quesNode, answer.getLanguage());
                    try {
                        answerHome = langNode.getNode(Utils.ANSWER_HOME);
                    }
                    catch (Exception e) {
                        answerHome = langNode.addNode(Utils.ANSWER_HOME, "exo:answerHome");
                    }
                }
                this.saveAnswer(answer, answerHome, qId, categoryId);
            }
            quesNode.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to save answer: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private void saveAnswer(Answer answer, Node answerHome, String questionId, String categoryId) throws Exception {
        Node answerNode;
        try {
            answerNode = answerHome.getNode(answer.getId());
        }
        catch (PathNotFoundException e) {
            answerNode = answerHome.addNode(answer.getId(), "exo:answer");
        }
        if (!answer.isNew()) {
            answerNode.remove();
            return;
        }
        try {
            if (answerNode.isNew()) {
                Calendar calendar = GregorianCalendar.getInstance();
                if (answer.getDateResponse() != null) {
                    calendar.setTime(answer.getDateResponse());
                }
                answerNode.setProperty("exo:dateResponse", calendar);
                answerNode.setProperty("exo:id", answer.getId());
                answerNode.setProperty("exo:approveResponses", answer.getApprovedAnswers().booleanValue());
                answerNode.setProperty("exo:activateResponses", answer.getActivateAnswers().booleanValue());
            } else {
                if (new PropertyReader(answerNode).bool("exo:approveResponses", false) != answer.getApprovedAnswers()) {
                    answerNode.setProperty("exo:approveResponses", answer.getApprovedAnswers().booleanValue());
                }
                if (new PropertyReader(answerNode).bool("exo:activateResponses", false) != answer.getActivateAnswers()) {
                    answerNode.setProperty("exo:activateResponses", answer.getActivateAnswers().booleanValue());
                }
            }
            if (answer.getPostId() != null && answer.getPostId().length() > 0) {
                answerNode.setProperty("exo:postId", answer.getPostId());
            }
            answerNode.setProperty("exo:responses", answer.getResponses());
            answerNode.setProperty("exo:responseBy", answer.getResponseBy());
            answerNode.setProperty("exo:fullName", answer.getFullName());
            answerNode.setProperty("exo:usersVoteAnswer", answer.getUsersVoteAnswer());
            answerNode.setProperty("exo:MarkVotes", answer.getMarkVotes());
            answerNode.setProperty("exo:responseLanguage", answer.getLanguage());
            answerNode.setProperty("exo:questionId", questionId);
            answerNode.setProperty("exo:categoryId", categoryId);
        }
        catch (Exception e) {
            log.error((Object)"Failed to save Answer: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveComment(String questionId, Comment comment, boolean isNew) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node commentNode;
            Node quesNode = this.getFAQServiceHome(sProvider).getNode(questionId);
            if (!quesNode.isNodeType("mix:faqi18n")) {
                quesNode.addMixin("mix:faqi18n");
            }
            Node commentHome = null;
            try {
                commentHome = quesNode.getNode(Utils.COMMENT_HOME);
            }
            catch (PathNotFoundException e) {
                commentHome = quesNode.addNode(Utils.COMMENT_HOME, "exo:commentHome");
            }
            if (isNew) {
                commentNode = commentHome.addNode(comment.getId(), "exo:comment");
                Calendar calendar = GregorianCalendar.getInstance();
                commentNode.setProperty("exo:dateComment", calendar);
                commentNode.setProperty("exo:id", comment.getId());
            } else {
                commentNode = commentHome.getNode(comment.getId());
            }
            if (comment.getPostId() != null && comment.getPostId().length() > 0) {
                commentNode.setProperty("exo:postId", comment.getPostId());
            }
            commentNode.setProperty("exo:comments", comment.getComments());
            commentNode.setProperty("exo:commentBy", comment.getCommentBy());
            commentNode.setProperty("exo:fullName", comment.getFullName());
            commentNode.setProperty("exo:categoryId", quesNode.getProperty("exo:categoryId").getString());
            commentNode.setProperty("exo:questionId", quesNode.getName());
            commentNode.setProperty("exo:commentLanguage", quesNode.getProperty("exo:language").getString());
            if (commentNode.isNew()) {
                quesNode.getSession().save();
            } else {
                quesNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to save comment: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAnswerQuestionLang(String questionId, Answer answer, String language, boolean isNew) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node answerNode;
            Node quesNode = this.getFAQServiceHome(sProvider).getNode(questionId);
            Node answerHome = null;
            try {
                answerHome = quesNode.getNode(Utils.ANSWER_HOME);
            }
            catch (PathNotFoundException e) {
                answerHome = quesNode.addNode(Utils.ANSWER_HOME, "exo:answerHome");
            }
            if (isNew) {
                answerNode = answerHome.addNode(answer.getId(), "exo:answer");
                Calendar calendar = GregorianCalendar.getInstance();
                answerNode.setProperty("exo:dateResponses", calendar);
                answerNode.setProperty("exo:approveResponses", answer.getApprovedAnswers().booleanValue());
                answerNode.setProperty("exo:activateResponses", answer.getActivateAnswers().booleanValue());
            } else {
                answerNode = answerHome.getNode(answer.getId());
                if (new PropertyReader(answerNode).bool("exo:approveResponses", false) != answer.getApprovedAnswers()) {
                    answerNode.setProperty("exo:approveResponses", answer.getApprovedAnswers().booleanValue());
                }
                if (new PropertyReader(answerNode).bool("exo:activateResponses", false) != answer.getActivateAnswers()) {
                    answerNode.setProperty("exo:activateResponses", answer.getActivateAnswers().booleanValue());
                }
            }
            answerNode.setProperty("exo:responses", answer.getResponses());
            answerNode.setProperty("exo:responseBy", answer.getResponseBy());
            answerNode.setProperty("exo:fullName", answer.getFullName());
            answerNode.setProperty("exo:usersVoteAnswer", answer.getUsersVoteAnswer());
        }
        catch (Exception e) {
            log.error((Object)"Failed to save answer question language: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Answer getAnswerById(String questionId, String answerid) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node answerNode = this.getFAQServiceHome(sProvider).getNode(questionId).getNode(Utils.ANSWER_HOME).getNode(answerid);
            Answer answer = this.getAnswerByNode(answerNode);
            return answer;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get answer by id.", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    public Comment[] getComments(String questionId) throws Exception {
        Node questionNode = this.getQuestionNodeById(questionId);
        return this.getComment(questionNode);
    }

    private Comment[] getComment(Node questionNode) throws Exception {
        try {
            if (!questionNode.hasNode(Utils.COMMENT_HOME)) {
                return new Comment[0];
            }
            NodeIterator nodeIterator = questionNode.getNode(Utils.COMMENT_HOME).getNodes();
            Comment[] comments = new Comment[(int)nodeIterator.getSize()];
            Node commentNode = null;
            int i = 0;
            while (nodeIterator.hasNext()) {
                commentNode = nodeIterator.nextNode();
                comments[i] = this.getCommentByNode(commentNode);
                ++i;
            }
            return comments;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get comment: ", (Throwable)e);
            return new Comment[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JCRPageList getPageListComment(String questionId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            QuestionPageList pageList;
            Node commentHome = this.getFAQServiceHome(sProvider).getNode(questionId + "/" + Utils.COMMENT_HOME);
            QueryManager qm = commentHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(commentHome.getPath()).append("//element(*,exo:comment)").append("order by @exo:dateComment ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            QuestionPageList questionPageList = pageList = new QuestionPageList(result.getNodes(), 10L, queryString.toString(), true);
            return questionPageList;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get page list comments", (Throwable)e);
            JCRPageList jCRPageList = null;
            return jCRPageList;
        }
        finally {
            sProvider.close();
        }
    }

    private Comment getCommentByNode(Node commentNode) throws Exception {
        Comment comment = new Comment();
        comment.setId(commentNode.getName());
        if (commentNode.hasProperty("exo:comments")) {
            comment.setComments(commentNode.getProperty("exo:comments").getValue().getString());
        }
        if (commentNode.hasProperty("exo:commentBy")) {
            comment.setCommentBy(commentNode.getProperty("exo:commentBy").getValue().getString());
        }
        if (commentNode.hasProperty("exo:dateComment")) {
            comment.setDateComment(commentNode.getProperty("exo:dateComment").getValue().getDate().getTime());
        }
        if (commentNode.hasProperty("exo:fullName")) {
            comment.setFullName(commentNode.getProperty("exo:fullName").getValue().getString());
        }
        if (commentNode.hasProperty("exo:postId")) {
            comment.setPostId(commentNode.getProperty("exo:postId").getString());
        }
        return comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comment getCommentById(String questionId, String commentId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node commentNode = this.getFAQServiceHome(sProvider).getNode(questionId + "/" + Utils.COMMENT_HOME + "/" + commentId);
            Comment comment = this.getCommentByNode(commentNode);
            return comment;
        }
        catch (Exception e) {
            log.error((Object)("Failed to get comment by id: " + commentId), (Throwable)e);
            Comment comment = null;
            return comment;
        }
        finally {
            sProvider.close();
        }
    }

    private Node getLanguageNodeByLanguage(Node questionNode, String languge) throws Exception {
        NodeIterator nodeIterator = questionNode.getNode(Utils.LANGUAGE_HOME).getNodes();
        Node languageNode = null;
        while (nodeIterator.hasNext()) {
            languageNode = nodeIterator.nextNode();
            if (!languageNode.getProperty("exo:language").getString().equals(languge)) continue;
            return languageNode;
        }
        return null;
    }

    private void saveQuestion(Node questionNode, Question question, boolean isNew, SessionProvider sProvider, FAQSetting faqSetting) throws Exception {
        questionNode.setProperty("exo:id", questionNode.getName());
        questionNode.setProperty("exo:name", question.getDetail());
        questionNode.setProperty("exo:author", question.getAuthor());
        questionNode.setProperty("exo:email", question.getEmail());
        questionNode.setProperty("exo:title", question.getQuestion());
        if (isNew) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(question.getCreatedDate());
            questionNode.setProperty("exo:createdDate", cal.getInstance());
            questionNode.setProperty("exo:language", question.getLanguage());
        }
        String catId = question.getCategoryId();
        if (!question.getCategoryId().equals("categories")) {
            catId = catId.substring(catId.lastIndexOf("/") + 1);
        }
        questionNode.setProperty("exo:categoryId", catId);
        questionNode.setProperty("exo:isActivated", question.isActivated());
        questionNode.setProperty("exo:isApproved", question.isApproved());
        questionNode.setProperty("exo:usersVote", question.getUsersVote());
        questionNode.setProperty("exo:markVote", question.getMarkVote());
        questionNode.setProperty("exo:link", question.getLink());
        List<FileAttachment> listFileAtt = question.getAttachMent();
        ArrayList<String> listNodeNames = new ArrayList<String>();
        if (!listFileAtt.isEmpty()) {
            for (FileAttachment att : listFileAtt) {
                listNodeNames.add(att.getNodeName());
                try {
                    Node nodeFile = null;
                    nodeFile = questionNode.hasNode(att.getNodeName()) ? questionNode.getNode(att.getNodeName()) : questionNode.addNode(att.getNodeName(), "exo:faqAttachment");
                    FAQServiceUtils.reparePermissions(nodeFile, "any");
                    Node nodeContent = null;
                    nodeContent = nodeFile.hasNode("jcr:content") ? nodeFile.getNode("jcr:content") : nodeFile.addNode("jcr:content", "exo:faqResource");
                    nodeContent.setProperty("exo:fileName", att.getName());
                    nodeContent.setProperty("exo:categoryId", catId);
                    nodeContent.setProperty("jcr:mimeType", att.getMimeType());
                    nodeContent.setProperty("jcr:data", att.getInputStream());
                    nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
                }
                catch (Exception e) {
                    log.error((Object)"Failed to save question: ", (Throwable)e);
                }
            }
        }
        NodeIterator nodeIterator = questionNode.getNodes();
        Node node = null;
        while (nodeIterator.hasNext()) {
            node = nodeIterator.nextNode();
            if (!node.isNodeType("exo:faqAttachment") || listNodeNames.contains(node.getName())) continue;
            node.remove();
        }
        question.setId(questionNode.getName());
        String catePath = questionNode.getParent().getParent().getPath();
        question.setCategoryId(catePath.substring(catePath.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        this.sendNotifyWatcher(question, faqSetting, isNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node saveQuestion(Question question, boolean isAddNew, FAQSetting faqSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode;
            if (isAddNew) {
                Node questionHome;
                Node category = this.getFAQServiceHome(sProvider).getNode(question.getCategoryId());
                try {
                    questionHome = category.getNode(Utils.QUESTION_HOME);
                }
                catch (PathNotFoundException ex) {
                    questionHome = category.addNode(Utils.QUESTION_HOME, "exo:faqQuestionHome");
                    this.addRSSListener(questionHome);
                }
                questionNode = questionHome.addNode(question.getId(), "exo:faqQuestion");
            } else {
                questionNode = this.getFAQServiceHome(sProvider).getNode(question.getPath());
            }
            this.saveQuestion(questionNode, question, isAddNew, sProvider, faqSetting);
            if (questionNode.isNew()) {
                questionNode.getSession().save();
                this.registerQuestionNodeListener(questionNode);
            } else {
                questionNode.save();
            }
            Node node = questionNode;
            return node;
        }
        catch (Exception e) {
            log.error((Object)"Failed to save question ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQuestion(String questionId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.getFAQServiceHome(sProvider).getNode(questionId);
            Node questionHome = questionNode.getParent();
            questionNode.remove();
            questionHome.save();
        }
        catch (Exception e) {
            log.error((Object)"Fail ro remove question: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public Comment getCommentById(Node questionNode, String commentId) throws Exception {
        try {
            Comment comment = new Comment();
            Node commentNode = questionNode.getNode(Utils.COMMENT_HOME).getNode(commentId);
            comment.setId(commentNode.getName());
            if (commentNode.hasProperty("exo:comments")) {
                comment.setComments(commentNode.getProperty("exo:comments").getValue().getString());
            }
            if (commentNode.hasProperty("exo:commentBy")) {
                comment.setCommentBy(commentNode.getProperty("exo:commentBy").getValue().getString());
            }
            if (commentNode.hasProperty("exo:dateComment")) {
                comment.setDateComment(commentNode.getProperty("exo:dateComment").getValue().getDate().getTime());
            }
            if (commentNode.hasProperty("exo:postId")) {
                comment.setPostId(commentNode.getProperty("exo:postId").getString());
            }
            return comment;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get comment through id: ", (Throwable)e);
            return null;
        }
    }

    private Question getQuestion(Node questionNode) throws Exception {
        Question question = new Question();
        question.setId(questionNode.getName());
        if (questionNode.hasProperty("exo:language")) {
            question.setLanguage(questionNode.getProperty("exo:language").getString());
        }
        if (questionNode.hasProperty("exo:name")) {
            question.setDetail(questionNode.getProperty("exo:name").getString());
        }
        if (questionNode.hasProperty("exo:author")) {
            question.setAuthor(questionNode.getProperty("exo:author").getString());
        }
        if (questionNode.hasProperty("exo:email")) {
            question.setEmail(questionNode.getProperty("exo:email").getString());
        }
        if (questionNode.hasProperty("exo:title")) {
            question.setQuestion(questionNode.getProperty("exo:title").getString());
        }
        if (questionNode.hasProperty("exo:createdDate")) {
            question.setCreatedDate(questionNode.getProperty("exo:createdDate").getDate().getTime());
        }
        if (questionNode.hasProperty("exo:categoryId")) {
            question.setCategoryId(questionNode.getProperty("exo:categoryId").getString());
        }
        if (questionNode.hasProperty("exo:isActivated")) {
            question.setActivated(questionNode.getProperty("exo:isActivated").getBoolean());
        }
        if (questionNode.hasProperty("exo:isApproved")) {
            question.setApproved(questionNode.getProperty("exo:isApproved").getBoolean());
        }
        if (questionNode.hasProperty("exo:relatives")) {
            question.setRelations(Utils.valuesToArray(questionNode.getProperty("exo:relatives").getValues()));
        }
        if (questionNode.hasProperty("exo:nameAttachs")) {
            question.setNameAttachs(Utils.valuesToArray(questionNode.getProperty("exo:nameAttachs").getValues()));
        }
        if (questionNode.hasProperty("exo:usersVote")) {
            question.setUsersVote(Utils.valuesToArray(questionNode.getProperty("exo:usersVote").getValues()));
        }
        if (questionNode.hasProperty("exo:markVote")) {
            question.setMarkVote(questionNode.getProperty("exo:markVote").getValue().getDouble());
        }
        if (questionNode.hasProperty("exo:emailWatching")) {
            question.setEmailsWatch(Utils.valuesToArray(questionNode.getProperty("exo:emailWatching").getValues()));
        }
        if (questionNode.hasProperty("exo:userWatching")) {
            question.setUsersWatch(Utils.valuesToArray(questionNode.getProperty("exo:userWatching").getValues()));
        }
        if (questionNode.hasProperty("exo:topicIdDiscuss")) {
            question.setTopicIdDiscuss(questionNode.getProperty("exo:topicIdDiscuss").getString());
        }
        if (questionNode.hasProperty("exo:link")) {
            question.setLink(questionNode.getProperty("exo:link").getString());
        }
        if (questionNode.hasProperty("exo:lastActivity")) {
            question.setLastActivity(questionNode.getProperty("exo:lastActivity").getString());
        }
        if (questionNode.hasProperty("exo:numberOfPublicAnswers")) {
            question.setNumberOfPublicAnswers(questionNode.getProperty("exo:numberOfPublicAnswers").getLong());
        }
        String path = questionNode.getPath();
        question.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        ArrayList<FileAttachment> listFile = new ArrayList<FileAttachment>();
        NodeIterator nodeIterator = questionNode.getNodes();
        FileAttachment attachment = null;
        String workspace = questionNode.getSession().getWorkspace().getName();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            if (!node.isNodeType("exo:faqAttachment")) continue;
            attachment = new FileAttachment();
            Node nodeFile = node.getNode("jcr:content");
            attachment.setId(node.getPath());
            attachment.setMimeType(nodeFile.getProperty("jcr:mimeType").getString());
            attachment.setNodeName(node.getName());
            attachment.setName(nodeFile.getProperty("exo:fileName").getValue().getString());
            attachment.setWorkspace(workspace);
            attachment.setPath("/" + workspace + node.getPath());
            try {
                if (nodeFile.hasProperty("jcr:data")) {
                    attachment.setSize(nodeFile.getProperty("jcr:data").getStream().available());
                } else {
                    attachment.setSize(0L);
                }
            }
            catch (Exception e) {
                attachment.setSize(0L);
                log.error((Object)"Failed to get question: ", (Throwable)e);
            }
            listFile.add(attachment);
        }
        question.setAttachMent(listFile);
        question.setAnswers(this.getAnswers(questionNode));
        question.setComments(this.getComment(questionNode));
        return question;
    }

    @Override
    public Question getQuestionById(String questionId) throws Exception {
        return this.getQuestion(this.getQuestionNodeById(questionId));
    }

    private List<String> getViewableCategoryIds(SessionProvider sessionProvider) throws Exception {
        ArrayList<String> listId = new ArrayList<String>();
        Node cateHomeNode = this.getCategoryHome(sessionProvider, null);
        StringBuffer queryString = new StringBuffer("/jcr:root").append(cateHomeNode.getPath()).append("//element(*,exo:faqCategory)[@exo:isView='true'] order by @exo:createdDate descending");
        QueryManager qm = cateHomeNode.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            listId.add(iter.nextNode().getName());
        }
        listId.add("categories");
        return listId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRetrictedCategories(String userId, List<String> usermemberships) throws Exception {
        ArrayList<String> categoryList = new ArrayList<String>();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Node faqHome = this.getFAQServiceHome(sessionProvider);
            StringBuffer queryString = new StringBuffer("/jcr:root").append(faqHome.getPath()).append("//element(*,exo:faqCategory)[@exo:userPrivate != ''] order by @exo:createdDate descending");
            QueryManager qm = faqHome.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            boolean isAudience = false;
            while (iter.hasNext()) {
                if (usermemberships.size() > 0) {
                    Node cat = iter.nextNode();
                    try {
                        String[] audiences = Utils.valuesToArray(cat.getProperty("exo:userPrivate").getValues());
                        isAudience = false;
                        for (String id : usermemberships) {
                            for (String audien : audiences) {
                                if (!id.equals(audien)) continue;
                                isAudience = true;
                                break;
                            }
                            if (!isAudience) continue;
                            break;
                        }
                        if (isAudience) continue;
                        categoryList.add(cat.getName());
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to check audience ", (Throwable)e);
                    }
                    continue;
                }
                categoryList.add(iter.nextNode().getName());
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get restricte category: ", (Throwable)e);
        }
        finally {
            sessionProvider.close();
        }
        return categoryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuestionPageList getAllQuestions() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            QuestionPageList pageList;
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqQuestion)[");
            List<String> listIds = this.getViewableCategoryIds(sProvider);
            for (int i = 0; i < listIds.size(); ++i) {
                if (i > 0) {
                    queryString.append(" or ");
                }
                queryString.append("(exo:categoryId='").append(listIds.get(i)).append("')");
            }
            queryString.append("]order by @exo:createdDate ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            QuestionPageList questionPageList = pageList = new QuestionPageList(result.getNodes(), 10L, queryString.toString(), true);
            return questionPageList;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get all questions: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuestionPageList getQuestionsNotYetAnswer(String categoryId, boolean isApproved) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            String qr = "";
            boolean isOpenQs = false;
            if (categoryId.indexOf(" ") > 0) {
                String[] strs = categoryId.split(" ");
                categoryId = strs[0];
                if (strs.length == 3) {
                    qr = strs[1];
                    isOpenQs = Boolean.parseBoolean(strs[2]);
                } else {
                    isOpenQs = Boolean.parseBoolean(strs[1]);
                }
            }
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqQuestion)[");
            if (categoryId.equals(Utils.ALL)) {
                List<String> listIds = this.getViewableCategoryIds(sProvider);
                for (int i = 0; i < listIds.size(); ++i) {
                    if (i > 0) {
                        queryString.append(" or ");
                    }
                    queryString.append("(exo:categoryId='").append(listIds.get(i)).append("')");
                }
            } else {
                queryString.append("((@exo:categoryId='").append(categoryId).append("')").append(categoryId.indexOf("/") > 0 ? " or (@exo:categoryId='" + categoryId.substring(categoryId.lastIndexOf("/") + 1) + "'))" : ")");
            }
            if (isApproved) {
                queryString.append(" and (@exo:isApproved='true')");
            }
            if (qr.length() > 0) {
                queryString.append(" and ((@exo:isApproved='true') or ").append(qr).append(")");
            }
            queryString.append("] order by @exo:createdDate ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            QuestionPageList pageList = new QuestionPageList(result.getNodes(), 10L, queryString.toString(), true);
            pageList.setNotYetAnswered(true);
            pageList.setOpenQuestion(isOpenQs);
            QuestionPageList questionPageList = pageList;
            return questionPageList;
        }
        catch (Exception e) {
            log.error((Object)"Get question not yet answer failed: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuestionPageList getPendingQuestionsByCategory(String categoryId, FAQSetting faqSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            QuestionPageList pageList;
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = null;
            if (categoryId == null || categoryId.trim().length() < 1) {
                categoryId = "null";
            }
            queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqQuestion)[((@exo:categoryId='").append(categoryId).append("')").append(categoryId.indexOf("/") > 0 ? " or (@exo:categoryId='" + categoryId.substring(categoryId.lastIndexOf("/") + 1) + "'))" : ")").append(" and (@exo:isActivated='true') and (@exo:isApproved='false')").append("]");
            queryString.append("order by ");
            if (faqSetting.isSortQuestionByVote()) {
                queryString.append("@exo:markVote descending, ");
            }
            if (faqSetting.getOrderBy().equals("created")) {
                queryString.append("@exo:createdDate ");
            } else {
                queryString.append("@exo:title ");
            }
            if (faqSetting.getOrderType().equals("asc")) {
                queryString.append("ascending");
            } else {
                queryString.append("descending");
            }
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            QuestionPageList questionPageList = pageList = new QuestionPageList(result.getNodes(), 10L, queryString.toString(), true);
            return questionPageList;
        }
        catch (Exception e) {
            log.error((Object)"Get pedding question through category failed: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuestionPageList getQuestionsByCatetory(String categoryId, FAQSetting faqSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            QuestionPageList pageList;
            Node categoryNode;
            String id;
            if (categoryId == null || "categories".equals(categoryId)) {
                id = "categories";
                categoryId = "categories";
                categoryNode = this.getCategoryHome(sProvider, null);
            } else {
                id = categoryId.substring(categoryId.lastIndexOf("/") + 1);
                categoryNode = this.getFAQServiceHome(sProvider).getNode(categoryId);
            }
            categoryNode = this.getFAQServiceHome(sProvider).getNode(categoryId);
            QueryManager qm = categoryNode.getSession().getWorkspace().getQueryManager();
            String userId = faqSetting.getCurrentUser();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryNode.getPath()).append("/").append(Utils.QUESTION_HOME).append("/element(*,exo:faqQuestion)[(@exo:categoryId='").append(id).append("') and (@exo:isActivated='true')");
            if (!faqSetting.isCanEdit()) {
                queryString.append(" and (@exo:isApproved='true'");
                if (userId != null && userId.length() > 0 && faqSetting.getDisplayMode().equals("both")) {
                    queryString.append(" or @exo:author='").append(userId).append("')");
                } else {
                    queryString.append(")");
                }
            } else if (faqSetting.getDisplayMode().equals("approved")) {
                queryString.append(" and (@exo:isApproved='true')");
            }
            queryString.append("] order by ");
            if (faqSetting.isSortQuestionByVote()) {
                queryString.append("@exo:markVote descending, ");
            }
            if (faqSetting.getOrderBy().equals("created")) {
                queryString.append("@exo:createdDate ");
            } else {
                queryString.append("@exo:title ");
            }
            if (faqSetting.getOrderType().equals("asc")) {
                queryString.append("ascending");
            } else {
                queryString.append("descending");
            }
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            QuestionPageList questionPageList = pageList = new QuestionPageList(result.getNodes(), 10L, queryString.toString(), true);
            return questionPageList;
        }
        catch (Exception e) {
            log.debug((Object)"Getting question through category failed: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuestionPageList getAllQuestionsByCatetory(String categoryId, FAQSetting faqSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            QuestionPageList pageList;
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = null;
            queryString = faqSetting.getDisplayMode().equals("approved") ? new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqQuestion)[(@exo:categoryId='").append(categoryId).append("')").append(" and (@exo:isApproved='true')").append("]") : new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqQuestion)[@exo:categoryId='").append(categoryId).append("'").append("]");
            queryString.append("order by ");
            if (faqSetting.isSortQuestionByVote()) {
                queryString.append("@exo:markVote descending, ");
            }
            if (faqSetting.getOrderBy().equals("created")) {
                queryString.append("@exo:createdDate ");
            } else {
                queryString.append("@exo:title ");
            }
            if (faqSetting.getOrderType().equals("asc")) {
                queryString.append("ascending");
            } else {
                queryString.append("descending");
            }
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            QuestionPageList questionPageList = pageList = new QuestionPageList(result.getNodes(), 10L, queryString.toString(), true);
            return questionPageList;
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get all question through category: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuestionPageList getQuestionsByListCatetory(List<String> listCategoryId, boolean isNotYetAnswer) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqQuestion) [");
            queryString.append(" (");
            int i = 0;
            for (String categoryId : listCategoryId) {
                if (i > 0) {
                    queryString.append(" or ");
                }
                queryString.append("(@exo:categoryId='").append(categoryId).append("')");
                ++i;
            }
            queryString.append(")]");
            queryString.append(" order by @exo:createdDate ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            QuestionPageList pageList = null;
            pageList = new QuestionPageList(result.getNodes(), 10L, queryString.toString(), true);
            pageList.setNotYetAnswered(isNotYetAnswer);
            QuestionPageList questionPageList = pageList;
            return questionPageList;
        }
        catch (Exception e) {
            log.debug((Object)"Failed get questions through list of category: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Question> getQuickQuestionsByListCatetory(List<String> listCategoryId, boolean isNotYetAnswer) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Question> questions = new ArrayList<Question>();
        try {
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqQuestion)[(");
            int i = 0;
            for (String categoryId : listCategoryId) {
                if (i > 0) {
                    queryString.append(" or ");
                }
                queryString.append("(@exo:categoryId='").append(categoryId).append("')");
                ++i;
            }
            queryString.append(")]order by @exo:createdDate ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                questions.add(this.getQuickQuestion(iter.nextNode()));
            }
        }
        catch (Exception e) {
            log.debug((Object)"Getting quick questions through list of category failed: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return questions;
    }

    private Question getQuickQuestion(Node questionNode) throws Exception {
        Question question = new Question();
        question.setId(questionNode.getName());
        question.setCategoryId(questionNode.getProperty("exo:categoryId").getString());
        String path = questionNode.getPath();
        question.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        question.setQuestion(questionNode.getProperty("exo:title").getString());
        return question;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCategoryPathOfQuestion(String questionPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        String path = "";
        Node faqHome = null;
        try {
            faqHome = this.getFAQServiceHome(sProvider);
            Node question = faqHome.getNode(questionPath);
            Node subCat = question.getParent().getParent();
            String pathName = "";
            while (!subCat.getName().equals("categories")) {
                pathName = "/" + subCat.getProperty("exo:name").getString() + pathName;
                subCat = subCat.getParent();
            }
            try {
                pathName = faqHome.getProperty("exo:name").getString() + pathName;
            }
            catch (Exception e) {
                pathName = "home" + pathName;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Getting category path of the question failed: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveQuestions(List<String> questions, String destCategoryId, String questionLink, FAQSetting faqSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node destQuestionHome;
            Node faqHome = this.getFAQServiceHome(sProvider);
            String homePath = faqHome.getPath();
            try {
                destQuestionHome = faqHome.getNode(destCategoryId + "/" + Utils.QUESTION_HOME);
            }
            catch (Exception e) {
                destQuestionHome = faqHome.getNode(destCategoryId).addNode(Utils.QUESTION_HOME, "exo:faqQuestionHome");
                faqHome.getSession().save();
            }
            for (String id : questions) {
                try {
                    Node destCateNode = faqHome.getNode(id).getParent();
                    faqHome.getSession().move(homePath + "/" + id, destQuestionHome.getPath() + id.substring(id.lastIndexOf("/")));
                    faqHome.getSession().save();
                    Node questionNode = faqHome.getNode(destCategoryId + "/" + Utils.QUESTION_HOME + id.substring(id.lastIndexOf("/")));
                    String catId = destCategoryId.substring(destCategoryId.lastIndexOf("/") + 1);
                    questionNode.setProperty("exo:categoryId", catId);
                    NodeIterator iter = questionNode.getNodes();
                    while (iter.hasNext()) {
                        Node attNode = iter.nextNode();
                        if (!attNode.isNodeType("exo:faqAttachment")) continue;
                        attNode.getNode("jcr:content").setProperty("exo:categoryId", catId);
                    }
                    this.updateAnswers(questionNode, catId);
                    this.updateComments(questionNode, catId);
                    questionNode.save();
                    try {
                        this.sendNotifyMoveQuestion(destCateNode, questionNode, catId, questionLink, faqSetting);
                    }
                    catch (Exception e) {
                    }
                }
                catch (ItemNotFoundException ex) {}
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to remove question: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private void sendNotifyMoveQuestion(Node destCateNode, Node questionNode, String cateId, String link, FAQSetting faqSetting) throws Exception {
        String contentMail = faqSetting.getEmailMoveQuestion();
        String categoryName = null;
        try {
            categoryName = questionNode.getParent().getParent().getProperty("exo:name").getString();
        }
        catch (Exception e) {
            categoryName = "Root";
        }
        Message message = new Message();
        message.setMimeType(MIMETYPE_TEXTHTML);
        message.setFrom(questionNode.getProperty("exo:author").getString());
        message.setSubject(faqSetting.getEmailSettingSubject() + ": " + questionNode.getProperty("exo:title").getString());
        if (categoryName == null || categoryName.trim().length() < 1) {
            categoryName = "Root";
        }
        String questionDetail = questionNode.getProperty("exo:title").getString();
        if (questionNode.hasProperty("exo:name")) {
            questionDetail = questionDetail + "<br/> <span style=\"font-weight:normal\"> " + questionNode.getProperty("exo:name").getString() + "</span>";
        }
        contentMail = contentMail.replace("&questionContent_", questionDetail).replace("&categoryName_", categoryName).replace("&questionLink_", link);
        message.setBody(contentMail);
        HashSet<String> emails = new HashSet<String>();
        emails.addAll(this.calculateMoveEmail(destCateNode));
        emails.addAll(this.calculateMoveEmail(questionNode.getParent()));
        emails.add(questionNode.getProperty("exo:email").getString());
        this.sendEmailNotification(new ArrayList<String>(emails), message);
    }

    private Set<String> calculateMoveEmail(Node node) throws Exception {
        HashSet<String> set = new HashSet<String>();
        while (!node.getName().equals("categories")) {
            if (node.isNodeType("exo:faqWatching")) {
                set.addAll(Utils.valuesToList(node.getProperty("exo:emailWatching").getValues()));
            }
            node = node.getParent();
        }
        return set;
    }

    private void updateComments(Node question, String catId) throws Exception {
        try {
            QueryManager qm = question.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + question.getPath() + "//element(*,exo:comment)");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                iter.nextNode().setProperty("exo:categoryId", catId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Updating comments failed: ", (Throwable)e);
        }
    }

    private void updateAnswers(Node question, String catId) throws Exception {
        try {
            QueryManager qm = question.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + question.getPath() + "//element(*,exo:answer)");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                iter.nextNode().setProperty("exo:categoryId", catId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Updating answers failed: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeStatusCategoryView(List<String> listCateIds) throws Exception {
        if (listCateIds == null || listCateIds.size() < 1) {
            return;
        }
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node faqHome = this.getFAQServiceHome(sProvider);
            for (String id : listCateIds) {
                Node cat;
                cat.setProperty("exo:isView", !(cat = faqHome.getNode(id)).getProperty("exo:isView").getBoolean());
            }
            faqHome.save();
        }
        catch (Exception e) {
            log.error((Object)"Changing status category view failed: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxindexCategory(String parentId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        long max = 0L;
        try {
            NodeIterator iter = this.getFAQServiceHome(sProvider).getNode(parentId == null ? "categories" : parentId).getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (!node.isNodeType("exo:faqCategory")) continue;
                ++max;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get max index category", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return max;
    }

    private void saveCategory(Node categoryNode, Category category, boolean isNew, SessionProvider sProvider) throws Exception {
        Node parentCategory;
        HashMap<String, String> moderators = new HashMap<String, String>();
        if (!categoryNode.getName().equals("categories") && (parentCategory = categoryNode.getParent()).hasProperty("exo:moderators")) {
            for (Value vl : parentCategory.getProperty("exo:moderators").getValues()) {
                moderators.put(vl.getString(), vl.getString());
            }
        }
        if (category.getId() != null) {
            categoryNode.setProperty("exo:id", category.getId());
            categoryNode.setProperty("exo:createdDate", GregorianCalendar.getInstance());
            categoryNode.setProperty("exo:isView", category.isView());
        }
        categoryNode.setProperty("exo:index", category.getIndex());
        categoryNode.setProperty("exo:name", category.getName());
        categoryNode.setProperty("exo:description", category.getDescription());
        for (String mod : category.getModerators()) {
            moderators.put(mod, mod);
        }
        categoryNode.setProperty("exo:moderators", moderators.values().toArray(new String[0]));
        categoryNode.setProperty("exo:isModerateQuestions", category.isModerateQuestions());
        categoryNode.setProperty("exo:viewAuthorInfor", category.isViewAuthorInfor());
        categoryNode.setProperty("exo:isModerateAnswers", category.isModerateAnswers());
        categoryNode.setProperty("exo:userPrivate", category.getUserPrivate());
        if (!isNew) {
            try {
                this.updateModeratorForChildCategories(categoryNode, moderators);
            }
            catch (Exception e) {
                log.debug((Object)"Updating moderator for child category failed: ", (Throwable)e);
            }
        }
        if (categoryNode.isNew()) {
            categoryNode.getSession().save();
        } else {
            categoryNode.save();
        }
    }

    private void updateModeratorForChildCategories(Node currentCategory, Map<String, String> moderators) throws Exception {
        HashMap<String, String> modMap = new HashMap<String, String>();
        NodeIterator iter = currentCategory.getNodes();
        while (iter.hasNext()) {
            Node cat = iter.nextNode();
            if (!cat.isNodeType("exo:faqCategory")) continue;
            modMap.clear();
            modMap.putAll(moderators);
            for (Value vl : cat.getProperty("exo:moderators").getValues()) {
                modMap.put(vl.getString(), vl.getString());
            }
            cat.setProperty("exo:moderators", modMap.values().toArray(new String[0]));
            cat.save();
            if (!cat.hasNodes()) continue;
            this.updateModeratorForChildCategories(cat, modMap);
        }
    }

    private void resetIndex(Node category, long index) throws Exception {
        QueryManager qm = category.getSession().getWorkspace().getQueryManager();
        Node parent = category.getParent();
        StringBuffer queryString = new StringBuffer("/jcr:root" + parent.getPath());
        queryString.append("/element(*,exo:faqCategory)order by @exo:index ascending, @exo:dateModified descending");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        if (iter.getSize() >= index) {
            long i = 1L;
            while (iter.hasNext()) {
                Node cat = iter.nextNode();
                cat.setProperty("exo:index", i);
                ++i;
            }
            parent.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveCategory(String parentId, Category cat, boolean isAddNew) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node newCategory;
            if (isAddNew) {
                Node parentNode = this.getFAQServiceHome(sProvider).getNode(parentId);
                newCategory = parentNode.addNode(cat.getId(), "exo:faqCategory");
                newCategory.addMixin("mix:faqSubCategory");
                Node questionHome = newCategory.addNode(Utils.QUESTION_HOME, "exo:faqQuestionHome");
                this.addRSSListener(questionHome);
            } else {
                newCategory = this.getFAQServiceHome(sProvider).getNode(cat.getPath());
            }
            this.saveCategory(newCategory, cat, isAddNew, sProvider);
            this.resetIndex(newCategory, cat.getIndex());
        }
        catch (Exception e) {
            log.error((Object)"Failed to save category: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private List<Cate> listingSubTree(Node currentCategory, int i) throws Exception {
        int j = i;
        ++j;
        ArrayList<Cate> cateList = new ArrayList<Cate>();
        NodeIterator iter = currentCategory.getNodes();
        while (iter.hasNext()) {
            Node cat = iter.nextNode();
            if (!cat.isNodeType("exo:faqCategory")) continue;
            Cate cate = new Cate();
            cate.setCategory(this.getCategory(cat));
            cate.setDeft(i);
            cateList.add(cate);
            if (!cat.hasNodes()) continue;
            cateList.addAll(this.listingSubTree(cat, j));
        }
        return cateList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Cate> listingCategoryTree() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node cateHome = this.getCategoryHome(sProvider, null);
            int i = 1;
            ArrayList<Cate> cateList = new ArrayList<Cate>();
            cateList.addAll(this.listingSubTree(cateHome, i));
            ArrayList<Cate> arrayList = cateList;
            return arrayList;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCategory(String categoryId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node faqHome = this.getFAQServiceHome(sProvider);
            faqHome.getNode(categoryId).remove();
            faqHome.save();
        }
        catch (Exception e) {
            log.error((Object)("Can not remove category has id: " + categoryId));
        }
        finally {
            sProvider.close();
        }
    }

    private Category getCategory(Node categoryNode) throws Exception {
        if (categoryNode == null) {
            return null;
        }
        Category category = new Category();
        category.setId(categoryNode.getName());
        if (categoryNode.hasProperty("exo:name")) {
            category.setName(categoryNode.getProperty("exo:name").getString());
        }
        if (categoryNode.hasProperty("exo:description")) {
            category.setDescription(categoryNode.getProperty("exo:description").getString());
        }
        if (categoryNode.hasProperty("exo:createdDate")) {
            category.setCreatedDate(categoryNode.getProperty("exo:createdDate").getDate().getTime());
        }
        if (categoryNode.hasProperty("exo:moderators")) {
            category.setModerators(Utils.valuesToArray(categoryNode.getProperty("exo:moderators").getValues()));
        }
        if (categoryNode.hasProperty("exo:userPrivate")) {
            category.setUserPrivate(Utils.valuesToArray(categoryNode.getProperty("exo:userPrivate").getValues()));
        }
        if (categoryNode.hasProperty("exo:isModerateQuestions")) {
            category.setModerateQuestions(categoryNode.getProperty("exo:isModerateQuestions").getBoolean());
        }
        if (categoryNode.hasProperty("exo:isModerateAnswers")) {
            category.setModerateAnswers(categoryNode.getProperty("exo:isModerateAnswers").getBoolean());
        }
        if (categoryNode.hasProperty("exo:viewAuthorInfor")) {
            category.setViewAuthorInfor(categoryNode.getProperty("exo:viewAuthorInfor").getBoolean());
        }
        if (categoryNode.hasProperty("exo:index")) {
            category.setIndex(categoryNode.getProperty("exo:index").getLong());
        }
        if (categoryNode.hasProperty("exo:isView")) {
            category.setView(categoryNode.getProperty("exo:isView").getBoolean());
        }
        String path = categoryNode.getPath();
        category.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
        return category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Category getCategoryById(String categoryId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Category category = this.getCategory(this.getCategoryNodeById(sProvider, categoryId));
            return category;
        }
        catch (Exception e) {
            log.debug((Object)("Category not found " + categoryId));
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Category> findCategoriesByName(String categoryName) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqCategory)[@exo:name='").append(categoryName).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            ArrayList<Category> result = new ArrayList<Category>();
            while (iter.hasNext()) {
                result.add(this.getCategory(iter.nextNode()));
            }
            ArrayList<Category> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve categories by name " + categoryName), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getListCateIdByModerator(String user) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryHome.getParent().getPath()).append("//element(*,exo:faqCategory)[@exo:moderators='").append(user.trim()).append("'").append(" and @exo:isView='true' ]");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ArrayList<String> listCateId = new ArrayList<String>();
            while (iter.hasNext()) {
                Node cate = iter.nextNode();
                try {
                    listCateId.add(cate.getName() + cate.getProperty("exo:name").getString());
                }
                catch (Exception e) {
                    log.debug((Object)("Getting property of " + cate + " node failed: "), (Throwable)e);
                }
            }
            ArrayList<String> arrayList = listCateId;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get list of CateID through Moderator: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Category> getAllCategories() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqCategory)");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ArrayList<Category> catList = new ArrayList<Category>();
            while (iter.hasNext()) {
                catList.add(this.getCategory(iter.nextNode()));
            }
            ArrayList<Category> arrayList = catList;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)"Getting all category failed: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long existingCategories() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqCategory)");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            result.getNodes().getSize();
        }
        catch (Exception e) {
            log.error((Object)"Failed to check existing categories", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getCategoryNodeById(String categoryId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node = this.getCategoryNodeById(sProvider, categoryId);
            return node;
        }
        catch (Exception e) {
            log.error((Object)"Getting node failed: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    private Node getCategoryNodeById(SessionProvider sProvider, String categoryId) throws Exception {
        try {
            Node faqHome = this.getFAQServiceHome(sProvider);
            return faqHome.getNode(categoryId);
        }
        catch (PathNotFoundException e) {
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqCategory)").append("[fn:name()='").append(categoryId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            if (iter.getSize() != 0L) {
                return iter.nextNode();
            }
            return null;
        }
    }

    @Override
    public List<Category> getSubCategories(String categoryId, FAQSetting faqSetting, boolean isGetAll, List<String> limitedUsers) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Category> catList = new ArrayList<Category>();
        try {
            PropertyReader reader;
            List userPrivates;
            Node parentCategory = categoryId == null || categoryId.equals("categories") ? this.getCategoryHome(sProvider, null) : this.getFAQServiceHome(sProvider).getNode(categoryId);
            if (!(faqSetting.isAdmin() || (userPrivates = (reader = new PropertyReader(parentCategory)).list("exo:userPrivate", new ArrayList())).isEmpty() || Utils.hasPermission(limitedUsers, userPrivates))) {
                ArrayList<Category> arrayList = catList;
                return arrayList;
            }
            StringBuffer queryString = new StringBuffer("/jcr:root").append(parentCategory.getPath());
            if (faqSetting.isAdmin()) {
                queryString.append("/element(*,exo:faqCategory) [@exo:isView='true'] order by @exo:index ascending");
            } else {
                queryString.append("/element(*,exo:faqCategory)[@exo:isView='true' and ( not(@exo:userPrivate) or @exo:userPrivate=''");
                if (limitedUsers != null) {
                    for (String id : limitedUsers) {
                        queryString.append(" or @exo:userPrivate = '").append(id).append("' ");
                        queryString.append(" or @exo:moderators = '").append(id).append("' ");
                    }
                }
                queryString.append(" )] order by @exo:index");
            }
            QueryManager qm = parentCategory.getSession().getWorkspace().getQueryManager();
            String qString = queryString.toString();
            Query query = qm.createQuery(qString, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                catList.add(this.getCategory(iter.nextNode()));
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            sProvider.close();
        }
        return catList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getCategoryInfo(String categoryId, FAQSetting faqSetting) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        long[] cateInfo = new long[]{0L, 0L, 0L, 0L};
        try {
            Node parentCategory = this.getFAQServiceHome(sProvider).getNode(categoryId);
            String id = categoryId.indexOf("/") > 0 ? categoryId.substring(categoryId.lastIndexOf("/") + 1) : categoryId;
            NodeIterator iter = parentCategory.getNodes();
            cateInfo[0] = iter.getSize();
            QueryManager qm = parentCategory.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(parentCategory.getPath()).append("//element(*,exo:faqQuestion)[(@exo:categoryId='").append(id).append("') and (@exo:isActivated='true')").append("]").append("order by @exo:createdDate ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            cateInfo[1] = nodeIterator.getSize();
            Node questionNode = null;
            boolean questionIsApproved = true;
            boolean isShow = true;
            boolean onlyGetApproved = faqSetting.getDisplayMode().equals("approved");
            while (nodeIterator.hasNext()) {
                questionNode = nodeIterator.nextNode();
                questionIsApproved = questionNode.getProperty("exo:isApproved").getBoolean();
                boolean bl = isShow = questionIsApproved || (faqSetting.isCanEdit() || questionNode.getProperty("exo:author").getString().equals(faqSetting.getCurrentUser())) && !onlyGetApproved;
                if (!questionIsApproved) {
                    cateInfo[3] = cateInfo[3] + 1L;
                    if (!isShow) {
                        cateInfo[1] = cateInfo[1] - 1L;
                    }
                }
                if (!isShow || this.hasAnswerInQuestion(qm, questionNode)) continue;
                cateInfo[2] = cateInfo[2] + 1L;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get category info: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return cateInfo;
    }

    private boolean hasAnswerInQuestion(QueryManager qm, Node questionNode) throws Exception {
        StringBuffer queryString = new StringBuffer("/jcr:root").append(questionNode.getPath()).append("//element(*,exo:answer)[(@exo:approveResponses='true') and (@exo:activateResponses='true')]");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        return iter.getSize() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveCategory(String categoryId, String destCategoryId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node faqHome = this.getFAQServiceHome(sProvider);
            Node srcNode = faqHome.getNode(categoryId);
            String srcPath = srcNode.getPath();
            String destPath = faqHome.getPath() + "/" + destCategoryId + "/" + srcNode.getName();
            faqHome.getSession().move(srcPath, destPath);
            faqHome.getSession().save();
            Node destNode = faqHome.getNode(destCategoryId + "/" + srcNode.getName());
            destNode.setProperty("exo:index", destNode.getParent().getNodes().getSize());
            destNode.save();
        }
        catch (ItemExistsException e) {
            throw e;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWatchCategory(String id, Watch watch) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node faqHome = this.getFAQServiceHome(sProvider);
            HashMap<String, String> watchs = new HashMap<String, String>();
            Node watchingNode = faqHome.getNode(id);
            if (watchingNode.isNodeType("exo:faqWatching")) {
                Value[] emails = watchingNode.getProperty("exo:emailWatching").getValues();
                Value[] users = watchingNode.getProperty("exo:userWatching").getValues();
                if (emails != null && users != null) {
                    for (int i = 0; i < users.length; ++i) {
                        watchs.put(users[i].getString(), emails[i].getString());
                    }
                }
                watchs.put(watch.getUser(), watch.getEmails());
                watchingNode.setProperty("exo:emailWatching", watchs.values().toArray(new String[0]));
                watchingNode.setProperty("exo:userWatching", watchs.keySet().toArray(new String[0]));
            } else {
                watchingNode.addMixin("exo:faqWatching");
                watchingNode.setProperty("exo:emailWatching", new String[]{watch.getEmails()});
                watchingNode.setProperty("exo:userWatching", new String[]{watch.getUser()});
            }
            watchingNode.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to add watch category: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuestionPageList getListMailInWatch(String categoryId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            QuestionPageList pageList;
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqCategory)[@exo:id='").append(categoryId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            QuestionPageList questionPageList = pageList = new QuestionPageList(result.getNodes(), 5L, queryString.toString(), true);
            return questionPageList;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get list of mail watch: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Watch> getWatchByCategory(String categoryId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Watch> listWatches = new ArrayList<Watch>();
        try {
            Node category = this.getFAQServiceHome(sProvider).getNode(categoryId);
            String[] userWatch = null;
            String[] emails = null;
            if (category.hasProperty("exo:emailWatching")) {
                emails = Utils.valuesToArray(category.getProperty("exo:emailWatching").getValues());
            }
            if (category.hasProperty("exo:userWatching")) {
                userWatch = Utils.valuesToArray(category.getProperty("exo:userWatching").getValues());
            }
            if (userWatch != null && userWatch.length > 0) {
                Watch watch = new Watch();
                for (int i = 0; i < userWatch.length; ++i) {
                    watch = new Watch();
                    watch.setEmails(emails[i]);
                    watch.setUser(userWatch[i]);
                    listWatches.add(watch);
                }
            }
            ArrayList<Watch> arrayList = listWatches;
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get watch through category: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return listWatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasWatch(String categoryPath) {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node cat = this.getFAQServiceHome(sProvider).getNode(categoryPath);
            if (new PropertyReader(cat).strings("exo:userWatching", new String[0]).length > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to check has watch", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWatchQuestion(String questionId, Watch watch, boolean isNew) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        HashMap<String, String> watchMap = new HashMap<String, String>();
        try {
            Node questionNode = this.getFAQServiceHome(sProvider).getNode(questionId);
            if (questionNode.isNodeType("exo:faqWatching")) {
                Value[] values = questionNode.getProperty("exo:emailWatching").getValues();
                Value[] users = questionNode.getProperty("exo:userWatching").getValues();
                for (int i = 0; i < users.length; ++i) {
                    watchMap.put(users[i].getString(), values[i].getString());
                }
                watchMap.put(watch.getUser(), watch.getEmails());
                questionNode.setProperty("exo:emailWatching", watchMap.values().toArray(new String[0]));
                questionNode.setProperty("exo:userWatching", watchMap.keySet().toArray(new String[0]));
                questionNode.save();
            } else {
                questionNode.addMixin("exo:faqWatching");
                questionNode.setProperty("exo:emailWatching", new String[]{watch.getEmails()});
                questionNode.setProperty("exo:userWatching", new String[]{watch.getUser()});
                questionNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to add a watch question: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Watch> getWatchByQuestion(String questionId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Watch> listWatches = new ArrayList<Watch>();
        try {
            Node category = this.getFAQServiceHome(sProvider).getNode(questionId);
            if (category.isNodeType("exo:faqWatching")) {
                String[] userWatch = null;
                String[] emails = null;
                if (category.hasProperty("exo:emailWatching")) {
                    emails = Utils.valuesToArray(category.getProperty("exo:emailWatching").getValues());
                }
                if (category.hasProperty("exo:userWatching")) {
                    userWatch = Utils.valuesToArray(category.getProperty("exo:userWatching").getValues());
                }
                if (userWatch != null && userWatch.length > 0) {
                    Watch watch = new Watch();
                    for (int i = 0; i < userWatch.length; ++i) {
                        watch = new Watch();
                        watch.setEmails(emails[i]);
                        watch.setUser(userWatch[i]);
                        listWatches.add(watch);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get watch through question: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return listWatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuestionPageList getWatchedCategoryByUser(String userId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            QuestionPageList pageList;
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = null;
            queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqCategory)[(@exo:userWatching='").append(userId).append("')]");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            QuestionPageList questionPageList = pageList = new QuestionPageList(result.getNodes(), 10L, queryString.toString(), true);
            return questionPageList;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get watched category through user: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserWatched(String userId, String cateId) {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node faqHome = this.getFAQServiceHome(sProvider);
            Node cate = faqHome.getNode(cateId);
            List list = new PropertyReader(cate).list("exo:userWatching", new ArrayList());
            for (String vl : list) {
                if (!vl.equals(userId)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to check user watched", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWatchedSubCategory(String userId, String cateId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> watchedSub = new ArrayList<String>();
        try {
            Node faqHome = this.getFAQServiceHome(sProvider);
            Node category = faqHome.getNode(cateId);
            QueryManager qm = faqHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(category.getPath()).append("/element(*,exo:faqCategory)[(@exo:userWatching='").append(userId).append("')]");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                watchedSub.add(iter.nextNode().getName());
            }
        }
        catch (Exception e) {
            log.error((Object)"Getting watched sub category failed: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return watchedSub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuestionPageList getListQuestionsWatch(FAQSetting faqSetting, String currentUser) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            QuestionPageList pageList;
            Node categoryHome = this.getCategoryHome(sProvider, null);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:faqQuestion)[(@exo:userWatching='").append(currentUser).append("')");
            if (faqSetting.getDisplayMode().equals("approved")) {
                queryString.append(" and (@exo:isApproved='true')");
            }
            if (!faqSetting.isAdmin()) {
                queryString.append(" and (@exo:isActivated='true')");
            }
            queryString.append("] order by ");
            if (faqSetting.isSortQuestionByVote()) {
                queryString.append("@exo:markVote descending, ");
            }
            if (faqSetting.getOrderBy().equals("created")) {
                queryString.append("@exo:createdDate ");
            } else {
                queryString.append("@exo:title ");
            }
            if (faqSetting.getOrderType().equals("asc")) {
                queryString.append("ascending");
            } else {
                queryString.append("descending");
            }
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            QuestionPageList questionPageList = pageList = new QuestionPageList(result.getNodes(), 10L, queryString.toString(), true);
            return questionPageList;
        }
        catch (Exception e) {
            log.error((Object)"Failed to get list of question watch: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCategoryWatch(String categoryId, String user) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node category = this.getFAQServiceHome(sProvider).getNode(categoryId);
            HashMap<String, String> emailMap = new HashMap<String, String>();
            Value[] emailValues = category.getProperty("exo:emailWatching").getValues();
            Value[] userValues = category.getProperty("exo:userWatching").getValues();
            for (int i = 0; i < emailValues.length; ++i) {
                emailMap.put(userValues[i].getString(), emailValues[i].getString());
            }
            emailMap.remove(user);
            category.setProperty("exo:userWatching", emailMap.keySet().toArray(new String[0]));
            category.setProperty("exo:emailWatching", emailMap.values().toArray(new String[0]));
            category.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to deleted category watch", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unWatchCategory(String categoryId, String user) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node category = this.getFAQServiceHome(sProvider).getNode(categoryId);
            HashMap<String, String> userMap = new HashMap<String, String>();
            Value[] emailValues = category.getProperty("exo:emailWatching").getValues();
            Value[] userValues = category.getProperty("exo:userWatching").getValues();
            for (int i = 0; i < userValues.length; ++i) {
                userMap.put(userValues[i].getString(), emailValues[i].getString());
            }
            userMap.remove(user);
            category.setProperty("exo:emailWatching", userMap.values().toArray(new String[0]));
            category.setProperty("exo:userWatching", userMap.keySet().toArray(new String[0]));
            category.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to unWatch category", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unWatchQuestion(String questionId, String user) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node question = this.getFAQServiceHome(sProvider).getNode(questionId);
            HashMap<String, String> userMap = new HashMap<String, String>();
            Value[] emailValues = question.getProperty("exo:emailWatching").getValues();
            Value[] userValues = question.getProperty("exo:userWatching").getValues();
            for (int i = 0; i < userValues.length; ++i) {
                userMap.put(userValues[i].getString(), emailValues[i].getString());
            }
            userMap.remove(user);
            question.setProperty("exo:emailWatching", userMap.values().toArray(new String[0]));
            question.setProperty("exo:userWatching", userMap.keySet().toArray(new String[0]));
            question.save();
        }
        catch (Exception e) {
            log.error((Object)"Unwatching question failed: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    @Override
    public List<ObjectSearchResult> getSearchResults(FAQEventQuery eventQuery) throws Exception {
        block81: {
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            eventQuery.setViewingCategories(this.getViewableCategoryIds(sProvider));
            List<Object> retrictedCategoryList = new ArrayList();
            if (!eventQuery.isAdmin()) {
                retrictedCategoryList = this.getRetrictedCategories(eventQuery.getUserId(), eventQuery.getUserMembers());
            }
            Node categoryHome = this.getCategoryHome(sProvider, null);
            eventQuery.setPath(categoryHome.getPath());
            try {
                QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
                Query query = qm.createQuery(eventQuery.getQuery(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                Node nodeObj = null;
                if (eventQuery.getType().equals("faqCategory")) {
                    Node cat;
                    Node results = new ArrayList();
                    block16: while (iter.hasNext()) {
                        if (eventQuery.isAdmin()) {
                            cat = iter.nextNode();
                            if (retrictedCategoryList.size() > 0) {
                                String path = cat.getPath();
                                for (String string : retrictedCategoryList) {
                                    if (path.indexOf(string) <= 0) continue;
                                    results.add(this.getResultObj(cat));
                                    continue block16;
                                }
                                continue;
                            }
                            results.add(this.getResultObj(cat));
                            continue;
                        }
                        results.add(this.getResultObj(iter.nextNode()));
                    }
                    cat = results;
                    return cat;
                }
                if (eventQuery.getType().equals("faqQuestion")) {
                    boolean bl;
                    boolean bl2;
                    ArrayList<ObjectSearchResult> results = new ArrayList<ObjectSearchResult>();
                    HashMap<String, Node> mergeQuestion = new HashMap<String, Node>();
                    HashMap mergeQuestion2 = new HashMap();
                    ArrayList<Node> listQuestion = new ArrayList<Node>();
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    HashMap<String, Node> listAnswerandComment = new HashMap<String, Node>();
                    while (iter.hasNext()) {
                        nodeObj = iter.nextNode();
                        if (!eventQuery.isAdmin()) {
                            try {
                                String string;
                                Node node;
                                Node node2;
                                boolean isCanView;
                                if (nodeObj.isNodeType("exo:faqQuestion") && (nodeObj.getProperty("exo:isApproved").getBoolean() && nodeObj.getProperty("exo:isActivated").getBoolean() || nodeObj.getProperty("exo:author").getString().equals(eventQuery.getUserId()) && nodeObj.getProperty("exo:isActivated").getBoolean())) {
                                    if (retrictedCategoryList.size() > 0) {
                                        String string2 = nodeObj.getPath();
                                        isCanView = true;
                                        for (String string3 : retrictedCategoryList) {
                                            if (string2.indexOf(string3) <= 0) continue;
                                            isCanView = false;
                                            break;
                                        }
                                        if (isCanView) {
                                            listQuestion.add(nodeObj);
                                        }
                                    } else {
                                        listQuestion.add(nodeObj);
                                    }
                                }
                                if (nodeObj.isNodeType("exo:faqResource") && ((node2 = nodeObj.getParent().getParent()).getProperty("exo:isApproved").getBoolean() && node2.getProperty("exo:isActivated").getBoolean() || node2.getProperty("exo:author").getString().equals(eventQuery.getUserId()) && node2.getProperty("exo:isActivated").getBoolean())) {
                                    if (retrictedCategoryList.size() > 0) {
                                        isCanView = true;
                                        String path2 = nodeObj.getPath();
                                        for (String string4 : retrictedCategoryList) {
                                            if (path2.indexOf(string4) <= 0) continue;
                                            isCanView = false;
                                            break;
                                        }
                                        if (isCanView) {
                                            listQuestion.add(node2);
                                        }
                                    } else {
                                        listQuestion.add(node2);
                                    }
                                }
                                if (nodeObj.isNodeType("exo:faqLanguage") && ((node = nodeObj.getParent().getParent()).getProperty("exo:isApproved").getBoolean() && node.getProperty("exo:isActivated").getBoolean() || node.getProperty("exo:author").getString().equals(eventQuery.getUserId()) && node.getProperty("exo:isActivated").getBoolean())) {
                                    if (retrictedCategoryList.size() > 0) {
                                        isCanView = true;
                                        String path = nodeObj.getPath();
                                        for (String string5 : retrictedCategoryList) {
                                            if (path.indexOf(string5) <= 0) continue;
                                            isCanView = false;
                                            break;
                                        }
                                        if (isCanView) {
                                            arrayList.add(nodeObj);
                                        }
                                    } else {
                                        arrayList.add(nodeObj);
                                    }
                                }
                                if (!nodeObj.isNodeType("exo:answer") && !nodeObj.isNodeType("exo:comment") || listAnswerandComment.containsKey(string = nodeObj.getProperty("exo:questionId").getString())) continue;
                                Node nodeQuestion2 = nodeObj.getParent().getParent();
                                if (nodeQuestion2.isNodeType("exo:faqQuestion")) {
                                    if ((!nodeQuestion2.getProperty("exo:isApproved").getBoolean() || !nodeQuestion2.getProperty("exo:isActivated").getBoolean()) && (!nodeQuestion2.getProperty("exo:author").getString().equals(eventQuery.getUserId()) || !nodeQuestion2.getProperty("exo:isActivated").getBoolean())) continue;
                                    if (retrictedCategoryList.size() > 0) {
                                        boolean isCanView2 = true;
                                        String string6 = nodeObj.getPath();
                                        for (String string7 : retrictedCategoryList) {
                                            if (string6.indexOf(string7) <= 0) continue;
                                            isCanView2 = false;
                                            break;
                                        }
                                        if (!isCanView2) continue;
                                        listAnswerandComment.put(string, nodeObj);
                                        continue;
                                    }
                                    listAnswerandComment.put(string, nodeObj);
                                    continue;
                                }
                                nodeQuestion2 = nodeObj.getParent().getParent().getParent().getParent();
                                if ((!nodeQuestion2.getProperty("exo:isApproved").getBoolean() || !nodeQuestion2.getProperty("exo:isActivated").getBoolean()) && (!nodeQuestion2.getProperty("exo:author").getString().equals(eventQuery.getUserId()) || !nodeQuestion2.getProperty("exo:isActivated").getBoolean())) continue;
                                if (retrictedCategoryList.size() > 0) {
                                    boolean isCanView3 = true;
                                    String string8 = nodeObj.getPath();
                                    for (String string9 : retrictedCategoryList) {
                                        if (string8.indexOf(string9) <= 0) continue;
                                        isCanView3 = false;
                                        break;
                                    }
                                    if (!isCanView3) continue;
                                    listAnswerandComment.put(string, nodeObj);
                                    continue;
                                }
                                listAnswerandComment.put(string, nodeObj);
                            }
                            catch (Exception exception) {
                                log.error((Object)"Failed to add item in list search", (Throwable)exception);
                            }
                            continue;
                        }
                        if (nodeObj.isNodeType("exo:faqQuestion")) {
                            listQuestion.add(nodeObj);
                        }
                        if (nodeObj.isNodeType("exo:faqResource")) {
                            listQuestion.add(nodeObj.getParent().getParent());
                        }
                        if (nodeObj.isNodeType("exo:faqLanguage")) {
                            arrayList.add(nodeObj);
                        }
                        if (!nodeObj.isNodeType("exo:answer") && !nodeObj.isNodeType("exo:comment")) continue;
                        listAnswerandComment.put(nodeObj.getProperty("exo:questionId").getString(), nodeObj);
                    }
                    boolean bl3 = false;
                    if (eventQuery.isQuestionLevelSearch()) {
                        if (!eventQuery.isLanguageLevelSearch() && !eventQuery.isAnswerCommentLevelSearch()) {
                            ArrayList<String> list = new ArrayList<String>();
                            for (Node node : listQuestion) {
                                if (list.contains(node.getName())) continue;
                                list.add(node.getName());
                                results.add(this.getResultObj(node));
                            }
                            ArrayList<ObjectSearchResult> i$ = results;
                            return i$;
                        }
                        if (!listQuestion.isEmpty()) {
                            bl2 = true;
                            for (Node node : listQuestion) {
                                mergeQuestion.put(node.getName(), node);
                            }
                        }
                    }
                    if (eventQuery.isLanguageLevelSearch()) {
                        if (!eventQuery.isQuestionLevelSearch() && !eventQuery.isAnswerCommentLevelSearch()) {
                            for (Node node : arrayList) {
                                results.add(this.getResultObj(node));
                            }
                            ArrayList<ObjectSearchResult> i$ = results;
                            return i$;
                        }
                        if (bl2) {
                            for (Node node : arrayList) {
                                String string = node.getProperty("exo:questionId").getString();
                                if (!mergeQuestion.containsKey(string)) continue;
                                mergeQuestion2.put(string, mergeQuestion.get(string));
                            }
                        } else {
                            for (Node node : arrayList) {
                                mergeQuestion2.put(node.getProperty("exo:questionId").getString(), node);
                            }
                            bl = true;
                        }
                    }
                    if (eventQuery.isAnswerCommentLevelSearch()) {
                        if (!eventQuery.isLanguageLevelSearch() && !eventQuery.isQuestionLevelSearch()) {
                            for (Node node : listAnswerandComment.values()) {
                                results.add(this.getResultObj(node));
                            }
                            ArrayList<ObjectSearchResult> i$ = results;
                            return i$;
                        }
                        if (bl) {
                            if (eventQuery.isLanguageLevelSearch()) {
                                if (mergeQuestion2.isEmpty()) {
                                    ArrayList<ObjectSearchResult> i$ = results;
                                    return i$;
                                }
                                for (Node node : listAnswerandComment.values()) {
                                    String string = node.getProperty("exo:questionId").getString();
                                    if (!mergeQuestion2.containsKey(string)) continue;
                                    results.add(this.getResultObj(node));
                                }
                            } else {
                                if (mergeQuestion.isEmpty()) {
                                    ArrayList<ObjectSearchResult> i$ = results;
                                    return i$;
                                }
                                for (Node node : listAnswerandComment.values()) {
                                    String string = node.getProperty("exo:questionId").getString();
                                    if (!mergeQuestion.containsKey(string)) continue;
                                    results.add(this.getResultObj(node));
                                }
                            }
                        } else {
                            for (Node node : listAnswerandComment.values()) {
                                results.add(this.getResultObj(node));
                            }
                        }
                    }
                    if (!(eventQuery.isQuestionLevelSearch() || eventQuery.isAnswerCommentLevelSearch() || eventQuery.isLanguageLevelSearch())) {
                        HashMap<String, ObjectSearchResult> tmpResult = new HashMap<String, ObjectSearchResult>();
                        for (Node node : listAnswerandComment.values()) {
                            ObjectSearchResult rs = this.getResultObj(node);
                            tmpResult.put(rs.getId(), rs);
                        }
                        for (Node node : listQuestion) {
                            ObjectSearchResult rs = this.getResultObj(node);
                            tmpResult.put(rs.getId(), rs);
                        }
                        for (Node node : arrayList) {
                            ObjectSearchResult rs = this.getResultObj(node);
                            tmpResult.put(rs.getId(), rs);
                        }
                        results.addAll(tmpResult.values());
                    }
                    ArrayList<ObjectSearchResult> arrayList2 = results;
                    return arrayList2;
                }
                if (!eventQuery.getType().equals("categoryAndQuestion")) break block81;
                String nodePath = "";
                Session session = categoryHome.getSession();
                HashMap<String, ObjectSearchResult> searchMap = new HashMap<String, ObjectSearchResult>();
                while (iter.hasNext()) {
                    boolean isResult;
                    block82: {
                        block83: {
                            isResult = true;
                            nodeObj = iter.nextNode();
                            nodePath = nodeObj.getPath();
                            if (nodePath.indexOf("/Question") <= 0 || nodePath.lastIndexOf("/") < nodePath.indexOf("/Question")) break block83;
                            nodePath = nodePath.substring(0, nodePath.indexOf("/Question") + 41);
                            nodeObj = (Node)session.getItem(nodePath);
                            if (eventQuery.isAdmin()) break block82;
                            try {
                                if (nodeObj.getProperty("exo:isApproved").getBoolean() && nodeObj.getProperty("exo:isActivated").getBoolean() || nodeObj.getProperty("exo:author").getString().equals(eventQuery.getUserId()) && nodeObj.getProperty("exo:isActivated").getBoolean()) {
                                    if (retrictedCategoryList.size() <= 0) break block82;
                                    String string = nodeObj.getPath();
                                    for (String string10 : retrictedCategoryList) {
                                        if (string.indexOf(string10) <= 0) continue;
                                        isResult = false;
                                        break block82;
                                    }
                                    break block82;
                                }
                                isResult = false;
                            }
                            catch (Exception exception) {
                                log.debug((Object)(nodeObj + " node must exist: "), (Throwable)exception);
                                isResult = false;
                            }
                            break block82;
                        }
                        if (nodeObj.isNodeType("exo:faqCategory") && !eventQuery.isAdmin() && retrictedCategoryList.size() > 0) {
                            String string = nodeObj.getPath();
                            for (String string11 : retrictedCategoryList) {
                                if (string.indexOf(string11) <= 0) continue;
                                isResult = false;
                                break;
                            }
                        }
                    }
                    if (searchMap.containsKey(nodeObj.getName()) || !isResult) continue;
                    searchMap.put(nodeObj.getName(), this.getResultObj(nodeObj));
                }
                ArrayList<ObjectSearchResult> arrayList = new ArrayList<ObjectSearchResult>(searchMap.values());
                return arrayList;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                sProvider.close();
            }
        }
        return new ArrayList<ObjectSearchResult>();
    }

    private ObjectSearchResult getResultObj(Node node) throws Exception {
        ObjectSearchResult objectResult = new ObjectSearchResult();
        if (node.isNodeType("exo:faqCategory")) {
            objectResult.setIcon("FAQCategorySearch");
            objectResult.setName(node.getProperty("exo:name").getString());
            objectResult.setType("faqCategory");
            String path = node.getPath();
            objectResult.setId(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
            objectResult.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
        } else {
            if (node.isNodeType("exo:faqQuestion")) {
                if (this.questionHasAnswer(node)) {
                    objectResult.setIcon("QuestionSearch");
                } else {
                    objectResult.setIcon("NotResponseSearch");
                }
                objectResult.setName(node.getProperty("exo:title").getString());
                String path = node.getPath();
                objectResult.setId(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
                objectResult.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
            } else {
                objectResult.setIcon("QuestionSearch");
                String nodePath = node.getPath();
                nodePath = nodePath.substring(0, nodePath.indexOf("/Question") + 41);
                Node questionNode = (Node)node.getSession().getItem(nodePath);
                objectResult.setName(questionNode.getProperty("exo:title").getString());
                String path = questionNode.getPath();
                objectResult.setId(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
                objectResult.setCreatedDate(questionNode.getProperty("exo:createdDate").getDate().getTime());
            }
            objectResult.setType("faqQuestion");
        }
        return objectResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCategoryPath(String categoryId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<String> breadcums = new ArrayList<String>();
        try {
            Node category = this.getFAQServiceHome(sProvider).getNode(categoryId);
            while (!category.getName().equals("categories")) {
                breadcums.add(category.getName());
                category = category.getParent();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get category: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return breadcums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getParentCategoriesName(String path) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        StringBuilder names = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        try {
            Node category = this.getFAQServiceHome(sProvider).getNode(path);
            while (category.isNodeType("exo:faqCategory")) {
                if (category.hasProperty("exo:name")) {
                    list.add(category.getProperty("exo:name").getString());
                } else {
                    list.add(category.getName());
                }
                category = category.getParent();
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                if (i != list.size() - 1) {
                    names.append(" > ");
                }
                names.append((String)list.get(i));
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to get parent categories name", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return names.toString();
    }

    private void sendEmailNotification(List<String> addresses, Message message) throws Exception {
        this.pendingMessagesQueue.add(new NotifyInfo(addresses, message));
    }

    @Override
    public Iterator<NotifyInfo> getPendingMessages() throws Exception {
        Iterator<NotifyInfo> pending = new ArrayList<NotifyInfo>(this.pendingMessagesQueue).iterator();
        this.pendingMessagesQueue.clear();
        return pending;
    }

    @Override
    public NotifyInfo getMessageInfo(String name) throws Exception {
        NotifyInfo messageInfo = this.messagesInfoMap_.get(name);
        this.messagesInfoMap_.remove(name);
        return messageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapCategories(String cateId1, String cateId2) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node goingCategory = this.getFAQServiceHome(sProvider).getNode(cateId1);
            Node mockCategory = this.getFAQServiceHome(sProvider).getNode(cateId2);
            long index = mockCategory.getProperty("exo:index").getValue().getLong();
            if (goingCategory.getParent().getPath().equals(mockCategory.getParent().getPath())) {
                goingCategory.setProperty("exo:index", index);
                goingCategory.save();
                this.resetIndex(goingCategory, index);
            } else {
                String id = goingCategory.getName();
                mockCategory.getSession().move(goingCategory.getPath(), mockCategory.getParent().getPath() + "/" + id);
                mockCategory.getSession().save();
                Node destCat = mockCategory.getParent().getNode(id);
                destCat.setProperty("exo:index", index);
                destCat.save();
                this.resetIndex(destCat, index);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to swap category", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveTopicIdDiscussQuestion(String questionId, String topicId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node questionNode = this.getFAQServiceHome(sProvider).getNode(questionId);
            questionNode.setProperty("exo:topicIdDiscuss", topicId);
            questionNode.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to save topic discuss question: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream exportData(String categoryId, boolean createZipFile) throws Exception {
        Node categoryNode = this.getCategoryNodeById(categoryId);
        Session session = categoryNode.getSession();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        File file = null;
        ArrayList<File> listFiles = new ArrayList<File>();
        Calendar date = GregorianCalendar.getInstance();
        session.exportSystemView(categoryNode.getPath(), (OutputStream)bos, false, false);
        listFiles.add(org.exoplatform.ks.common.Utils.getXMLFile((ByteArrayOutputStream)bos, (String)"eXo Knowledge Suite - Answers", (String)"Category", (Date)date.getTime(), (String)categoryNode.getName()));
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream("exportCategory.zip"));
        try {
            byte[] buffer = new byte[4096];
            FileInputStream inputStream = null;
            ZipEntry zipEntry = null;
            for (File f : listFiles) {
                try {
                    int byteReads;
                    inputStream = new FileInputStream(f);
                    zipEntry = new ZipEntry(f.getPath());
                    zipOutputStream.putNextEntry(zipEntry);
                    while ((byteReads = inputStream.read(buffer)) != -1) {
                        zipOutputStream.write(buffer, 0, byteReads);
                    }
                }
                finally {
                    inputStream.close();
                }
            }
        }
        finally {
            zipOutputStream.close();
        }
        file = new File("exportCategory.zip");
        FileInputStream fileInputStream = new FileInputStream(file);
        return fileInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importData(String parentId, InputStream inputStream, boolean isZip) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            ArrayList<String> patchNodeImport = new ArrayList<String>();
            Node categoryNode = this.getFAQServiceHome(sProvider).getNode(parentId);
            Session session = categoryNode.getSession();
            NodeIterator iter = categoryNode.getNodes();
            while (iter.hasNext()) {
                patchNodeImport.add(iter.nextNode().getName());
            }
            if (isZip) {
                ZipEntry entry;
                ZipInputStream zipStream = new ZipInputStream(inputStream);
                while ((entry = zipStream.getNextEntry()) != null) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    int available = -1;
                    byte[] data = new byte[2048];
                    while ((available = zipStream.read(data, 0, 1024)) > -1) {
                        out.write(data, 0, available);
                    }
                    zipStream.closeEntry();
                    out.close();
                    ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());
                    session.importXML(categoryNode.getPath(), (InputStream)input, 0);
                    session.save();
                }
                zipStream.close();
                this.calculateImportRootCategory(categoryNode);
            } else {
                session.importXML(categoryNode.getPath(), inputStream, 0);
                session.save();
            }
            categoryNode = (Node)session.getItem(categoryNode.getPath());
            iter = categoryNode.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (patchNodeImport.contains(node.getName())) {
                    patchNodeImport.remove(node.getName());
                    continue;
                }
                patchNodeImport.add(node.getName());
            }
            for (String string : patchNodeImport) {
                Node nodeParentQuestion = categoryNode.getNode(string);
                iter = this.getQuestionsIterator(nodeParentQuestion, "", true);
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    this.reUpdateNumberOfPublicAnswers(node);
                    this.registerQuestionNodeListener(node);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to import data in category " + parentId), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            sProvider.close();
        }
        return true;
    }

    private void calculateImportRootCategory(Node categoryRootNode) throws Exception {
        try {
            NodeIterator iterator0 = categoryRootNode.getNodes();
            int i = 0;
            while (iterator0.hasNext()) {
                if (!iterator0.nextNode().isNodeType("exo:faqCategory")) continue;
                ++i;
            }
            Node categoryNode = categoryRootNode.getNode("categories");
            NodeIterator iterator = categoryNode.getNodes();
            String rootPath = categoryRootNode.getPath();
            Session session = categoryRootNode.getSession();
            Workspace workspace = session.getWorkspace();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                try {
                    if (node.isNodeType("exo:faqCategory")) {
                        node.setProperty("exo:index", (long)i);
                        ++i;
                        workspace.move(node.getPath(), rootPath + "/" + node.getName());
                        continue;
                    }
                    if (!node.isNodeType("exo:faqQuestionHome")) continue;
                    if (categoryRootNode.hasNode(Utils.QUESTION_HOME)) {
                        NodeIterator iter = node.getNodes();
                        while (iter.hasNext()) {
                            Node node_ = iter.nextNode();
                            workspace.move(node_.getPath(), rootPath + "/" + Utils.QUESTION_HOME + "/" + node_.getName());
                        }
                        continue;
                    }
                    workspace.move(node.getPath(), rootPath + "/" + node.getName());
                }
                catch (Exception e) {}
            }
            categoryNode.remove();
            session.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExisting(String path) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            boolean bl = this.getFAQServiceHome(sProvider).hasNode(path);
            return bl;
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCategoryPathOf(String id) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String path;
            Node node = this.getFAQServiceHome(sProvider).getNode(id);
            if (node.isNodeType("exo:faqQuestion")) {
                path = node.getParent().getParent().getPath();
            } else if (node.isNodeType("exo:faqCategory")) {
                path = node.getPath();
            } else {
                String string = null;
                return string;
            }
            String string = path.substring(path.indexOf("categories"));
            return string;
        }
        catch (Exception e) {
            log.error((Object)("Failed to get category of path: " + id), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModerateAnswer(String id) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node = this.getFAQServiceHome(sProvider).getNode(id);
            if (node.isNodeType("exo:faqQuestion")) {
                node = node.getParent().getParent();
            }
            boolean bl = node.getProperty("exo:isModerateAnswers").getBoolean();
            return bl;
        }
        catch (PathNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)"Failed to check moderate answer", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isModerateQuestion(String id) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node = this.getFAQServiceHome(sProvider).getNode(id);
            if (node.isNodeType("exo:faqQuestion")) {
                node = node.getParent().getParent();
            }
            boolean bl = node.getProperty("exo:isModerateQuestions").getBoolean();
            return bl;
        }
        catch (PathNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)"Failed to moderate question", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isViewAuthorInfo(String id) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node = id == null ? this.getCategoryHome(sProvider, null) : this.getCategoryNodeById(sProvider, id);
            if (node.isNodeType("exo:faqQuestion")) {
                node = node.getParent().getParent();
            }
            boolean bl = new PropertyReader(node).bool("exo:viewAuthorInfor", false);
            return bl;
        }
        catch (Exception e) {
            log.error((Object)"Failed to check view author infor", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCategoryModerator(String categoryId, String user) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        boolean isCalMod = false;
        try {
            List userGroups = UserHelper.getAllGroupAndMembershipOfUser((String)user);
            Node node = this.getCategoryNodeById(sProvider, categoryId);
            PropertyReader reader = new PropertyReader(node);
            List values = reader.list("exo:moderators", new ArrayList());
            if (!values.isEmpty()) {
                isCalMod = Utils.hasPermission(userGroups, values);
            }
        }
        catch (Exception e) {
            log.error((Object)"Cheking whether category moderator failed: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return isCalMod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCategoryExist(String name, String path) {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node category = this.getFAQServiceHome(sProvider).getNode(path);
            NodeIterator iter = category.getNodes();
            while (iter.hasNext()) {
                Node cat = iter.nextNode();
                try {
                    if (!name.equals(cat.getProperty("exo:name").getString())) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to check exist category by name", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Cheking whether catagory is exist: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return false;
    }

    @Override
    public List<String> getQuestionContents(List<String> paths) throws Exception {
        ArrayList<String> contents = new ArrayList<String>();
        for (String path : paths) {
            try {
                contents.add(this.getQuestionNodeById(path).getProperty("exo:title").getString());
            }
            catch (Exception e) {}
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getQuestionNodeById(String path) throws Exception {
        block9: {
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            try {
                Node serviceHome = this.getFAQServiceHome(sProvider);
                try {
                    Node node = serviceHome.getNode(path);
                    return node;
                }
                catch (PathNotFoundException e) {
                    block8: {
                        Node node;
                        try {
                            StringBuffer queryString = new StringBuffer("/jcr:root").append(serviceHome.getPath()).append("//element(*,exo:faqQuestion)[fn:name()='").append(path).append("']");
                            QueryManager qm = serviceHome.getSession().getWorkspace().getQueryManager();
                            Query query = qm.createQuery(queryString.toString(), "xpath");
                            QueryResult result = query.execute();
                            NodeIterator iter = result.getNodes();
                            if (iter.getSize() <= 0L) break block8;
                            node = iter.nextNode();
                        }
                        catch (Exception e2) {
                            log.error((Object)("Failed to get question node by path:" + path), (Throwable)e2);
                            break block9;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        sProvider.close();
                        return node;
                    }
                    sProvider.close();
                }
            }
            finally {
                sProvider.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getModeratorsOf(String path) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node = this.getFAQServiceHome(sProvider).getNode(path);
            if (node.isNodeType("exo:faqQuestion")) {
                String[] stringArray = Utils.valuesToArray(node.getParent().getParent().getProperty("exo:moderators").getValues());
                return stringArray;
            }
            if (node.isNodeType("exo:faqCategory")) {
                String[] stringArray = Utils.valuesToArray(node.getProperty("exo:moderators").getValues());
                return stringArray;
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get moderators of path: " + path), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCategoryNameOf(String categoryPath) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node node = this.getFAQServiceHome(sProvider).getNode(categoryPath);
            if (node.hasProperty("exo:name")) {
                String string = node.getProperty("exo:name").getString();
                return string;
            }
            String string = node.getName();
            return string;
        }
        catch (Exception e) {
            log.error((Object)("Failed to get category name of path: " + categoryPath), (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CategoryInfo getCategoryInfo(String categoryPath, List<String> categoryIdScoped) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        CategoryInfo categoryInfo = new CategoryInfo();
        try {
            Node categoryNode = this.getFAQServiceHome(sProvider).getNode(categoryPath);
            categoryInfo.setId(categoryNode.getName());
            String path = categoryNode.getPath();
            categoryInfo.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
            if (categoryNode.hasProperty("exo:name")) {
                categoryInfo.setName(categoryNode.getProperty("exo:name").getString());
            } else {
                categoryInfo.setName(categoryNode.getName());
            }
            Node node = categoryNode;
            ArrayList<String> pathName = new ArrayList<String>();
            while (node.isNodeType("exo:faqCategory")) {
                String categoryName = node.hasProperty("exo:name") ? node.getProperty("exo:name").getString() : node.getName();
                pathName.add(categoryName);
                node = node.getParent();
            }
            categoryInfo.setPathName(pathName);
            categoryInfo.setQuestionInfos(this.getQuestionInfo(categoryNode));
            if (categoryNode.hasNodes()) {
                ArrayList<SubCategoryInfo> subList = new ArrayList<SubCategoryInfo>();
                NodeIterator subIter = categoryNode.getNodes();
                while (subIter.hasNext()) {
                    Node sub = subIter.nextNode();
                    if (!categoryIdScoped.isEmpty() && !categoryIdScoped.contains(sub.getName()) || !sub.isNodeType("exo:faqCategory")) continue;
                    SubCategoryInfo subCat = new SubCategoryInfo();
                    subCat.setId(sub.getName());
                    subCat.setName(sub.getProperty("exo:name").getString());
                    subCat.setPath(categoryInfo.getPath() + "/" + sub.getName());
                    subCat.setSubCateInfos(this.getSubCategoryInfo(sub, categoryIdScoped));
                    subCat.setQuestionInfos(this.getQuestionInfo(sub));
                    subList.add(subCat);
                }
                categoryInfo.setSubCateInfos(subList);
            }
        }
        catch (Exception e) {
            CategoryInfo categoryInfo2 = null;
            return categoryInfo2;
        }
        finally {
            sProvider.close();
        }
        return categoryInfo;
    }

    private void registerQuestionNodeListener(Node questionNode) {
        try {
            ObservationManager observation = questionNode.getSession().getWorkspace().getObservationManager();
            QuestionNodeListener listener = new QuestionNodeListener();
            observation.addEventListener((EventListener)listener, 23, questionNode.getPath(), true, null, null, false);
        }
        catch (Exception e) {
            log.error((Object)"can not add listener to question node", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reCalculateInfoOfQuestion(String absPathOfProp) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            long commentTime;
            Node node;
            Property prop;
            Item item = null;
            Node quesNode = null;
            Node serviceHomeNode = this.getFAQServiceHome(sProvider);
            int quesNameIndex = absPathOfProp.lastIndexOf(Utils.QUESTION_HOME) + Utils.QUESTION_HOME.length() + 2;
            String quesPath = absPathOfProp.substring(0, absPathOfProp.indexOf("/", quesNameIndex));
            try {
                quesNode = (Node)serviceHomeNode.getSession().getItem(quesPath);
            }
            catch (PathNotFoundException pe) {
                sProvider.close();
                return;
            }
            String lastActivityInfo = null;
            if (quesNode.hasProperty("exo:lastActivity")) {
                lastActivityInfo = quesNode.getProperty("exo:lastActivity").getString();
            }
            long timeOfLastActivity = Utils.getTimeOfLastActivity(lastActivityInfo);
            long numberOfAnswers = 0L;
            if (quesNode.hasProperty("exo:numberOfPublicAnswers")) {
                numberOfAnswers = quesNode.getProperty("exo:numberOfPublicAnswers").getLong();
            }
            try {
                item = this.getFAQServiceHome(sProvider).getSession().getItem(absPathOfProp);
            }
            catch (PathNotFoundException pnfe) {
                this.reUpdateLastActivityOfQuestion(quesNode);
                this.reUpdateNumberOfPublicAnswers(quesNode);
                sProvider.close();
                return;
            }
            if (item instanceof Property && ((prop = (Property)item).getName().equalsIgnoreCase("exo:activateResponses") || prop.getName().equalsIgnoreCase("exo:approveResponses"))) {
                boolean value = prop.getBoolean();
                Node answerNode = prop.getParent();
                boolean isActivated = false;
                boolean isApproved = false;
                if (answerNode.hasProperty("exo:activateResponses")) {
                    isActivated = answerNode.getProperty("exo:activateResponses").getBoolean();
                }
                if (answerNode.hasProperty("exo:approveResponses")) {
                    isApproved = answerNode.getProperty("exo:approveResponses").getBoolean();
                }
                long answerTime = 0L;
                if (answerNode.hasProperty("exo:dateResponse")) {
                    answerTime = answerNode.getProperty("exo:dateResponse").getDate().getTimeInMillis();
                }
                if (isActivated && isApproved) {
                    quesNode.setProperty("exo:numberOfPublicAnswers", ++numberOfAnswers);
                    if (timeOfLastActivity < answerTime) {
                        String author = answerNode.getProperty("exo:responseBy").getString();
                        quesNode.setProperty("exo:lastActivity", author + "-" + String.valueOf(answerTime));
                    }
                    quesNode.save();
                    return;
                }
                this.reUpdateNumberOfPublicAnswers(quesNode);
                if (timeOfLastActivity == answerTime) {
                    this.reUpdateLastActivityOfQuestion(quesNode);
                    return;
                }
            }
            if (item instanceof Node && (node = (Node)item).getPrimaryNodeType().getName().equalsIgnoreCase("exo:comment") && (commentTime = node.getProperty("exo:dateComment").getDate().getTimeInMillis()) > timeOfLastActivity) {
                String author = node.getProperty("exo:commentBy").getString();
                quesNode.setProperty("exo:lastActivity", author + "-" + String.valueOf(commentTime));
                quesNode.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to re calculateInfo of question", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    private void reUpdateNumberOfPublicAnswers(Node questionNode) throws RepositoryException {
        QueryManager qm = questionNode.getSession().getWorkspace().getQueryManager();
        StringBuilder sb = new StringBuilder();
        sb.append("/jcr:root").append(questionNode.getPath()).append("//element(*, exo:answer)[@exo:activateResponses='true' and @exo:approveResponses='true']");
        Query query = qm.createQuery(sb.toString(), "xpath");
        QueryResult result = query.execute();
        long size = result.getNodes().getSize();
        size = size < 0L ? 0L : size;
        questionNode.setProperty("exo:numberOfPublicAnswers", size);
        questionNode.save();
    }

    private void reUpdateLastActivityOfQuestion(Node quesNode) throws RepositoryException {
        long commentTime;
        Node commentNode;
        QueryManager qm = quesNode.getSession().getWorkspace().getQueryManager();
        StringBuilder sb = new StringBuilder();
        sb.append("/jcr:root").append(quesNode.getPath()).append("//element(*, exo:answer)[@exo:activateResponses='true' and @exo:approveResponses='true'] order by @exo:dateResponse descending");
        QueryImpl query = (QueryImpl)qm.createQuery(sb.toString(), "xpath");
        query.setLimit(1L);
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        String author = null;
        long lastTime = -1L;
        if (iter.hasNext()) {
            Node node = iter.nextNode();
            if (node.hasProperty("exo:dateResponse")) {
                lastTime = node.getProperty("exo:dateResponse").getDate().getTimeInMillis();
            }
            if (node.hasProperty("exo:responseBy")) {
                author = node.getProperty("exo:responseBy").getString();
            }
        }
        sb = new StringBuilder();
        sb.append("/jcr:root").append(quesNode.getPath()).append("//element(*, exo:comment) order by @exo:dateComment descending");
        query = (QueryImpl)qm.createQuery(sb.toString(), "xpath");
        query.setLimit(1L);
        result = query.execute();
        iter = result.getNodes();
        if (iter.hasNext() && (commentNode = iter.nextNode()).hasProperty("exo:dateComment") && commentNode.hasProperty("exo:commentBy") && lastTime < (commentTime = commentNode.getProperty("exo:dateComment").getDate().getTimeInMillis())) {
            lastTime = commentTime;
            author = commentNode.getProperty("exo:commentBy").getString();
        }
        if (lastTime > 0L) {
            quesNode.setProperty("exo:lastActivity", author + "-" + String.valueOf(lastTime));
            quesNode.save();
        } else {
            quesNode.setProperty("exo:lastActivity", (String)null);
        }
    }

    private List<SubCategoryInfo> getSubCategoryInfo(Node category, List<String> categoryIdScoped) throws Exception {
        ArrayList<SubCategoryInfo> subList = new ArrayList<SubCategoryInfo>();
        if (category.hasNodes()) {
            NodeIterator iter = category.getNodes();
            while (iter.hasNext()) {
                try {
                    Node sub = iter.nextNode();
                    if (!sub.isNodeType("exo:faqCategory") || !categoryIdScoped.isEmpty() && !categoryIdScoped.contains(sub.getName())) continue;
                    SubCategoryInfo cat = new SubCategoryInfo();
                    cat.setName(sub.getProperty("exo:name").getString());
                    String path = sub.getPath();
                    cat.setPath(path.substring(path.indexOf(Utils.FAQ_APP) + Utils.FAQ_APP.length() + 1));
                    cat.setId(sub.getName());
                    subList.add(cat);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to get sub category info: ", (Throwable)e);
                }
            }
        }
        return subList;
    }

    private NodeIterator getNodeIteratorAnswerAccess(Node answerHome) throws Exception {
        StringBuffer queryString = new StringBuffer("/jcr:root").append(answerHome.getPath()).append("/element(*,exo:answer)[@exo:approveResponses='true' and @exo:activateResponses='true']");
        QueryManager qm = answerHome.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes();
    }

    private List<QuestionInfo> getQuestionInfo(Node categoryNode) throws Exception {
        ArrayList<QuestionInfo> questionInfoList = new ArrayList<QuestionInfo>();
        if (categoryNode.hasNode(Utils.QUESTION_HOME)) {
            String strQuery = "[@exo:isActivated='true' and @exo:isApproved='true']";
            NodeIterator iter = this.getQuestionsIterator(categoryNode.getNode(Utils.QUESTION_HOME), strQuery, false);
            while (iter.hasNext()) {
                Node question = iter.nextNode();
                QuestionInfo questionInfo = new QuestionInfo();
                try {
                    questionInfo.setQuestion(question.getProperty("exo:title").getString());
                    questionInfo.setDetail(question.getProperty("exo:name").getString());
                    questionInfo.setId(question.getName());
                    if (question.hasNode(Utils.ANSWER_HOME)) {
                        ArrayList<String> answers = new ArrayList<String>();
                        NodeIterator ansIter = this.getNodeIteratorAnswerAccess(question.getNode(Utils.ANSWER_HOME));
                        while (ansIter.hasNext()) {
                            answers.add(ansIter.nextNode().getProperty("exo:responses").getString());
                        }
                        questionInfo.setAnswers(answers);
                    }
                    questionInfoList.add(questionInfo);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to add answer by question node: " + question.getName()), (Throwable)e);
                }
            }
        }
        return questionInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateQuestionRelatives(String questionPath, String[] relatives) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node question = this.getFAQServiceHome(sProvider).getNode(questionPath);
            question.setProperty("exo:relatives", relatives);
            question.save();
        }
        catch (Exception e) {
            log.error((Object)"Failed to update question relatives: ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream createAnswerRSS(String cateId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            PropertyReader reader;
            Node cateNode = this.getCategoryNodeById(sProvider, cateId);
            ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
            StringBuilder queryString = new StringBuilder("/jcr:root").append(cateNode.getPath()).append("//element(*,exo:faqQuestion)");
            List<String> list = this.getListCategoryIdPublic(sProvider, cateNode);
            if (!list.isEmpty()) {
                queryString.append("[");
            }
            if ((reader = new PropertyReader(cateNode)).list("exo:userPrivate", new ArrayList()).isEmpty() && !list.isEmpty()) {
                list.add(cateNode.getName());
            }
            boolean isOr = false;
            for (String id : list) {
                if (isOr) {
                    queryString.append(" or (@exo:categoryId='").append(id).append("')");
                    continue;
                }
                queryString.append("(@exo:categoryId='").append(id).append("')");
                isOr = true;
            }
            if (!list.isEmpty()) {
                queryString.append("]");
            }
            QueryManager qm = cateNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node nodeQs = iter.nextNode();
                if (!nodeQs.getParent().getParent().isNodeType("exo:faqCategory")) continue;
                entries.add(this.createQuestionEntry(sProvider, nodeQs));
            }
            SyndFeed feed = this.createNewFeed(cateNode, "http://www.exoplatform.com");
            feed.setEntries(entries);
            SyndFeedOutput output = new SyndFeedOutput();
            String s = output.outputString(feed);
            s = StringUtils.replace((String)s, (String)"&amp;", (String)"&");
            s = s.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            s = StringUtils.replace((String)s, (String)"ST[CDATA[", (String)"<![CDATA[");
            s = StringUtils.replace((String)s, (String)"END]]", (String)"]]>");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(s.getBytes());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            log.error((Object)"Failed to create answer RSS ", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    private List<String> getListCategoryIdPublic(SessionProvider sProvider, Node cateNode) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder queryString = new StringBuilder("/jcr:root").append(cateNode.getPath()).append("//element(*,exo:faqCategory)[@exo:isView='true' and ( not(@exo:userPrivate) or @exo:userPrivate='')]");
        QueryManager qm = cateNode.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            list.add(iter.nextNode().getName());
        }
        return list;
    }

    private SyndEntry createQuestionEntry(SessionProvider sProvider, Node questionNode) throws Exception {
        ArrayList<String> listContent = new ArrayList<String>();
        StringBuffer content = new StringBuffer();
        for (String answer : this.getStrAnswers(questionNode)) {
            content.append(answer);
        }
        for (String comment : this.getComments(questionNode)) {
            content.append(comment);
        }
        listContent.add(content.toString());
        SyndEntry entry = this.createNewEntry(questionNode, listContent);
        return entry;
    }

    private List<String> getStrAnswers(Node questionNode) throws Exception {
        ArrayList<String> listAnswers = new ArrayList<String>();
        try {
            Node answerHome = questionNode.getNode(Utils.ANSWER_HOME);
            QueryManager qm = answerHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(answerHome.getPath()).append("//element(*,exo:answer)[(@exo:approveResponses='true') and (@exo:activateResponses='true')]").append("order by @exo:dateResponse ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            Node answerNode = null;
            while (nodeIterator.hasNext()) {
                answerNode = nodeIterator.nextNode();
                if (!answerNode.hasProperty("exo:responses")) continue;
                listAnswers.add("<b><u>Answer:</u></b> " + answerNode.getProperty("exo:responses").getValue().getString() + "<br/>");
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get answers for " + questionNode.getName()));
        }
        return listAnswers;
    }

    private List<String> getComments(Node questionNode) throws Exception {
        ArrayList<String> listComment = new ArrayList<String>();
        try {
            Node commentHome = questionNode.getNode(Utils.COMMENT_HOME);
            QueryManager qm = commentHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(commentHome.getPath()).append("//element(*,exo:comment)").append(" order by @exo:dateComment ascending");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            Node commentNode = null;
            while (nodeIterator.hasNext()) {
                commentNode = nodeIterator.nextNode();
                if (!commentNode.hasProperty("exo:comments")) continue;
                listComment.add("<b><u>Comment:</u></b>" + commentNode.getProperty("exo:comments").getValue().getString() + "<br/>");
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get comments for " + questionNode.getName()));
        }
        return listComment;
    }

    private SyndFeed createNewFeed(Node node, String link) throws Exception {
        PropertyReader reader = new PropertyReader(node);
        String desc = reader.string("exo:description", " ");
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle("ST[CDATA[" + reader.string("exo:name", "Root") + "END]]");
        feed.setPublishedDate(reader.date("exo:createdDate", new Date()));
        feed.setLink("ST[CDATA[" + link + "END]]");
        feed.setDescription("ST[CDATA[" + desc + "END]]");
        feed.setEncoding("UTF-8");
        return feed;
    }

    private SyndEntry createNewEntry(Node questionNode, List<String> listContent) throws Exception {
        PropertyReader question = new PropertyReader(questionNode);
        SyndContentImpl description = new SyndContentImpl();
        description.setType("text/plain");
        description.setValue("ST[CDATA[" + question.string("exo:title", "") + "<br/>" + (listContent.isEmpty() ? "" : listContent.get(0)) + "END]]");
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setUri("ST[CDATA[" + questionNode.getName() + "END]]");
        entry.setTitle("ST[CDATA[" + question.string("exo:title") + "END]]");
        entry.setLink("ST[CDATA[" + question.string("exo:link", "http://www.exoplatform.com") + "END]]");
        entry.setContributors(listContent);
        entry.setDescription((SyndContent)description);
        entry.setPublishedDate(question.date("exo:createdDate", new Date()));
        entry.setAuthor("ST[CDATA[" + question.string("exo:author") + "END]]");
        return entry;
    }

    protected Node getFAQServiceHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getFaqHomeLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getKSUserAvatarHomeNode(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getAvatarsLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getUserSettingHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getFaqUserSettingsLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getCategoryHome(SessionProvider sProvider, String username) throws Exception {
        String path = this.dataLocator.getFaqCategoriesLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getTemplateHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getFaqTemplatesLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }
}

