/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.xml.syndication.itunes.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleGenerator;
import com.totsp.xml.syndication.itunes.AbstractITunesObject;
import com.totsp.xml.syndication.itunes.EntryInformationImpl;
import com.totsp.xml.syndication.itunes.FeedInformationImpl;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class ITunesGenerator
implements ModuleGenerator {
    private static final HashSet SET = new HashSet();
    private static final Namespace NS = Namespace.getNamespace((String)"itunes", (String)"http://www.itunes.com/DTDs/Podcast-1.0.dtd");

    public void generate(Module module, Element element) {
        AbstractITunesObject info;
        Element root = element;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)root.getParent();
        }
        root.addNamespaceDeclaration(NS);
        if (!(module instanceof AbstractITunesObject)) {
            return;
        }
        AbstractITunesObject itunes = (AbstractITunesObject)module;
        if (itunes instanceof FeedInformationImpl) {
            info = (FeedInformationImpl)itunes;
            Element owner = this.generateSimpleElement("owner", "");
            Element email = this.generateSimpleElement("email", ((FeedInformationImpl)info).getOwnerEmailAddress());
            owner.addContent((Content)email);
            Element name = this.generateSimpleElement("name", ((FeedInformationImpl)info).getOwnerName());
            owner.addContent((Content)name);
            element.addContent((Content)owner);
            if (((FeedInformationImpl)info).getImage() != null) {
                Element image = this.generateSimpleElement("image", "");
                image.setAttribute("href", ((FeedInformationImpl)info).getImage().toExternalForm());
                element.addContent((Content)image);
            }
        } else if (itunes instanceof EntryInformationImpl) {
            info = (EntryInformationImpl)itunes;
            if (((EntryInformationImpl)info).getAuthor() != null) {
                element.addContent((Content)this.generateSimpleElement("author", ((EntryInformationImpl)info).getAuthor()));
            }
            if (((EntryInformationImpl)info).getDuration() != null) {
                element.addContent((Content)this.generateSimpleElement("duration", ((EntryInformationImpl)info).getDuration().toString()));
            }
        }
        if (itunes.getBlock()) {
            element.addContent((Content)this.generateSimpleElement("block", ""));
        }
        if (itunes.getCategory() != null) {
            Element category = this.generateSimpleElement("category", "");
            category.setAttribute("text", itunes.getCategory().getName());
            if (itunes.getCategory().getSubcategory() != null) {
                Element subcat = this.generateSimpleElement("category", "");
                subcat.setAttribute("text", itunes.getCategory().getSubcategory().getName());
                category.addContent((Content)subcat);
            }
            element.addContent((Content)category);
        }
        if (itunes.getExplicit()) {
            element.addContent((Content)this.generateSimpleElement("explicit", "yes"));
        } else {
            element.addContent((Content)this.generateSimpleElement("explicit", "no"));
        }
        if (itunes.getKeywords() != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < itunes.getKeywords().length; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(itunes.getKeywords()[i]);
            }
            element.addContent((Content)this.generateSimpleElement("keywords", sb.toString()));
        }
        if (itunes.getSubtitle() != null) {
            element.addContent((Content)this.generateSimpleElement("subtitle", itunes.getSubtitle()));
        }
        if (itunes.getSummary() != null) {
            element.addContent((Content)this.generateSimpleElement("summary", itunes.getSummary()));
        }
    }

    public Set getNamespaces() {
        return SET;
    }

    public String getNamespaceUri() {
        return "http://www.itunes.com/DTDs/Podcast-1.0.dtd";
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, NS);
        element.addContent(value);
        return element;
    }

    static {
        SET.add(NS);
    }
}

