/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.jbosscache;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexChangesFilter;
import org.exoplatform.services.jcr.impl.storage.jbosscache.AbstractWriteOnlyCacheLoader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexerCacheLoader
extends AbstractWriteOnlyCacheLoader {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexerCacheLoader");
    private SearchManager searchManager;
    private SearchManager parentSearchManager;
    private QueryHandler handler;
    private QueryHandler parentHandler;
    private volatile IndexerIoModeHandler modeHandler;

    public void commit(Object tx) throws Exception {
    }

    public void init(SearchManager searchManager, SearchManager parentSearchManager, QueryHandler handler, QueryHandler parentHandler) throws RepositoryConfigurationException {
        this.searchManager = searchManager;
        this.parentSearchManager = parentSearchManager;
        this.handler = handler;
        this.parentHandler = parentHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (key.equals(JBossCacheIndexChangesFilter.LISTWRAPPER) && value instanceof ChangesFilterListsWrapper) {
            if (this.log.isDebugEnabled()) {
                this.log.info((Object)"Received list wrapper, start indexing...");
            }
            ChangesFilterListsWrapper wrapper = (ChangesFilterListsWrapper)value;
            try {
                this.updateIndex(wrapper.getAddedNodes(), wrapper.getRemovedNodes(), wrapper.getParentAddedNodes(), wrapper.getParentRemovedNodes());
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.cache.removeNode(name);
                throw throwable;
            }
            this.cache.removeNode(name);
            {
            }
        }
        return null;
    }

    public void put(Fqn arg0, Map<Object, Object> arg1) throws Exception {
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
    }

    public void remove(Fqn arg0) throws Exception {
    }

    void setMode(IndexerIoMode ioMode) {
        if (this.modeHandler != null) {
            this.modeHandler.setMode(ioMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexerIoModeHandler getModeHandler() {
        if (this.modeHandler == null) {
            if (this.cache.getCacheStatus() != CacheStatus.STARTED) {
                throw new IllegalStateException("The cache should be started first");
            }
            IndexerCacheLoader indexerCacheLoader = this;
            synchronized (indexerCacheLoader) {
                if (this.modeHandler == null) {
                    this.modeHandler = new IndexerIoModeHandler(this.cache.getRPCManager().isCoordinator() ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY);
                }
            }
        }
        return this.modeHandler;
    }

    protected void updateIndex(Set<String> addedNodes, Set<String> removedNodes, Set<String> parentAddedNodes, Set<String> parentRemovedNodes) {
        if (this.searchManager != null && (addedNodes.size() > 0 || removedNodes.size() > 0)) {
            try {
                this.searchManager.updateIndex(removedNodes, addedNodes);
            }
            catch (RepositoryException e) {
                this.log.error((Object)("Error indexing changes " + (Object)((Object)e)), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)("Error indexing changes " + e), (Throwable)e);
                try {
                    this.handler.logErrorChanges(removedNodes, addedNodes);
                }
                catch (IOException ioe) {
                    this.log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + ioe), (Throwable)ioe);
                }
            }
        }
        if (this.parentSearchManager != null && (parentAddedNodes.size() > 0 || parentRemovedNodes.size() > 0)) {
            try {
                this.parentSearchManager.updateIndex(parentRemovedNodes, parentAddedNodes);
            }
            catch (RepositoryException e) {
                this.log.error((Object)("Error indexing changes " + (Object)((Object)e)), (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)("Error indexing changes " + e), (Throwable)e);
                try {
                    this.parentHandler.logErrorChanges(removedNodes, addedNodes);
                }
                catch (IOException ioe) {
                    this.log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + ioe), (Throwable)ioe);
                }
            }
        }
    }
}

