/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.metadata.UIMetadataForm;
import org.exoplatform.ecm.webui.component.admin.metadata.UIMetadataManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/metadata/UIMetadataList.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIMetadataList.msg.confirm-delete")})
public class UIMetadataList
extends UIContainer {
    public static final String INTERNAL_USE = "exo:internalUse".intern();

    public UIMetadataList() throws Exception {
        this.addChild(UIPageIterator.class, null, "MetaDataListIterator");
    }

    public void updateGrid() throws Exception {
        UIPageIterator uiPageIterator = (UIPageIterator)this.getChild(UIPageIterator.class);
        ObjectPageList pageList = new ObjectPageList(this.getAllMetadatas(), 10);
        uiPageIterator.setPageList((PageList)pageList);
    }

    public List<Metadata> getAllMetadatas() throws Exception {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        MetadataService metadataService = (MetadataService)this.getApplicationComponent(MetadataService.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        List nodetypes = metadataService.getAllMetadatasNodeType(repository);
        Collections.sort(nodetypes, new Utils.NodeTypeNameComparator());
        block0: for (NodeType nt : nodetypes) {
            Metadata mt = new Metadata();
            mt.setName(nt.getName());
            mt.isTemplate(metadataService.hasMetadata(nt.getName(), repository));
            for (PropertyDefinition def : nt.getPropertyDefinitions()) {
                if (!def.getName().equals(INTERNAL_USE)) continue;
                if (def.getDefaultValues() != null && def.getDefaultValues()[0].getBoolean()) {
                    mt.setInternalUse("True");
                } else {
                    mt.setInternalUse("False");
                }
                metadatas.add(mt);
                continue block0;
            }
        }
        return metadatas;
    }

    public List getListMetadata() throws Exception {
        return ((UIPageIterator)this.getChild(UIPageIterator.class)).getCurrentPageData();
    }

    public class Metadata {
        private String name;
        private String internalUse;
        private boolean hasTemplate = false;

        public String getName() {
            return this.name;
        }

        public void setName(String n) {
            this.name = n;
        }

        public String getInternalUse() {
            return this.internalUse;
        }

        public void setInternalUse(String inter) {
            this.internalUse = inter;
        }

        public boolean hasTemplate() {
            return this.hasTemplate;
        }

        public void isTemplate(boolean isTemplate) {
            this.hasTemplate = isTemplate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIMetadataList> {
        public void execute(Event<UIMetadataList> event) throws Exception {
            UIMetadataList uiMetaList = (UIMetadataList)((Object)event.getSource());
            String metadataName = event.getRequestContext().getRequestParameter("objectId");
            UIMetadataManager uiManager = (UIMetadataManager)uiMetaList.getParent();
            String repository = ((UIECMAdminPortlet)uiMetaList.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            MetadataService metadataService = (MetadataService)uiMetaList.getApplicationComponent(MetadataService.class);
            metadataService.removeMetadata(metadataName, repository);
            uiMetaList.updateGrid();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            UIApplication uiApp = (UIApplication)uiMetaList.getAncestorOfType(UIApplication.class);
            Object[] args = new Object[]{metadataName};
            uiApp.addMessage(new ApplicationMessage("UIMetadataList.msg.delete-successful", args));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIMetadataList> {
        public void execute(Event<UIMetadataList> event) throws Exception {
            UIMetadataList uiMetaList = (UIMetadataList)((Object)event.getSource());
            String metadataName = event.getRequestContext().getRequestParameter("objectId");
            UIMetadataManager uiManager = (UIMetadataManager)uiMetaList.getParent();
            uiManager.initPopup();
            UIMetadataForm uiForm = (UIMetadataForm)uiManager.findFirstComponentOfType(UIMetadataForm.class);
            uiForm.update(metadataName);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewActionListener
    extends EventListener<UIMetadataList> {
        public void execute(Event<UIMetadataList> event) throws Exception {
            UIMetadataList uiMetaList = (UIMetadataList)((Object)event.getSource());
            String metadataName = event.getRequestContext().getRequestParameter("objectId");
            UIMetadataManager uiManager = (UIMetadataManager)uiMetaList.getParent();
            uiManager.removeChildById("ViewMetadataPopup");
            uiManager.initViewPopup(metadataName);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

