/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.link;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.cms.link.PropertyLinkAware;
import org.exoplatform.services.cms.link.SessionLinkAware;

public abstract class ItemLinkAware
implements Item {
    protected final Item item;
    protected final String virtualPath;
    protected final Session originalSession;

    protected ItemLinkAware(Session originalSession, String virtualPath, Item item) {
        this.originalSession = originalSession;
        this.item = item;
        if (!virtualPath.startsWith("/")) {
            throw new IllegalArgumentException("The path '" + virtualPath + "' must be an absolute path");
        }
        this.virtualPath = virtualPath;
    }

    public static ItemLinkAware newInstance(Session originalSession, String originalAbsPath, Item item) {
        if (item instanceof Node) {
            return new NodeLinkAware(originalSession, originalAbsPath, (Node)item);
        }
        return new PropertyLinkAware(originalSession, originalAbsPath, (Property)item);
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.item.accept(visitor);
    }

    public Item getAncestor(int depth) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return LinkUtils.getNodeFinder().getItem(this.originalSession, LinkUtils.getAncestorPath(this.virtualPath, depth));
    }

    public int getDepth() throws RepositoryException {
        return LinkUtils.getDepth(this.virtualPath);
    }

    public String getName() throws RepositoryException {
        return this.item.getName();
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return (Node)LinkUtils.getNodeFinder().getItem(this.originalSession, LinkUtils.getParentPath(this.virtualPath));
    }

    public String getPath() throws RepositoryException {
        return this.virtualPath;
    }

    public Session getSession() throws RepositoryException {
        return new SessionLinkAware(this);
    }

    public boolean isModified() {
        return this.item.isModified();
    }

    public boolean isNew() {
        return this.item.isNew();
    }

    public boolean isNode() {
        return this.item.isNode();
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        return this.item.isSame(otherItem);
    }

    public void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        this.item.refresh(keepChanges);
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.item.remove();
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.item.save();
    }
}

