/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.content.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.content.model.ContentItem;
import org.exoplatform.content.model.ContentNode;
import org.exoplatform.content.service.ContentDAO;
import org.exoplatform.content.service.ContentPlugin;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseContentService {
    private List<ContentPlugin> plugins_;
    protected ExoCache contentCache_;

    public BaseContentService(CacheService cservice) throws Exception {
        this.contentCache_ = cservice.getCacheInstance(ContentDAO.class.getName());
        this.contentCache_.setLiveTime(300000L);
        this.contentCache_.setMaxSize(10);
        this.plugins_ = new ArrayList<ContentPlugin>();
    }

    public void initListener(ComponentPlugin listener) {
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof ContentPlugin) {
            this.plugins_.add((ContentPlugin)plugin);
        }
    }

    public List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (ContentPlugin plugin : this.plugins_) {
            if (types.contains(plugin.getType())) continue;
            types.add(plugin.getType());
        }
        return types;
    }

    public <T extends ContentItem> PageList getContentData(ContentNode node) throws Exception {
        PageList pageList = (PageList)this.contentCache_.get((Serializable)((Object)node.getId()));
        if (pageList != null && !node.getType().equals("desc")) {
            return pageList;
        }
        for (ContentPlugin plugin : this.plugins_) {
            if (!plugin.getType().equals(node.getType())) continue;
            pageList = plugin.loadContentMeta(node);
            this.contentCache_.put((Serializable)((Object)node.getId()), (Object)pageList);
            return pageList;
        }
        return new PageList(0){

            public List<?> getAll() {
                return null;
            }

            public void populateCurrentPage(int page) throws Exception {
            }
        };
    }

    public void removeCache(String id) throws Exception {
        this.contentCache_.remove((Serializable)((Object)id));
    }

    public String toXML(Object object) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.marshall(os, object);
        return new String(os.toByteArray());
    }

    public Object fromXML(String xml, Class<?> type) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        return this.unmarshall(is, type);
    }

    private Object unmarshall(InputStream is, Class<?> type) throws Exception {
        IBindingFactory bfact = BindingDirectory.getFactory(type);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return uctx.unmarshalDocument(is, null);
    }

    private void marshall(OutputStream os, Object obj) throws Exception {
        IBindingFactory bfact = BindingDirectory.getFactory(obj.getClass());
        IMarshallingContext mctx = bfact.createMarshallingContext();
        mctx.setIndent(2);
        mctx.marshalDocument(obj, "UTF-8", null, os);
    }
}

