/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model.types;

import org.apache.poi.hdf.model.hdftypes.HDFType;
import org.apache.poi.hwpf.usermodel.BorderCode;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public abstract class TCAbstractType
implements HDFType {
    protected short field_1_rgf;
    private static BitField fFirstMerged = BitFieldFactory.getInstance((int)1);
    private static BitField fMerged = BitFieldFactory.getInstance((int)2);
    private static BitField fVertical = BitFieldFactory.getInstance((int)4);
    private static BitField fBackward = BitFieldFactory.getInstance((int)8);
    private static BitField fRotateFont = BitFieldFactory.getInstance((int)16);
    private static BitField fVertMerge = BitFieldFactory.getInstance((int)32);
    private static BitField fVertRestart = BitFieldFactory.getInstance((int)64);
    private static BitField vertAlign = BitFieldFactory.getInstance((int)384);
    protected short field_2_unused;
    protected BorderCode field_3_brcTop;
    protected BorderCode field_4_brcLeft;
    protected BorderCode field_5_brcBottom;
    protected BorderCode field_6_brcRight;

    protected void fillFields(byte[] data, int offset) {
        this.field_1_rgf = LittleEndian.getShort((byte[])data, (int)(0 + offset));
        this.field_2_unused = LittleEndian.getShort((byte[])data, (int)(2 + offset));
        this.field_3_brcTop = new BorderCode(data, 4 + offset);
        this.field_4_brcLeft = new BorderCode(data, 8 + offset);
        this.field_5_brcBottom = new BorderCode(data, 12 + offset);
        this.field_6_brcRight = new BorderCode(data, 16 + offset);
    }

    public void serialize(byte[] data, int offset) {
        LittleEndian.putShort((byte[])data, (int)(0 + offset), (short)this.field_1_rgf);
        LittleEndian.putShort((byte[])data, (int)(2 + offset), (short)this.field_2_unused);
        this.field_3_brcTop.serialize(data, 4 + offset);
        this.field_4_brcLeft.serialize(data, 8 + offset);
        this.field_5_brcBottom.serialize(data, 12 + offset);
        this.field_6_brcRight.serialize(data, 16 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TC]\n");
        buffer.append("    .rgf                  = ");
        buffer.append(" (").append(this.getRgf()).append(" )\n");
        buffer.append("         .fFirstMerged             = ").append(this.isFFirstMerged()).append('\n');
        buffer.append("         .fMerged                  = ").append(this.isFMerged()).append('\n');
        buffer.append("         .fVertical                = ").append(this.isFVertical()).append('\n');
        buffer.append("         .fBackward                = ").append(this.isFBackward()).append('\n');
        buffer.append("         .fRotateFont              = ").append(this.isFRotateFont()).append('\n');
        buffer.append("         .fVertMerge               = ").append(this.isFVertMerge()).append('\n');
        buffer.append("         .fVertRestart             = ").append(this.isFVertRestart()).append('\n');
        buffer.append("         .vertAlign                = ").append(this.getVertAlign()).append('\n');
        buffer.append("    .unused               = ");
        buffer.append(" (").append(this.getUnused()).append(" )\n");
        buffer.append("    .brcTop               = ");
        buffer.append(" (").append(this.getBrcTop()).append(" )\n");
        buffer.append("    .brcLeft              = ");
        buffer.append(" (").append(this.getBrcLeft()).append(" )\n");
        buffer.append("    .brcBottom            = ");
        buffer.append(" (").append(this.getBrcBottom()).append(" )\n");
        buffer.append("    .brcRight             = ");
        buffer.append(" (").append(this.getBrcRight()).append(" )\n");
        buffer.append("[/TC]\n");
        return buffer.toString();
    }

    public int getSize() {
        return 24;
    }

    public short getRgf() {
        return this.field_1_rgf;
    }

    public void setRgf(short field_1_rgf) {
        this.field_1_rgf = field_1_rgf;
    }

    public short getUnused() {
        return this.field_2_unused;
    }

    public void setUnused(short field_2_unused) {
        this.field_2_unused = field_2_unused;
    }

    public BorderCode getBrcTop() {
        return this.field_3_brcTop;
    }

    public void setBrcTop(BorderCode field_3_brcTop) {
        this.field_3_brcTop = field_3_brcTop;
    }

    public BorderCode getBrcLeft() {
        return this.field_4_brcLeft;
    }

    public void setBrcLeft(BorderCode field_4_brcLeft) {
        this.field_4_brcLeft = field_4_brcLeft;
    }

    public BorderCode getBrcBottom() {
        return this.field_5_brcBottom;
    }

    public void setBrcBottom(BorderCode field_5_brcBottom) {
        this.field_5_brcBottom = field_5_brcBottom;
    }

    public BorderCode getBrcRight() {
        return this.field_6_brcRight;
    }

    public void setBrcRight(BorderCode field_6_brcRight) {
        this.field_6_brcRight = field_6_brcRight;
    }

    public void setFFirstMerged(boolean value) {
        this.field_1_rgf = (short)fFirstMerged.setBoolean((int)this.field_1_rgf, value);
    }

    public boolean isFFirstMerged() {
        return fFirstMerged.isSet((int)this.field_1_rgf);
    }

    public void setFMerged(boolean value) {
        this.field_1_rgf = (short)fMerged.setBoolean((int)this.field_1_rgf, value);
    }

    public boolean isFMerged() {
        return fMerged.isSet((int)this.field_1_rgf);
    }

    public void setFVertical(boolean value) {
        this.field_1_rgf = (short)fVertical.setBoolean((int)this.field_1_rgf, value);
    }

    public boolean isFVertical() {
        return fVertical.isSet((int)this.field_1_rgf);
    }

    public void setFBackward(boolean value) {
        this.field_1_rgf = (short)fBackward.setBoolean((int)this.field_1_rgf, value);
    }

    public boolean isFBackward() {
        return fBackward.isSet((int)this.field_1_rgf);
    }

    public void setFRotateFont(boolean value) {
        this.field_1_rgf = (short)fRotateFont.setBoolean((int)this.field_1_rgf, value);
    }

    public boolean isFRotateFont() {
        return fRotateFont.isSet((int)this.field_1_rgf);
    }

    public void setFVertMerge(boolean value) {
        this.field_1_rgf = (short)fVertMerge.setBoolean((int)this.field_1_rgf, value);
    }

    public boolean isFVertMerge() {
        return fVertMerge.isSet((int)this.field_1_rgf);
    }

    public void setFVertRestart(boolean value) {
        this.field_1_rgf = (short)fVertRestart.setBoolean((int)this.field_1_rgf, value);
    }

    public boolean isFVertRestart() {
        return fVertRestart.isSet((int)this.field_1_rgf);
    }

    public void setVertAlign(byte value) {
        this.field_1_rgf = (short)vertAlign.setValue((int)this.field_1_rgf, (int)value);
    }

    public byte getVertAlign() {
        return (byte)vertAlign.getValue((int)this.field_1_rgf);
    }
}

