/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.plugin.actions.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.actions.impl.ActionConfig;
import org.exoplatform.services.cms.actions.impl.BaseActionLauncherListener;
import org.exoplatform.services.cms.actions.impl.BaseActionPlugin;
import org.exoplatform.services.cms.actions.impl.ECMEventListener;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.plugin.actions.activation.BPActionActivationJob;
import org.exoplatform.services.workflow.Process;
import org.exoplatform.services.workflow.WorkflowServiceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPActionPlugin
extends BaseActionPlugin
implements ComponentPlugin {
    public static final String ACTION_TYPE = "exo:businessProcessAction";
    private WorkflowServiceContainer workflowServiceContainer_;
    private ActionConfig config_;
    private RepositoryService repositoryService_;

    public BPActionPlugin(RepositoryService repositoryService, InitParams params, WorkflowServiceContainer workflowServiceContainer) throws Exception {
        this.workflowServiceContainer_ = workflowServiceContainer;
        this.repositoryService_ = repositoryService;
        this.config_ = (ActionConfig)params.getObjectParamValues(ActionConfig.class).get(0);
    }

    public Collection<String> getActionExecutables(String repository) throws Exception {
        List processes = this.workflowServiceContainer_.getProcesses();
        ArrayList<String> businessProcesses = new ArrayList<String>();
        ListIterator iter = processes.listIterator();
        while (iter.hasNext()) {
            Process process = (Process)iter.next();
            businessProcesses.add(process.getName());
        }
        return businessProcesses;
    }

    protected ECMEventListener createEventListener(String actionName, String moveExecutable, String repository, String srcWorkspace, String srcPath, Map variables, String actionType) throws Exception {
        return new BPActionLauncherListener(actionName, moveExecutable, repository, srcWorkspace, srcPath, variables);
    }

    public String getActionExecutableLabel() {
        return "Business Processes:";
    }

    public String getExecutableDefinitionName() {
        return "exo:businessProcess";
    }

    protected String getRepositoryName() {
        return this.config_.getRepository();
    }

    protected String getWorkspaceName() {
        return this.config_.getWorkspace();
    }

    protected List<RepositoryEntry> getRepositories() {
        return this.repositoryService_.getConfig().getRepositoryConfigurations();
    }

    protected ManageableRepository getRepository(String repository) throws Exception {
        return this.repositoryService_.getRepository(repository);
    }

    protected String getActionType() {
        return ACTION_TYPE;
    }

    protected List getActions() {
        return this.config_.getActions();
    }

    public String getName() {
        return ACTION_TYPE;
    }

    public void setName(String s) {
    }

    public String getDescription() {
        return "Add an action service";
    }

    public void setDescription(String desc) {
    }

    public void executeAction(String userId, Node actionNode, Map variables, String repository) throws Exception {
        String businessProcess = actionNode.getProperty("exo:businessProcess").getString();
        variables.put("repository", repository);
        this.executeAction(userId, businessProcess, variables, repository);
    }

    public void executeAction(String userId, String executable, Map variables, String repository) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        WorkflowServiceContainer workflowSContainer = (WorkflowServiceContainer)container.getComponentInstanceOfType(WorkflowServiceContainer.class);
        workflowSContainer.startProcessFromName(userId, executable, variables);
    }

    public void activateAction(String userId, String executable, Map variables, String repository) throws Exception {
        this.executeAction(userId, executable, variables, repository);
    }

    protected Class createActivationJob() throws Exception {
        return BPActionActivationJob.class;
    }

    public class BPActionLauncherListener
    extends BaseActionLauncherListener {
        public BPActionLauncherListener(String actionName, String businessProcess, String repository, String srcWorkspace, String srcPath, Map actionVariables) throws Exception {
            super(actionName, businessProcess, repository, srcWorkspace, srcPath, actionVariables);
        }

        public void triggerAction(String userId, Map variables, String repository) {
            BPActionPlugin.this.executeAction(userId, this.executable_, variables, repository);
        }
    }
}

