/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.transform.impl.trax;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.xml.transform.NotSupportedIOTypeException;
import org.exoplatform.services.xml.transform.impl.trax.TRAXTemplatesLoaderPlugin;
import org.exoplatform.services.xml.transform.trax.TRAXTemplates;
import org.exoplatform.services.xml.transform.trax.TRAXTemplatesService;
import org.exoplatform.services.xml.transform.trax.TRAXTransformerService;
import org.picocontainer.Startable;

public class TRAXTemplatesServiceImpl
implements TRAXTemplatesService,
Startable {
    private static final Log LOGGER = ExoLogger.getLogger((String)"exo.core.component.xml-processing.TRAXTemplatesServiceImpl");
    private Map<String, TRAXTemplates> templates_;
    private TRAXTransformerService traxTransformerService_;

    public TRAXTemplatesServiceImpl(TRAXTransformerService traxTransformerService) {
        this.traxTransformerService_ = traxTransformerService;
        this.templates_ = new HashMap<String, TRAXTemplates>();
    }

    public TRAXTemplates getTemplates(String key) {
        return this.templates_.get(key);
    }

    public void addTRAXTemplates(String key, TRAXTemplates templates) throws IllegalArgumentException {
        if (this.templates_.get(key) != null) {
            throw new IllegalArgumentException("Templates with key '" + key + "' already exists!");
        }
        this.templates_.put(key, templates);
    }

    public void addTRAXTemplates(String key, Source source) throws IllegalArgumentException {
        if (this.templates_.get(key) != null) {
            throw new IllegalArgumentException("Templates with key '" + key + "' already exists!");
        }
        try {
            this.templates_.put(key, this.traxTransformerService_.getTemplates(source));
        }
        catch (NotSupportedIOTypeException e) {
            throw new IllegalArgumentException("Source has unsupported context." + e);
        }
        catch (TransformerException e) {
            throw new IllegalArgumentException("Can't get templates from source." + e);
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof TRAXTemplatesLoaderPlugin) {
            Map<String, String> m = ((TRAXTemplatesLoaderPlugin)plugin).getTRAXTemplates();
            Set<String> keys = m.keySet();
            for (String key : keys) {
                String xsltSchema = m.get(key);
                try {
                    if (Thread.currentThread().getContextClassLoader().getResource(xsltSchema) != null) {
                        LOGGER.info((Object)("XSLT schema found by relative path: " + xsltSchema));
                        this.addTRAXTemplates(key, this.traxTransformerService_.getTemplates(new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(xsltSchema))));
                        continue;
                    }
                    LOGGER.error((Object)("XSLT schema not found: " + xsltSchema));
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Add new TRAXTemplates failed : " + e));
                }
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

