/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.navigation;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.webui.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationService {
    public String getNavigationsAsJSON(List<PageNavigation> navigations) throws Exception {
        String JSONnavigation = this.createJsonTree(navigations).toString();
        return JSONnavigation;
    }

    private StringBuffer createJsonTree(List<PageNavigation> navigations) {
        StringBuffer js = new StringBuffer();
        js.append("[");
        boolean first = true;
        for (PageNavigation navigation : navigations) {
            if (!first) {
                js.append(",");
            }
            first = false;
            js.append("{");
            js.append("\"ownerId\":\"" + navigation.getOwnerId() + "\",");
            js.append("\"ownerType\":\"" + navigation.getOwnerType() + "\",");
            js.append("\"owner\":\"" + navigation.getOwner() + "\",");
            js.append("\"priority\":\"" + navigation.getPriority() + "\",");
            js.append("\"nodes\":" + this.addJsonNodes(navigation.getNodes()));
            js.append("}");
        }
        js.append("]");
        return js;
    }

    private String addJsonNodes(List<PageNode> nodes) {
        StringBuffer js = new StringBuffer();
        js.append("[");
        boolean first = true;
        for (PageNode node : nodes) {
            if (!this.isVisibleNode(node)) continue;
            if (!first) {
                js.append(",");
            }
            first = false;
            String link = "#";
            if (node.getPageReference() != null) {
                link = Util.getPortalRequestContext().getPortalURI() + node.getUri();
            }
            js.append("{");
            js.append("\"icon\":" + (node.getIcon() != null ? "\"" + node.getIcon() + "\"" : "null") + ",");
            js.append("\"label\":\"" + node.getLabel() + "\",");
            js.append("\"name\":\"" + node.getName() + "\",");
            js.append("\"resolvedLabel\":\"" + node.getResolvedLabel() + "\",");
            js.append("\"uri\":\"" + node.getUri() + "\",");
            js.append("\"link\":\"" + link + "\",");
            js.append("\"nodes\":" + this.addJsonNodes(node.getNodes()));
            js.append("}");
        }
        js.append("]");
        return js.toString();
    }

    private boolean isVisibleNode(PageNode node) {
        if (!node.getVisibility().equals((Object)Visibility.DISPLAYED) && !node.getVisibility().equals((Object)Visibility.TEMPORAL)) {
            return false;
        }
        Date now = new Date(System.currentTimeMillis());
        if (node.getStartPublicationDate() != null && node.getStartPublicationDate().after(now)) {
            return false;
        }
        return node.getEndPublicationDate() == null || !node.getEndPublicationDate().before(now);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PortalNavigation {
        private List<PageNavigation> navigations = new ArrayList<PageNavigation>();

        public PortalNavigation(List<PageNavigation> list) {
            this.navigations = list;
        }

        public List<PageNavigation> getNavigations() {
            return this.navigations;
        }

        public void setNavigations(List<PageNavigation> list) {
            this.navigations = list;
        }
    }
}

