/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.search.UIContentNameSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISavedQuery;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.ecm.webui.component.explorer.search.UISimpleSearch;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/sidebar/UISavedSearches.gtmpl", events={@EventConfig(listeners={ExecuteActionListener.class}), @EventConfig(listeners={AdvanceSearchActionListener.class}), @EventConfig(listeners={SavedQueriesActionListener.class})})
public class UISavedSearches
extends UIComponent {
    public static final String ACTION_TAXONOMY = "exo:taxonomyAction";
    public static final String EXO_TARGETPATH = "exo:targetPath";
    public static final String EXO_TARGETWORKSPACE = "exo:targetWorkspace";
    private List<Node> sharedQueries_ = new ArrayList<Node>();
    private List<Query> privateQueries = new ArrayList<Query>();
    private String queryPath;

    public List<Object> queryList() throws Exception {
        ArrayList<Object> objectList = new ArrayList<Object>();
        if (this.hasSharedQueries()) {
            for (Node node : this.getSharedQueries()) {
                objectList.add(node);
            }
        }
        if (this.hasQueries()) {
            for (Query query : this.getQueries()) {
                objectList.add(query);
            }
        }
        return objectList;
    }

    public String getCurrentUserId() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public boolean hasQueries() throws Exception {
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        try {
            this.privateQueries = queryService.getQueries(this.getCurrentUserId(), this.getRepositoryName(), SessionProviderFactory.createSessionProvider());
            return !this.privateQueries.isEmpty();
        }
        catch (AccessDeniedException ace) {
            return this.privateQueries.isEmpty();
        }
    }

    public List<Query> getQueries() throws Exception {
        return this.privateQueries;
    }

    public boolean hasSharedQueries() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        String userId = pcontext.getRemoteUser();
        SessionProvider provider = SessionProviderFactory.createSystemProvider();
        this.sharedQueries_ = queryService.getSharedQueries(userId, this.getRepositoryName(), provider);
        return !this.sharedQueries_.isEmpty();
    }

    public List<Node> getSharedQueries() {
        return this.sharedQueries_;
    }

    public void setQueryPath(String queryPath) throws Exception {
        this.queryPath = queryPath;
    }

    public String getQueryPath() throws Exception {
        return this.queryPath;
    }

    private String getRepositoryName() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SavedQueriesActionListener
    extends EventListener<UISavedSearches> {
        public void execute(Event<UISavedSearches> event) throws Exception {
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)((UISavedSearches)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiJCRExplorer.getChild(UIPopupContainer.class);
            UISavedQuery uiSavedQuery = (UISavedQuery)((UISavedSearches)((Object)event.getSource())).createUIComponent(UISavedQuery.class, null, null);
            uiSavedQuery.setIsQuickSearch(true);
            uiSavedQuery.setRepositoryName(uiJCRExplorer.getRepositoryName());
            uiSavedQuery.updateGrid(1);
            UIPopupContainer2.activate((UIComponent)uiSavedQuery, 700, 400);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AdvanceSearchActionListener
    extends EventListener<UISavedSearches> {
        public void execute(Event<UISavedSearches> event) throws Exception {
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)((UISavedSearches)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiJCRExplorer.getChild(UIPopupContainer.class);
            UIECMSearch uiECMSearch = (UIECMSearch)((UISavedSearches)((Object)event.getSource())).createUIComponent(UIECMSearch.class, null, null);
            UIContentNameSearch contentNameSearch = (UIContentNameSearch)uiECMSearch.findFirstComponentOfType(UIContentNameSearch.class);
            String currentNodePath = uiJCRExplorer.getCurrentNode().getPath();
            Node currentNode = uiJCRExplorer.getCurrentNode();
            if (currentNode.isNodeType("exo:taxonomy")) {
                TaxonomyService taxonomyService = (TaxonomyService)uiJCRExplorer.getApplicationComponent(TaxonomyService.class);
                List TaxonomyTrees = taxonomyService.getAllTaxonomyTrees(uiJCRExplorer.getRepositoryName());
                block0: for (Node taxonomyNode : TaxonomyTrees) {
                    if (!currentNode.getPath().startsWith(taxonomyNode.getPath())) continue;
                    ActionServiceContainer actionService = (ActionServiceContainer)uiJCRExplorer.getApplicationComponent(ActionServiceContainer.class);
                    List listAction = actionService.getActions(taxonomyNode);
                    for (Node actionNode : listAction) {
                        if (!actionNode.isNodeType(UISavedSearches.ACTION_TAXONOMY)) continue;
                        String searchPath = actionNode.getProperty(UISavedSearches.EXO_TARGETPATH).getString();
                        String searchWorkspace = actionNode.getProperty(UISavedSearches.EXO_TARGETWORKSPACE).getString();
                        uiJCRExplorer.setSelectNode(searchWorkspace, searchPath);
                        uiJCRExplorer.setCurrentStatePath(searchPath);
                        currentNodePath = uiJCRExplorer.getCurrentNode().getPath();
                        ManageDriveService manageDriveService = (ManageDriveService)uiJCRExplorer.getApplicationComponent(ManageDriveService.class);
                        List driveList = manageDriveService.getAllDrives(uiJCRExplorer.getRepositoryName());
                        for (DriveData drive : driveList) {
                            if (!searchWorkspace.equals(drive.getWorkspace()) || !searchPath.contains(drive.getHomePath()) || !drive.getHomePath().equals("/")) continue;
                            uiJCRExplorer.setDriveData(drive);
                            break;
                        }
                        uiJCRExplorer.updateAjax(event);
                        continue block0;
                    }
                }
            }
            contentNameSearch.setLocation(currentNodePath);
            UISimpleSearch uiSimpleSearch = (UISimpleSearch)uiECMSearch.findFirstComponentOfType(UISimpleSearch.class);
            uiSimpleSearch.getUIFormInputInfo("nodePath").setValue((Object)currentNodePath);
            UIPopupContainer2.activate((UIComponent)uiECMSearch, 700, 500);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExecuteActionListener
    extends EventListener<UISavedSearches> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UISavedSearches> event) throws Exception {
            UISavedSearches uiSavedSearches = (UISavedSearches)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSavedSearches.getAncestorOfType(UIJCRExplorer.class);
            String queryPath = event.getRequestContext().getRequestParameter("objectId");
            uiSavedSearches.setQueryPath(queryPath);
            uiExplorer.setPathToAddressBar(Text.unescapeIllegalJcrChars((String)uiExplorer.filterPath(queryPath)));
            String wsName = ((UIJCRExplorer)uiSavedSearches.getAncestorOfType(UIJCRExplorer.class)).getCurrentWorkspace();
            UIApplication uiApp = (UIApplication)uiSavedSearches.getAncestorOfType(UIApplication.class);
            QueryService queryService = (QueryService)uiSavedSearches.getApplicationComponent(QueryService.class);
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIComponent uiSearch = uiWorkingArea.getChild(UIDocumentWorkspace.class);
            UISearchResult uiSearchResult = (UISearchResult)((UIDocumentWorkspace)uiSearch).getChild(UISearchResult.class);
            QueryResult queryResult = null;
            try {
                queryResult = queryService.execute(queryPath, wsName, uiExplorer.getRepositoryName(), SessionProviderFactory.createSystemProvider(), uiSavedSearches.getCurrentUserId());
            }
            catch (Exception e) {
                try {
                    uiApp.addMessage(new ApplicationMessage("UISearchResult.msg.query-invalid", null, 1));
                }
                catch (Throwable throwable) {
                    if (queryResult == null || queryResult.getNodes().getSize() == 0L) {
                        // empty if block
                    }
                    uiSearchResult.clearAll();
                    uiSearchResult.setQueryResults(queryResult);
                    uiSearchResult.updateGrid(true);
                    throw throwable;
                }
                if (queryResult == null || queryResult.getNodes().getSize() == 0L) {
                    // empty if block
                }
                uiSearchResult.clearAll();
                uiSearchResult.setQueryResults(queryResult);
                uiSearchResult.updateGrid(true);
            }
            if (queryResult == null || queryResult.getNodes().getSize() == 0L) {
                // empty if block
            }
            uiSearchResult.clearAll();
            uiSearchResult.setQueryResults(queryResult);
            uiSearchResult.updateGrid(true);
            UIDrivesArea uiDrivesArea = (UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class);
            if (uiDrivesArea != null) {
                uiDrivesArea.setRendered(false);
            }
            ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(true);
            ((UIDocumentWorkspace)uiSearch).setRenderedChild(UISearchResult.class);
        }
    }
}

