/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.content;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xcmis.search.InvalidQueryException;
import org.xcmis.search.lucene.content.ErrorReporter;

public class ErrorReporterImpl
implements ErrorReporter {
    private final List<String> msgList = new ArrayList<String>();
    private final List<Exception> exceptionsList = new ArrayList<Exception>();

    @Override
    public InvalidQueryException getException() {
        if (this.hasErrors()) {
            StringBuilder b = new StringBuilder("There is errors: \n");
            Iterator<String> it = this.msgList.iterator();
            while (it.hasNext()) {
                b.append(it.next() + '\n');
            }
            Iterator<Exception> ei = this.exceptionsList.iterator();
            while (ei.hasNext()) {
                b.append(ei.next().getMessage() + '\n');
            }
            InvalidQueryException ex = this.exceptionsList.size() > 0 ? new InvalidQueryException(b.toString(), (Throwable)this.exceptionsList.get(0)) : new InvalidQueryException(b.toString());
            return ex;
        }
        return null;
    }

    @Override
    public boolean hasErrors() {
        return this.msgList.size() > 0 || this.exceptionsList.size() > 0;
    }

    @Override
    public void reportMessage(String msg) {
        this.msgList.add(msg);
    }

    @Override
    public void reportException(Exception e) {
        this.exceptionsList.add(e);
    }

    @Override
    public void clear() {
        this.msgList.clear();
        this.exceptionsList.clear();
    }
}

