/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import java.util.Calendar;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.observation.ExtendedEventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditRecord
implements Comparable<AuditRecord> {
    private final String userId;
    private final int eventType;
    private final Calendar date;
    private final InternalQName propertyName;
    private final String version;
    private final String versionName;

    public AuditRecord(String userId, int eventType, Calendar date, InternalQName propertyName, String version, String versionName) {
        this.userId = userId;
        this.eventType = eventType;
        this.date = date;
        this.propertyName = propertyName;
        this.version = version;
        this.versionName = versionName;
    }

    public Calendar getDate() {
        return this.date;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEventTypeName() {
        return ExtendedEventType.nameFromValue((int)this.eventType);
    }

    public InternalQName getPropertyName() {
        return this.propertyName;
    }

    @Override
    public int compareTo(AuditRecord otherRecord) {
        return this.date.compareTo(otherRecord.getDate());
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionName() {
        return this.versionName;
    }
}

