/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractBaseCommand;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public abstract class AbstractGetObjectBaseCommand
extends AbstractBaseCommand {
    static final Log log = LogFactory.getLog((Class)AbstractGetObjectBaseCommand.class);
    private static final long serialVersionUID = 1L;
    private boolean includeAllVariables = false;
    private String[] variablesToInclude = new String[0];
    private transient JbpmContext jbpmContext;

    public AbstractGetObjectBaseCommand() {
    }

    public AbstractGetObjectBaseCommand(boolean includeAllVariables, boolean includeLogs) {
        this.includeAllVariables = includeAllVariables;
    }

    public AbstractGetObjectBaseCommand(String[] variablesToInclude) {
        this.variablesToInclude = variablesToInclude;
    }

    public void retrieveTaskInstanceDetails(TaskInstance ti) {
        try {
            ti.getToken().getProcessInstance().getProcessDefinition().getName();
            ti.setProcessInstance(ti.getToken().getProcessInstance());
            ti.getToken().getNode().getName();
            ti.getTask().getName();
            ti.getAvailableTransitions();
            this.retrieveVariables(ti);
        }
        catch (Exception ex) {
            log.warn((Object)("exception while retrieving task instance data for task instance " + ti.getId()), (Throwable)ex);
        }
    }

    public ProcessInstance retrieveProcessInstance(ProcessInstance pi) {
        try {
            pi.getProcessDefinition().getName();
            this.retrieveToken(pi.getRootToken());
            if (pi.getSuperProcessToken() != null) {
                pi.getSuperProcessToken().getId();
                pi.getSuperProcessToken().getProcessInstance().getId();
            }
            this.retrieveVariables(pi);
        }
        catch (Exception ex) {
            log.warn((Object)("exception while retrieving process instance data for process instance " + pi.getId()), (Throwable)ex);
        }
        return pi;
    }

    public ProcessDefinition retrieveProcessDefinition(ProcessDefinition pd) {
        try {
            pd.getName();
            Iterator iter = pd.getStartState().getLeavingTransitions().iterator();
            while (iter.hasNext()) {
                Transition t = (Transition)iter.next();
                t.getName();
            }
        }
        catch (Exception ex) {
            log.warn((Object)("exception while retrieving process instance data for process definiton " + pd.getName()), (Throwable)ex);
        }
        return pd;
    }

    protected void retrieveToken(Token t) {
        this.retrieveNode(t.getNode());
        t.getAvailableTransitions();
        Iterator iter = t.getChildren().values().iterator();
        while (iter.hasNext()) {
            this.retrieveToken((Token)iter.next());
        }
    }

    protected void retrieveNode(Node n) {
        n.getName();
        n.getLeavingTransitions();
        if (n.getSuperState() != null) {
            this.retrieveNode(n.getSuperState());
        }
    }

    public void retrieveVariables(ProcessInstance pi) {
        if (this.includeAllVariables) {
            pi.getContextInstance().getVariables();
        } else {
            for (int i = 0; i < this.variablesToInclude.length; ++i) {
                pi.getContextInstance().getVariable(this.variablesToInclude[i]);
            }
        }
    }

    public void retrieveVariables(TaskInstance ti) {
        if (this.includeAllVariables) {
            ti.getVariables();
        } else {
            for (int i = 0; i < this.variablesToInclude.length; ++i) {
                ti.getVariable(this.variablesToInclude[i]);
            }
        }
    }

    public boolean isIncludeAllVariables() {
        return this.includeAllVariables;
    }

    public void setIncludeAllVariables(boolean includeAllVariables) {
        this.includeAllVariables = includeAllVariables;
    }

    public String[] getVariablesToInclude() {
        return this.variablesToInclude;
    }

    public void setVariablesToInclude(String[] variablesToInclude) {
        this.variablesToInclude = variablesToInclude;
    }

    public void setVariablesToInclude(String variableToInclude) {
        this.variablesToInclude = new String[]{variableToInclude};
    }

    protected JbpmContext getJbpmContext() {
        return this.jbpmContext;
    }

    protected void setJbpmContext(JbpmContext jbpmContext) {
        this.jbpmContext = jbpmContext;
    }

    public AbstractGetObjectBaseCommand variablesToInclude(String[] variablesToInclude) {
        this.setVariablesToInclude(variablesToInclude);
        return this;
    }

    public AbstractGetObjectBaseCommand variablesToInclude(String variableToInclude) {
        this.setVariablesToInclude(variableToInclude);
        return this;
    }

    public AbstractGetObjectBaseCommand includeAllVariables(boolean includeAllVariables) {
        this.setIncludeAllVariables(includeAllVariables);
        return this;
    }
}

