/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.UninstallerWizardScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.UninstallerConsoleScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.UninstallerUnattendedScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;

public class Uninstaller {
    private Uninstaller() {
    }

    public static void main(String[] stringArray) {
        try {
            ScreenExecutor screenExecutor = Uninstaller.getScreenExecutor(stringArray);
            new Controller(screenExecutor).start();
        }
        catch (Throwable throwable) {
            InstallerUtil.reportException(throwable);
            System.exit(1);
        }
    }

    private static ScreenExecutor getScreenExecutor(String[] stringArray) {
        InstallerUtil.CommandLineOptions commandLineOptions = InstallerUtil.parseCommandLine(stringArray);
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        File file = new File(ResourceHelper.getRuntimeDir(), "..").getAbsoluteFile();
        installerConfig.setInstallationDirectory(file);
        ScreenExecutor screenExecutor = commandLineOptions.quiet ? new UninstallerUnattendedScreenExecutor(commandLineOptions.quietOverwrite) : (commandLineOptions.console && installerConfig.isAllowConsole() ? new UninstallerConsoleScreenExecutor() : new UninstallerWizardScreenExecutor());
        InstallerVariables.init(commandLineOptions.varFileName, commandLineOptions.commandLineVars);
        return screenExecutor;
    }
}

