/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.ProcessAction;
import javax.portlet.ProcessEvent;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.WindowState;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericPortlet
implements Portlet,
PortletConfig,
EventPortlet,
ResourceServingPortlet {
    private transient PortletConfig config;
    private transient Map<String, Method> processActionHandlingMethodsMap = new HashMap<String, Method>();
    private transient Map<String, Method> processEventHandlingMethodsMap = new HashMap<String, Method>();
    private transient Map<String, Method> renderModeHandlingMethodsMap = new HashMap<String, Method>();

    @Override
    public void init(PortletConfig config) throws PortletException {
        this.config = config;
        this.cacheAnnotatedMethods();
        this.init();
    }

    public void init() throws PortletException {
    }

    @Override
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String action = request.getParameter("javax.portlet.action");
        try {
            Method actionMethod = this.processActionHandlingMethodsMap.get(action);
            if (actionMethod != null) {
                actionMethod.invoke((Object)this, request, response);
                return;
            }
        }
        catch (Exception e) {
            throw new PortletException(e);
        }
        throw new PortletException("processAction method not implemented");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        Object renderPartAttrValue = request.getAttribute("javax.portlet.render_part");
        if (renderPartAttrValue != null) {
            if (renderPartAttrValue.equals("RENDER_HEADERS")) {
                this.doHeaders(request, response);
                Collection<PortletMode> nextModes = this.getNextPossiblePortletModes(request);
                if (nextModes != null) {
                    response.setNextPossiblePortletModes(nextModes);
                }
                response.setTitle(this.getTitle(request));
                return;
            } else {
                if (!renderPartAttrValue.equals("RENDER_MARKUP")) throw new PortletException("Unknown value of the 'javax.portlet.render_part' request attribute");
                this.doDispatch(request, response);
            }
            return;
        } else {
            this.doHeaders(request, response);
            Collection<PortletMode> nextModes = this.getNextPossiblePortletModes(request);
            if (nextModes != null) {
                response.setNextPossiblePortletModes(nextModes);
            }
            response.setTitle(this.getTitle(request));
            this.doDispatch(request, response);
        }
    }

    protected String getTitle(RenderRequest request) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getResourceBundle(request.getLocale()).getString("javax.portlet.title");
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        WindowState state = request.getWindowState();
        if (!state.equals(WindowState.MINIMIZED)) {
            PortletMode mode = request.getPortletMode();
            try {
                Method renderMethod = this.renderModeHandlingMethodsMap.get(mode.toString());
                if (renderMethod != null) {
                    renderMethod.invoke((Object)this, request, response);
                    return;
                }
            }
            catch (Exception e) {
                throw new PortletException(e);
            }
            if (mode.equals(PortletMode.VIEW)) {
                this.doView(request, response);
            } else if (mode.equals(PortletMode.EDIT)) {
                this.doEdit(request, response);
            } else if (mode.equals(PortletMode.HELP)) {
                this.doHelp(request, response);
            } else {
                throw new PortletException("unknown portlet mode: " + mode);
            }
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doView method not implemented");
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doEdit method not implemented");
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doHelp method not implemented");
    }

    public PortletConfig getPortletConfig() {
        return this.config;
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getPortletName() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPortletName();
    }

    @Override
    public PortletContext getPortletContext() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPortletContext();
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getResourceBundle(locale);
    }

    @Override
    public String getInitParameter(String name) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getInitParameter(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getInitParameterNames();
    }

    @Override
    public Enumeration<QName> getProcessingEventQNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getProcessingEventQNames();
    }

    @Override
    public Enumeration<QName> getPublishingEventQNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPublishingEventQNames();
    }

    @Override
    public Enumeration<Locale> getSupportedLocales() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getSupportedLocales();
    }

    @Override
    public Map<String, String[]> getContainerRuntimeOptions() {
        return this.config.getContainerRuntimeOptions();
    }

    @Override
    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortletRequestDispatcher rd;
        if (request.getResourceID() != null && (rd = this.getPortletConfig().getPortletContext().getRequestDispatcher(request.getResourceID())) != null) {
            rd.forward(request, response);
        }
    }

    @Override
    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        String eventName = request.getEvent().getQName().toString();
        try {
            Method eventMethod = this.processEventHandlingMethodsMap.get(eventName);
            if (eventMethod != null) {
                eventMethod.invoke((Object)this, request, response);
                return;
            }
            int endPos = eventName.indexOf(125);
            int dotPos = eventName.lastIndexOf(46);
            while (dotPos > endPos) {
                String wildcardLookup = eventName.substring(0, dotPos + 1);
                eventMethod = this.processEventHandlingMethodsMap.get(wildcardLookup);
                if (eventMethod != null) {
                    eventMethod.invoke((Object)this, request, response);
                    return;
                }
                if (dotPos != 0) {
                    dotPos = eventName.lastIndexOf(46, dotPos - 1);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new PortletException(e);
        }
        response.setRenderParameters(request);
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) {
    }

    protected Collection<PortletMode> getNextPossiblePortletModes(RenderRequest request) {
        return null;
    }

    @Override
    public Enumeration<String> getPublicRenderParameterNames() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getPublicRenderParameterNames();
    }

    @Override
    public String getDefaultNamespace() {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getDefaultNamespace();
    }

    private void cacheAnnotatedMethods() {
        for (Method method : this.getClass().getMethods()) {
            Annotation[] annotations = method.getAnnotations();
            if (annotations == null) continue;
            for (Annotation annotation : annotations) {
                String name;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (ProcessAction.class.equals(annotationType)) {
                    name = ((ProcessAction)annotation).name();
                    if (name == null || name.length() <= 0) continue;
                    this.processActionHandlingMethodsMap.put(name, method);
                    continue;
                }
                if (ProcessEvent.class.equals(annotationType)) {
                    String qname = ((ProcessEvent)annotation).qname();
                    if (qname == null || qname.length() <= 0) {
                        if (this.config == null) {
                            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
                        }
                        String name2 = ((ProcessEvent)annotation).name();
                        if (name2 == null || name2.length() <= 0) continue;
                        qname = new QName(this.config.getDefaultNamespace(), name2).toString();
                        this.processEventHandlingMethodsMap.put(qname, method);
                        continue;
                    }
                    this.processEventHandlingMethodsMap.put(qname, method);
                    continue;
                }
                if (!RenderMode.class.equals(annotationType) || (name = ((RenderMode)annotation).name()) == null || name.length() <= 0) continue;
                this.renderModeHandlingMethodsMap.put(name.toLowerCase(), method);
            }
        }
    }
}

