/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.tika.mime.MimeTypeException;
import org.exoplatform.ecms.xcmis.sp.StorageClosableImpl;
import org.exoplatform.ecms.xcmis.sp.StorageConfiguration;
import org.exoplatform.ecms.xcmis.sp.StorageProviderImpl;
import org.exoplatform.ecms.xcmis.sp.index.CmisContentReader;
import org.exoplatform.ecms.xcmis.sp.index.CmisSchema;
import org.exoplatform.ecms.xcmis.sp.index.CmisSchemaTableResolver;
import org.exoplatform.ecms.xcmis.sp.index.ContentEntryAdapter;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.search.SearchService;
import org.xcmis.search.SearchServiceException;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.config.SearchServiceConfiguration;
import org.xcmis.search.content.ContentEntry;
import org.xcmis.search.content.IndexModificationException;
import org.xcmis.search.content.Schema;
import org.xcmis.search.content.interceptors.ContentReaderInterceptor;
import org.xcmis.search.lucene.content.VirtualTableResolver;
import org.xcmis.search.value.NameConverter;
import org.xcmis.search.value.ToStringNameConverter;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.Storage;
import org.xcmis.spi.TypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jcr2XcmisChangesListener
implements ItemsPersistenceListener {
    private static final Log LOG = ExoLogger.getExoLogger(Jcr2XcmisChangesListener.class);
    private final String currentRepositoryName;
    private final String workspaceName;
    private final SessionProviderService sessionProviderService;
    private final ManageableRepository repository;
    private SearchService searchService;
    private final PersistentDataManager dataManager;
    private Storage rootStorage;
    private final LocationFactory locationFactory;
    private final ContentEntryAdapter contentEntryAdapter;
    private final DocumentReaderService documentReaderService;

    public Jcr2XcmisChangesListener(String currentRepositoryName, String workspaceName, PersistentDataManager dataManager, SessionProviderService sessionProviderService, ManageableRepository repository, NamespaceAccessor namespaceAccessor, DocumentReaderService documentReaderService) {
        this.currentRepositoryName = currentRepositoryName;
        this.workspaceName = workspaceName;
        this.dataManager = dataManager;
        this.sessionProviderService = sessionProviderService;
        this.repository = repository;
        this.documentReaderService = documentReaderService;
        this.locationFactory = new LocationFactory(namespaceAccessor);
        this.contentEntryAdapter = new ContentEntryAdapter();
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public boolean isTXAware() {
        return false;
    }

    public void onSaveItems(ItemStateChangesLog itemStates) {
        this.applyChangesLog(itemStates);
    }

    private void applyChangesLog(ItemStateChangesLog itemStates) {
        if (this.searchService != null) {
            HashSet<String> removedNodes = new HashSet<String>();
            HashSet<String> addedNodes = new HashSet<String>();
            HashMap<String, List<ItemState>> updatedNodes = new HashMap<String, List<ItemState>>();
            String versionHistoryId = null;
            String linkedUUid = null;
            for (ItemState itemState : itemStates.getAllStates()) {
                PropertyData propertyData;
                String qPath;
                if (itemState.getData().isNode() && itemState.getData() instanceof NodeData && itemState.isDeleted()) {
                    NodeData nodeData = (NodeData)itemState.getData();
                    if (nodeData.getPrimaryTypeName().equals((Object)Constants.NT_VERSION)) {
                        String v = nodeData.getQPath().getName().getName();
                        if (v.equals("rootVersion")) {
                            if (versionHistoryId != null) {
                                removedNodes.add(versionHistoryId + "_" + "1");
                                versionHistoryId = null;
                            }
                            versionHistoryId = nodeData.getParentIdentifier();
                        } else {
                            Integer versionInt = null;
                            try {
                                versionInt = Integer.parseInt(v);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                            if (versionInt != null) {
                                String versionId = nodeData.getParentIdentifier() + "_" + v;
                                if (versionHistoryId != null) {
                                    if (versionId.startsWith(versionHistoryId)) {
                                        String rootVersionId = nodeData.getParentIdentifier() + "_" + String.valueOf(versionInt + 1);
                                        removedNodes.add(rootVersionId);
                                    } else {
                                        removedNodes.add(versionHistoryId + "_" + "1");
                                    }
                                    versionHistoryId = null;
                                }
                                removedNodes.add(versionId);
                            }
                        }
                    } else if (nodeData.getPrimaryTypeName().getAsString().equalsIgnoreCase("[http://www.exoplatform.com/jcr/xcmis/1.0]linkedFile") && linkedUUid != null) {
                        removedNodes.add(linkedUUid);
                        addedNodes.add(linkedUUid);
                    }
                } else if (!itemState.getData().isNode() && itemState.isDeleted() && (qPath = (propertyData = (PropertyData)itemState.getData()).getQPath().getAsString()).contains("[]cmisMultifilingObjectId_")) {
                    int beginIndex = qPath.lastIndexOf("cmisMultifilingObjectId_") + "cmisMultifilingObjectId_".length();
                    int endIndex = qPath.lastIndexOf(":");
                    linkedUUid = qPath.substring(beginIndex, endIndex);
                }
                try {
                    this.acceptChanges(removedNodes, addedNodes, updatedNodes, itemState);
                }
                catch (RepositoryException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (IllegalStateException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (versionHistoryId != null) {
                removedNodes.add(versionHistoryId + "_" + "1");
                versionHistoryId = null;
            }
            for (String uuid : updatedNodes.keySet()) {
                removedNodes.add(uuid);
                addedNodes.add(uuid);
            }
            if (removedNodes.size() > 0 || addedNodes.size() > 0) {
                ArrayList<ContentEntry> addedEntries = new ArrayList<ContentEntry>(addedNodes.size());
                for (String id : addedNodes) {
                    try {
                        this.addEntry(id, addedEntries, removedNodes);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (RepositoryException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                for (String uuid : removedNodes) {
                    try {
                        this.searchService.update(null, uuid);
                    }
                    catch (IndexModificationException e) {}
                }
                try {
                    this.searchService.update(addedEntries, Collections.EMPTY_SET);
                }
                catch (IndexModificationException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    private void addEntry(String uuid, List<ContentEntry> addedEntries, Set<String> removedNodes) throws RepositoryException, ObjectNotFoundException, IOException {
        ItemData data = this.dataManager.getItemData(uuid);
        if (data != null && data.isNode()) {
            String nodeTypeName = this.locationFactory.createJCRName(((NodeData)data).getPrimaryTypeName()).getAsString();
            if (((StorageClosableImpl)this.rootStorage).isSupportedNodeType(nodeTypeName)) {
                ObjectData objectData = ((StorageClosableImpl)this.rootStorage).getObjectById(uuid);
                addedEntries.add(this.contentEntryAdapter.createEntry(objectData));
                if (objectData instanceof DocumentData) {
                    String objectId = objectData.getObjectId();
                    if (uuid != objectData.getObjectId()) {
                        removedNodes.add(objectId);
                    }
                }
            } else if (nodeTypeName.equals("xcmis:linkedFile")) {
                List list = this.dataManager.getChildPropertiesData((NodeData)data);
                PropertyData propertyWithId = null;
                Iterator iter = list.iterator();
                while (iter.hasNext() && propertyWithId == null) {
                    PropertyData nextProperty = (PropertyData)iter.next();
                    if (nextProperty.getQPath().getAsString().contains(Constants.JCR_PRIMARYTYPE.getAsString()) || nextProperty.getQPath().getAsString().contains(Constants.JCR_MIXINTYPES.getAsString())) continue;
                    propertyWithId = nextProperty;
                }
                String linkedUUid = new String(((ValueData)propertyWithId.getValues().get(0)).getAsByteArray());
                this.addEntry(linkedUUid, addedEntries, removedNodes);
            }
        }
    }

    private void acceptChanges(Set<String> removedNodes, Set<String> addedNodes, Map<String, List<ItemState>> updatedNodes, ItemState itemState) throws RepositoryException, IllegalStateException, IOException {
        String uuidNode;
        String string = uuidNode = itemState.isNode() ? itemState.getData().getIdentifier() : itemState.getData().getParentIdentifier();
        if (itemState.isAdded()) {
            if (itemState.isNode()) {
                addedNodes.add(uuidNode);
            } else {
                this.addToUpdate(uuidNode, itemState, updatedNodes);
            }
        } else if (itemState.isRenamed()) {
            if (itemState.isNode()) {
                addedNodes.add(uuidNode);
            } else {
                this.addToUpdate(uuidNode, itemState, updatedNodes);
            }
        } else if (itemState.isUpdated()) {
            this.addToUpdate(uuidNode, itemState, updatedNodes);
        } else if (itemState.isMixinChanged()) {
            this.addToUpdate(uuidNode, itemState, updatedNodes);
        } else if (itemState.isDeleted()) {
            if (itemState.isNode()) {
                if (addedNodes.contains(uuidNode)) {
                    addedNodes.remove(uuidNode);
                }
                removedNodes.add(uuidNode);
                updatedNodes.remove(uuidNode);
            } else {
                this.addToUpdate(uuidNode, itemState, updatedNodes);
            }
        }
    }

    private void addToUpdate(String key, ItemState state, Map<String, List<ItemState>> updatedNodes) {
        List<ItemState> list = updatedNodes.get(key);
        if (list == null) {
            list = new ArrayList<ItemState>();
            updatedNodes.put(key, list);
        }
        list.add(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRegistryStart(IndexConfiguration readOnlyIndexConfiguration) throws RepositoryException, SearchServiceException {
        if (readOnlyIndexConfiguration != null && this.rootStorage == null) {
            try {
                StorageConfiguration rootStorageConfiguration = new StorageConfiguration(UUID.randomUUID().toString(), this.currentRepositoryName, this.workspaceName, "/", Collections.EMPTY_MAP, "Virtual root storage");
                SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
                Session session = null;
                try {
                    session = sessionProvider.getSession(this.workspaceName, this.repository);
                }
                finally {
                    session.logout();
                }
                this.rootStorage = new StorageClosableImpl(sessionProvider, this.workspaceName, this.repository, rootStorageConfiguration, new PermissionService(), StorageProviderImpl.DEFAULT_NODETYPE_MAPPING);
                CmisSchema schema = new CmisSchema((TypeManager)this.rootStorage);
                CmisSchemaTableResolver tableResolver = new CmisSchemaTableResolver((NameConverter)new ToStringNameConverter(), schema, (TypeManager)this.rootStorage);
                File rootFolder = new File(readOnlyIndexConfiguration.getIndexDir());
                File indexFolder = new File(new File(rootFolder, this.currentRepositoryName), this.workspaceName);
                IndexConfiguration indexConfiguration = new IndexConfiguration(indexFolder.getPath(), Constants.ROOT_PARENT_UUID, "00exo0jcr0root0uuid0000000000000");
                SearchServiceConfiguration configuration = new SearchServiceConfiguration((Schema)schema, (VirtualTableResolver)tableResolver, (ContentReaderInterceptor)new CmisContentReader(this.rootStorage), indexConfiguration);
                this.searchService = new SearchService(configuration);
                this.searchService.start();
            }
            catch (MimeTypeException e) {
                throw new SearchServiceException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new SearchServiceException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

