/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.IOException;
import java.util.Collection;
import java.util.TreeMap;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.resource.Codec;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.resources.Orientation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeSkin
implements Skin {
    private final SkinService service;
    private final String id;
    private final String urlPrefix;

    CompositeSkin(SkinService service, Collection<SkinConfig> skins) {
        TreeMap<String, SkinConfig> urlSkins = new TreeMap<String, SkinConfig>();
        for (SkinConfig skin : skins) {
            urlSkins.put(skin.getCSSPath(), skin);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(service.portalContainerName).append("/resource");
        StringBuilder id = new StringBuilder();
        try {
            for (SkinConfig cfg : urlSkins.values()) {
                StringBuilder encodedName = new StringBuilder();
                Codec.encode(encodedName, cfg.getName());
                StringBuilder encodedModule = new StringBuilder();
                Codec.encode(encodedModule, cfg.getModule());
                id.append((CharSequence)encodedName).append((CharSequence)encodedModule);
                builder.append("/").append((CharSequence)encodedName).append("/").append((CharSequence)encodedModule);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        this.service = service;
        this.id = id.toString();
        this.urlPrefix = builder.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public SkinURL createURL() {
        return new SkinURL(){
            Orientation orientation;

            public void setOrientation(Orientation orientation) {
                this.orientation = orientation;
            }

            public String toString() {
                return CompositeSkin.this.urlPrefix + "/" + (PropertyManager.isDevelopping() ? "style" : ((CompositeSkin)CompositeSkin.this).service.id) + CompositeSkin.this.service.getSuffix(this.orientation);
            }
        };
    }
}

