/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoriteServiceImpl
implements FavoriteService {
    private static final String EXO_PRIVILEGEABLE = "exo:privilegeable";
    private static final String EXO_FAVORITEFOLDER = "exo:favoriteFolder";
    private static final String NT_UNSTRUCTURED = "nt:unstructured";
    private static final String FAVORITE_ALIAS = "userPrivateFavorites";
    private NodeHierarchyCreator nodeHierarchyCreator;
    private LinkManager linkManager;
    private SessionProviderService sessionProviderService;

    public FavoriteServiceImpl(NodeHierarchyCreator nodeHierarchyCreator, LinkManager linkManager, SessionProviderService sessionProviderService) {
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.linkManager = linkManager;
        this.sessionProviderService = sessionProviderService;
    }

    @Override
    public void addFavorite(Node node, String userName) throws Exception {
        if (this.linkManager.isLink((Item)node)) {
            return;
        }
        Node userFavoriteNode = null;
        try {
            userFavoriteNode = this.getUserFavoriteFolder(userName);
        }
        catch (PathNotFoundException e) {
            userFavoriteNode = this.createFavoriteFolder(userName);
        }
        NodeIterator nodeIter = userFavoriteNode.getNodes();
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            if (!this.linkManager.isLink((Item)childNode)) continue;
            Node targetNode = null;
            try {
                targetNode = this.linkManager.getTarget(childNode);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!node.isSame((Item)targetNode)) continue;
            return;
        }
        this.linkManager.createLink(userFavoriteNode, node);
        userFavoriteNode.getSession().save();
    }

    @Override
    public List<Node> getAllFavoriteNodesByUser(String workspace, String repository, String userName) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        Node userFavoriteNode = this.getUserFavoriteFolder(userName);
        NodeIterator nodeIter = userFavoriteNode.getNodes();
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            if (!this.linkManager.isLink((Item)childNode)) continue;
            Node targetNode = null;
            try {
                targetNode = this.linkManager.getTarget(childNode);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (targetNode == null) continue;
            ret.add(targetNode);
        }
        return ret;
    }

    @Override
    public void removeFavorite(Node node, String userName) throws Exception {
        if (this.linkManager.isLink((Item)node)) {
            return;
        }
        Node userFavoriteNode = this.getUserFavoriteFolder(userName);
        NodeIterator nodeIter = userFavoriteNode.getNodes();
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            if (!this.linkManager.isLink((Item)childNode)) continue;
            Node targetNode = null;
            try {
                targetNode = this.linkManager.getTarget(childNode);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!node.isSame((Item)targetNode)) continue;
            childNode.remove();
            userFavoriteNode.getSession().save();
            return;
        }
    }

    @Override
    public boolean isFavoriter(String userName, Node node) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        LinkManager lnkManager = (LinkManager)container.getComponentInstanceOfType(LinkManager.class);
        if (lnkManager.isLink((Item)node) && lnkManager.isTargetReachable(node)) {
            node = lnkManager.getTarget(node);
        }
        Node userFavoriteNode = null;
        try {
            userFavoriteNode = this.getUserFavoriteFolder(userName);
        }
        catch (PathNotFoundException e) {
            return false;
        }
        NodeIterator nodeIter = userFavoriteNode.getNodes();
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            if (!this.linkManager.isLink((Item)childNode)) continue;
            Node targetNode = null;
            try {
                targetNode = this.linkManager.getTarget(childNode);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!node.isSame((Item)targetNode)) continue;
            return true;
        }
        return false;
    }

    private Node getUserFavoriteFolder(String userName) throws Exception {
        Node userNode = this.nodeHierarchyCreator.getUserNode(this.sessionProviderService.getSessionProvider(null), userName);
        String favoritePath = this.nodeHierarchyCreator.getJcrPath(FAVORITE_ALIAS);
        return userNode.getNode(favoritePath);
    }

    private Node createFavoriteFolder(String userName) throws Exception {
        Node userNode = this.nodeHierarchyCreator.getUserNode(this.sessionProviderService.getSessionProvider(null), userName);
        String userFavoritePath = this.nodeHierarchyCreator.getJcrPath(FAVORITE_ALIAS);
        Node userFavoriteNode = userNode.addNode(userFavoritePath, NT_UNSTRUCTURED);
        userFavoriteNode.addMixin(EXO_PRIVILEGEABLE);
        userFavoriteNode.addMixin(EXO_FAVORITEFOLDER);
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        permissionsMap.put(userName, PermissionType.ALL);
        ((ExtendedNode)userFavoriteNode).setPermissions(permissionsMap);
        return userFavoriteNode;
    }
}

