/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DeletedUserCalculateEventListener
implements EventListener {
    private String path_;
    private String workspace_;
    private String repository_;
    private Log log = ExoLogger.getLogger(DeletedUserCalculateEventListener.class);

    public String getSrcWorkspace() {
        return this.workspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public void onEvent(EventIterator evIter) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
            while (evIter.hasNext()) {
                Event ev = evIter.nextEvent();
                if (ev.getType() != 1 && ev.getType() != 2) continue;
                String userName = ev.getPath().substring(ev.getPath().lastIndexOf("/") + 1);
                forumService.calculateDeletedUser(userName);
                break;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Add event for calculateDeletedUser is fall", (Throwable)e);
        }
    }
}

