/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.space.listeners;

import java.util.List;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizeSpaceHomePageListener
extends SpaceListenerPlugin {
    private static final String SPACE_GROUP_ID_PREFERENCE = "{spaceGroupId}";
    private static final String SPACE_HOME_PAGE_PORTLET_NAME = "SpaceActivityStreamPortlet";
    private static final String SPACE_NEW_HOME_PAGE_TEMPLATE = "custom space";
    private static final String SCV_PORTLEt_NAME = "SingleContentViewer";
    private static Log logger = ExoLogger.getExoLogger(CustomizeSpaceHomePageListener.class);
    private DataStorage dataStorageService = null;
    private ChromatticManager chromatticManager = null;
    private UserPortalConfigService userPortalConfigService = null;
    private ExoProperties welcomeSCVCustomPreferences = null;

    public CustomizeSpaceHomePageListener(DataStorage dataStorageService, ChromatticManager chromatticManager, UserPortalConfigService userPortalConfigService, InitParams params) {
        this.dataStorageService = dataStorageService;
        this.chromatticManager = chromatticManager;
        this.userPortalConfigService = userPortalConfigService;
        this.welcomeSCVCustomPreferences = params.getPropertiesParam("welcomeSCVCustomPreferences").getProperties();
    }

    public void spaceCreated(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        block11: {
            boolean beginRequest;
            block10: {
                String spaceGroupId;
                String spacePrettyName;
                block9: {
                    spacePrettyName = spaceLifeCycleEvent.getSpace().getPrettyName();
                    spaceGroupId = spaceLifeCycleEvent.getSpace().getGroupId();
                    beginRequest = false;
                    try {
                        if (this.chromatticManager.getSynchronization() == null) {
                            this.chromatticManager.beginRequest();
                            beginRequest = true;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block9;
                        logger.debug((Object)("An exception has occurred while trying to begin the chromatticManager request: " + e.getMessage()));
                    }
                }
                try {
                    Page oldSpaceHomePage = null;
                    while (oldSpaceHomePage == null) {
                        oldSpaceHomePage = this.dataStorageService.getPage(PortalConfig.GROUP_TYPE + "::" + spaceGroupId + "::" + SPACE_HOME_PAGE_PORTLET_NAME);
                    }
                    Page customSpaceHomePage = this.userPortalConfigService.createPageTemplate(SPACE_NEW_HOME_PAGE_TEMPLATE, PortalConfig.GROUP_TYPE, spacePrettyName);
                    customSpaceHomePage.setTitle(oldSpaceHomePage.getTitle());
                    customSpaceHomePage.setName(oldSpaceHomePage.getName());
                    customSpaceHomePage.setAccessPermissions(oldSpaceHomePage.getAccessPermissions());
                    customSpaceHomePage.setEditPermission(oldSpaceHomePage.getEditPermission());
                    customSpaceHomePage.setOwnerType(PortalConfig.GROUP_TYPE);
                    customSpaceHomePage.setOwnerId(spaceGroupId);
                    this.editChildrenAccesPermisions(customSpaceHomePage.getChildren(), customSpaceHomePage.getAccessPermissions());
                    this.editSpaceURLPreference(customSpaceHomePage.getChildren(), spacePrettyName);
                    Application<Portlet> welcomeSCVPortlet = this.getPortletApplication(customSpaceHomePage.getChildren(), SCV_PORTLEt_NAME);
                    this.editSCVPreference(welcomeSCVPortlet, spaceGroupId);
                    this.dataStorageService.save(customSpaceHomePage);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.error((Object)("Error while customizing the Space home page for space: " + spaceGroupId), (Throwable)e);
                }
            }
            if (beginRequest) {
                try {
                    this.chromatticManager.endRequest(true);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug((Object)("An exception has occurred while trying to end the chromatticManager request: " + e.getMessage()));
                }
            }
        }
    }

    private void editSCVPreference(Application<Portlet> selectedPortlet, String prefValue) throws Exception {
        Portlet prefs = (Portlet)this.dataStorageService.load(selectedPortlet.getState(), ApplicationType.PORTLET);
        if (prefs == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The portlet prefs == null : portlet application " + selectedPortlet.getId()));
            }
            prefs = new Portlet();
        }
        for (String preferenceName : this.welcomeSCVCustomPreferences.keySet()) {
            String preferenceValue = (String)this.welcomeSCVCustomPreferences.get((Object)preferenceName);
            if (preferenceValue.contains(SPACE_GROUP_ID_PREFERENCE)) {
                preferenceValue = preferenceValue.replace(SPACE_GROUP_ID_PREFERENCE, prefValue);
            }
            prefs.putPreference(new Preference(preferenceName, preferenceValue, false));
        }
    }

    private void editSpaceURLPreference(List<ModelObject> children, String prefValue) throws Exception {
        if ((children == null || children.size() == 0) && logger.isDebugEnabled()) {
            logger.debug((Object)"Can not get a portlet application from children.\nChildren == null or have no items");
        }
        for (ModelObject modelObject : children) {
            if (modelObject instanceof Container) {
                this.editSpaceURLPreference(((Container)modelObject).getChildren(), prefValue);
                continue;
            }
            if (!(modelObject instanceof Application) || !((Application)modelObject).getType().equals(ApplicationType.PORTLET)) continue;
            Application application = (Application)modelObject;
            Portlet portletPreference = (Portlet)this.dataStorageService.load(application.getState(), ApplicationType.PORTLET);
            if (portletPreference == null) {
                portletPreference = new Portlet();
            }
            portletPreference.putPreference(new Preference("SPACE_URL", prefValue, false));
        }
    }

    private Application<Portlet> getPortletApplication(List<ModelObject> children, String portletName) throws Exception {
        if ((children == null || children.size() == 0) && logger.isDebugEnabled()) {
            logger.debug((Object)"Can not get a portlet application from children.\nChildren == null or have no items");
        }
        for (ModelObject modelObject : children) {
            Application application;
            String portletId;
            Application selectedApplication = null;
            if (modelObject instanceof Container) {
                selectedApplication = this.getPortletApplication(((Container)modelObject).getChildren(), portletName);
            } else if (modelObject instanceof Application && ((Application)modelObject).getType().equals(ApplicationType.PORTLET) && (portletId = this.dataStorageService.getId((application = (Application)modelObject).getState())).endsWith("/" + portletName)) {
                selectedApplication = application;
            }
            if (selectedApplication == null) continue;
            return selectedApplication;
        }
        return null;
    }

    private void editChildrenAccesPermisions(List<ModelObject> children, String[] accessPermissions) {
        if (children != null && children.size() > 0) {
            for (ModelObject modelObject : children) {
                if (modelObject instanceof Container) {
                    ((Container)modelObject).setAccessPermissions(accessPermissions);
                    this.editChildrenAccesPermisions(((Container)modelObject).getChildren(), accessPermissions);
                    continue;
                }
                if (!(modelObject instanceof Application) || !((Application)modelObject).getType().equals(ApplicationType.PORTLET)) continue;
                Application application = (Application)modelObject;
                application.setAccessPermissions(accessPermissions);
            }
        }
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent spaceLifeCycleEvent) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }
}

