/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.space.plugin;

import java.io.InputStream;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.deployment.DeploymentDescriptor;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class XMLDeploymentPlugin
extends SpaceListenerPlugin {
    private static final String GROUPS_PATH = "groupsPath";
    private InitParams initParams;
    private ConfigurationManager configurationManager;
    private RepositoryService repositoryService;
    private String groupsPath;
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public XMLDeploymentPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator) {
        this.initParams = initParams;
        this.configurationManager = configurationManager;
        this.repositoryService = repositoryService;
        this.groupsPath = nodeHierarchyCreator.getJcrPath(GROUPS_PATH);
        if (this.groupsPath.lastIndexOf("/") == this.groupsPath.length() - 1) {
            this.groupsPath = this.groupsPath.substring(0, this.groupsPath.lastIndexOf("/"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spaceCreated(SpaceLifeCycleEvent lifeCycleEvent) {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            this.deploy(sessionProvider, lifeCycleEvent.getSpace().getGroupId());
        }
        catch (Exception e) {
            this.log.error((Object)"An unexpected problem occurs while deploying contents", (Throwable)e);
        }
        finally {
            sessionProvider.close();
        }
    }

    public void deploy(SessionProvider sessionProvider, String spaceId) throws Exception {
        Iterator iterator = this.initParams.getObjectParamIterator();
        while (iterator.hasNext()) {
            ObjectParameter objectParameter = (ObjectParameter)iterator.next();
            DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)objectParameter.getObject();
            String sourcePath = deploymentDescriptor.getSourcePath();
            Boolean cleanupPublication = deploymentDescriptor.getCleanupPublication();
            InputStream inputStream = this.configurationManager.getInputStream(sourcePath);
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(deploymentDescriptor.getTarget().getWorkspace(), repository);
            String targetNodePath = deploymentDescriptor.getTarget().getNodePath();
            if (targetNodePath.indexOf("/") == 0) {
                targetNodePath = targetNodePath.replaceFirst("/", "");
            }
            if (targetNodePath.lastIndexOf("/") == targetNodePath.length() - 1) {
                targetNodePath = targetNodePath.substring(0, targetNodePath.lastIndexOf("/"));
            }
            if (!targetNodePath.equals("")) {
                Node spaceRootNode = (Node)session.getItem(this.groupsPath + spaceId);
                Utils.makePath((Node)spaceRootNode, (String)targetNodePath, (String)"nt:unstructured");
            }
            String fullTargetNodePath = this.groupsPath + spaceId + "/" + targetNodePath;
            session.importXML(fullTargetNodePath, inputStream, 0);
            if (cleanupPublication.booleanValue()) {
                QueryManager manager = session.getWorkspace().getQueryManager();
                String statement = "select * from nt:base where jcr:path LIKE '" + fullTargetNodePath + "/%'";
                Query query = manager.createQuery(statement.toString(), "sql");
                NodeIterator iter = query.execute().getNodes();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    if (!node.hasProperty("publication:liveRevision") || !node.hasProperty("publication:currentState")) continue;
                    this.log.info((Object)("\"" + node.getName() + "\" publication lifecycle has been cleaned up"));
                    node.setProperty("publication:liveRevision", "");
                    node.setProperty("publication:currentState", "published");
                }
            }
            session.save();
            session.logout();
            if (!this.log.isInfoEnabled()) continue;
            this.log.info((Object)(deploymentDescriptor.getSourcePath() + " is deployed succesfully into " + fullTargetNodePath));
        }
    }

    public void applicationActivated(SpaceLifeCycleEvent arg0) {
    }

    public void applicationAdded(SpaceLifeCycleEvent arg0) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent arg0) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent arg0) {
    }

    public void grantedLead(SpaceLifeCycleEvent arg0) {
    }

    public void joined(SpaceLifeCycleEvent arg0) {
    }

    public void left(SpaceLifeCycleEvent arg0) {
    }

    public void revokedLead(SpaceLifeCycleEvent arg0) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent arg0) {
    }
}

