/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.ext.impl;

import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class CalendarDataInitialize
extends SpaceListenerPlugin {
    private static final Log log = ExoLogger.getLogger(CalendarDataInitialize.class);
    public static final String ANY = "*.*".intern();
    public static final String SLASH_COLON = "/:".intern();
    public static final String SLASH = "/".intern();
    public static final String COLON = ":".intern();
    public static final String SPLITER = "://".intern();
    public static final String PUBLIC_TYPE = "2".intern();
    public static final String CALENDAR_ID_PREFIX = "CalendarInSpace";
    private final InitParams params;

    public CalendarDataInitialize(InitParams params) {
        this.params = params;
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        String portletName = "";
        try {
            portletName = this.params.getValueParam("portletName").getValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!portletName.equals(event.getSource())) {
            return;
        }
        try {
            Space space = event.getSpace();
            CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
            String calendarId = CALENDAR_ID_PREFIX + space.getId();
            String username = space.getGroupId();
            Calendar calendar = null;
            try {
                calendar = calService.getGroupCalendar(calendarId);
            }
            catch (Exception pfe) {
                // empty catch block
            }
            if (calendar == null) {
                calendar = new Calendar();
                calendar.setId(calendarId);
                calendar.setPublic(false);
                calendar.setGroups(new String[]{space.getGroupId()});
                calendar.setName(space.getDisplayName());
                calendar.setEditPermission(new String[]{space.getGroupId() + SLASH_COLON + ANY});
                calendar.setCalendarOwner(username);
                calService.savePublicCalendar(calendar, true, username);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }
}

