/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.webui.page.UIPageSelector;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.social.webui.space.TreeNode;
import org.exoplatform.social.webui.space.UISpaceNavigationManagement;
import org.exoplatform.social.webui.space.UISpaceNavigationNodeSelector;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputIconSelector;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.IdentifierValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.form.validator.Validator;

public class UIPageNodeForm
extends UIFormTabPane {
    private TreeNode pageNode_;
    private Object selectedParent;
    private UserNavigation contextPageNavigation;
    private static final String SHOW_PUBLICATION_DATE = "showPublicationDate";
    private static final String START_PUBLICATION_DATE = "startPublicationDate";
    private static final String END_PUBLICATION_DATE = "endPublicationDate";
    private static final String VISIBLE = "visible";

    public UIPageNodeForm() throws Exception {
        super("UIPageNodeForm");
        UIFormInputSet uiSettingSet = new UIFormInputSet("PageNodeSetting");
        UIFormCheckBoxInput uiDateInputCheck = new UIFormCheckBoxInput(SHOW_PUBLICATION_DATE, null, (Object)false);
        UIFormCheckBoxInput uiVisibleCheck = new UIFormCheckBoxInput(VISIBLE, null, (Object)true);
        uiDateInputCheck.setOnChange("SwitchPublicationDate");
        uiVisibleCheck.setOnChange("SwitchVisible");
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormStringInput("URI", "URI", null).setEditable(false)).addUIFormInput((UIFormInput)new UIFormStringInput("name", "name", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(IdentifierValidator.class, new Object[0])).addUIFormInput((UIFormInput)new UIFormStringInput("label", "label", null).addValidator(StringLengthValidator.class, new Object[]{3, 120})).addUIFormInput((UIFormInput)uiVisibleCheck.setChecked(true)).addUIFormInput((UIFormInput)uiDateInputCheck).addUIFormInput((UIFormInput)new UIFormDateTimeInput(START_PUBLICATION_DATE, null, null).addValidator(DateTimeValidator.class, new Object[0])).addUIFormInput((UIFormInput)new UIFormDateTimeInput(END_PUBLICATION_DATE, null, null).addValidator(DateTimeValidator.class, new Object[0]));
        this.addUIFormInput(uiSettingSet);
        this.setSelectedTab(uiSettingSet.getId());
        UIPageSelector uiPageSelector = (UIPageSelector)this.createUIComponent(UIPageSelector.class, null, null);
        uiPageSelector.configure("UIPageSelector", "pageRef");
        this.addUIFormInput((UIFormInput)uiPageSelector);
        UIFormInputIconSelector uiIconSelector = new UIFormInputIconSelector("Icon", "icon");
        this.addUIFormInput((UIFormInput)uiIconSelector);
        this.setActions(new String[]{"Save", "Back"});
    }

    public TreeNode getPageNode() {
        return this.pageNode_;
    }

    public void setValues(TreeNode pageNode) throws Exception {
        this.pageNode_ = pageNode;
        if (pageNode == null) {
            this.getUIStringInput("name").setEditable(true);
            ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon("DefaultPageIcon");
            this.setShowPublicationDate(false);
            return;
        }
        this.getUIStringInput("name").setEditable(false);
        this.invokeGetBindingBean(this.pageNode_);
    }

    public void invokeGetBindingBean(Object bean) throws Exception {
        super.invokeGetBindingBean(bean);
        TreeNode pageNode = (TreeNode)bean;
        String icon = pageNode.getIcon();
        if (icon == null || icon.length() < 0) {
            icon = "DefaultPageIcon";
        }
        ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(icon);
        this.getUIStringInput("label").setValue((Object)pageNode.getLabel());
        if (pageNode.getVisibility() == Visibility.SYSTEM) {
            UIFormInputSet uiSettingSet = (UIFormInputSet)this.getChildById("PageNodeSetting");
            uiSettingSet.removeChildById(VISIBLE);
            uiSettingSet.removeChildById(SHOW_PUBLICATION_DATE);
            uiSettingSet.removeChildById(START_PUBLICATION_DATE);
            uiSettingSet.removeChildById(END_PUBLICATION_DATE);
        } else {
            Visibility visibility = pageNode.getVisibility();
            boolean isVisible = visibility == null || EnumSet.of(Visibility.DISPLAYED, Visibility.TEMPORAL).contains(visibility);
            this.getUIFormCheckBoxInput(VISIBLE).setChecked(isVisible);
            this.getUIFormCheckBoxInput(SHOW_PUBLICATION_DATE).setChecked(Visibility.TEMPORAL.equals((Object)visibility));
            this.setShowCheckPublicationDate(isVisible);
            Calendar cal = Calendar.getInstance();
            if (pageNode.getStartPublicationTime() != -1L) {
                cal.setTime(new Date(pageNode.getStartPublicationTime()));
                this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setCalendar(cal);
            } else {
                this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setValue(null);
            }
            if (pageNode.getEndPublicationTime() != -1L) {
                cal.setTime(new Date(pageNode.getEndPublicationTime()));
                this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setCalendar(cal);
            } else {
                this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setValue(null);
            }
        }
    }

    public void invokeSetBindingBean(Object bean) throws Exception {
        super.invokeSetBindingBean(bean);
        TreeNode node = (TreeNode)bean;
        if (node.getVisibility() != Visibility.SYSTEM) {
            UIFormCheckBoxInput showPubDate;
            Visibility visibility = this.getUIFormCheckBoxInput(VISIBLE).isChecked() ? ((showPubDate = this.getUIFormCheckBoxInput(SHOW_PUBLICATION_DATE)).isChecked() ? Visibility.TEMPORAL : Visibility.DISPLAYED) : Visibility.HIDDEN;
            node.setVisibility(visibility);
            Calendar cal = this.getUIFormDateTimeInput(START_PUBLICATION_DATE).getCalendar();
            Date date = cal != null ? cal.getTime() : null;
            node.setStartPublicationTime(date == null ? -1L : date.getTime());
            cal = this.getUIFormDateTimeInput(END_PUBLICATION_DATE).getCalendar();
            date = cal != null ? cal.getTime() : null;
            node.setEndPublicationTime(date == null ? -1L : date.getTime());
        }
    }

    public void setShowCheckPublicationDate(boolean show) {
        this.getUIFormCheckBoxInput(VISIBLE).setChecked(show);
        UIFormCheckBoxInput uiForm = this.getUIFormCheckBoxInput(SHOW_PUBLICATION_DATE);
        uiForm.setRendered(show);
        this.setShowPublicationDate(show && uiForm.isChecked());
    }

    public void setShowPublicationDate(boolean show) {
        this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setRendered(show);
        this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setRendered(show);
    }

    public Object getSelectedParent() {
        return this.selectedParent;
    }

    public void setSelectedParent(Object obj) {
        this.selectedParent = obj;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
        UIPageSelector uiPageSelector = (UIPageSelector)this.getChild(UIPageSelector.class);
        if (uiPageSelector == null) {
            return;
        }
        UIPopupWindow uiPopupWindowPage = (UIPopupWindow)uiPageSelector.getChild(UIPopupWindow.class);
        if (uiPopupWindowPage == null) {
            return;
        }
        uiPopupWindowPage.processRender(context);
    }

    public String getOwner() {
        return this.contextPageNavigation.getKey().getName();
    }

    public String getOwnerType() {
        return this.contextPageNavigation.getKey().getTypeName();
    }

    public void setContextPageNavigation(UserNavigation _contextPageNav) {
        this.contextPageNavigation = _contextPageNav;
    }

    public UserNavigation getContextPageNavigation() {
        return this.contextPageNavigation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreatePageActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            DataStorage dataService;
            Page existPage;
            UIPageNodeForm uiForm = (UIPageNodeForm)((Object)event.getSource());
            UIPageSelector pageSelector = (UIPageSelector)uiForm.findFirstComponentOfType(UIPageSelector.class);
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UIFormInputSet uiInputSet = (UIFormInputSet)pageSelector.getChild(UIFormInputSet.class);
            List children = uiInputSet.getChildren();
            for (UIComponent uiChild : children) {
                List validators;
                UIFormInputBase uiInput;
                if (!(uiChild instanceof UIFormInputBase) || !(uiInput = (UIFormInputBase)uiChild).isValid() || (validators = uiInput.getValidators()) == null) continue;
                try {
                    for (Validator validator : validators) {
                        validator.validate((UIFormInput)uiInput);
                    }
                }
                catch (MessageException ex) {
                    uiPortalApp.addMessage(ex.getDetailMessage());
                    return;
                }
                catch (Exception ex) {
                    uiPortalApp.addMessage(new ApplicationMessage(ex.getMessage(), null));
                    return;
                }
            }
            UserACL userACL = (UserACL)uiForm.getApplicationComponent(UserACL.class);
            String ownerId = uiForm.getOwner();
            String[] accessPermission = new String[]{"*:" + ownerId};
            String editPermission = userACL.getMakableMT() + ":" + ownerId;
            if (PortalConfig.PORTAL_TYPE.equals(uiForm.getOwnerType())) {
                UIPortal uiPortal = Util.getUIPortal();
                accessPermission = uiPortal.getAccessPermissions();
                editPermission = uiPortal.getEditPermission();
            }
            UIFormStringInput uiPageName = (UIFormStringInput)uiInputSet.getChildById("pageName");
            UIFormStringInput uiPageTitle = (UIFormStringInput)uiInputSet.getChildById("pageTitle");
            Page page = new Page();
            page.setOwnerType(uiForm.getOwnerType());
            page.setOwnerId(ownerId);
            page.setName((String)uiPageName.getValue());
            String title = (String)uiPageTitle.getValue();
            if (title == null || title.trim().length() < 1) {
                title = page.getName();
            }
            page.setTitle(title);
            page.setShowMaxWindow(Boolean.valueOf(false));
            page.setAccessPermissions(accessPermission);
            page.setEditPermission(editPermission);
            userACL.hasPermission(page);
            page.setModifiable(true);
            if (page.getChildren() == null) {
                page.setChildren(new ArrayList());
            }
            if ((existPage = (dataService = (DataStorage)uiForm.getApplicationComponent(DataStorage.class)).getPage(page.getPageId())) != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageForm.msg.sameName", null));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            pageSelector.setPage(page);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClearPageActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiForm = (UIPageNodeForm)((Object)event.getSource());
            UIPageSelector pageSelector = (UIPageSelector)uiForm.findFirstComponentOfType(UIPageSelector.class);
            pageSelector.setPage(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pageSelector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SwitchVisibleActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiForm = (UIPageNodeForm)((Object)event.getSource());
            boolean isCheck = uiForm.getUIFormCheckBoxInput(UIPageNodeForm.VISIBLE).isChecked();
            uiForm.setShowCheckPublicationDate(isCheck);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SwitchPublicationDateActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiForm = (UIPageNodeForm)((Object)event.getSource());
            boolean isCheck = uiForm.getUIFormCheckBoxInput(UIPageNodeForm.SHOW_PUBLICATION_DATE).isChecked();
            uiForm.setShowPublicationDate(isCheck);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageSelector pageSelector;
            WebuiRequestContext ctx = event.getRequestContext();
            UIPageNodeForm uiPageNodeForm = (UIPageNodeForm)((Object)event.getSource());
            UIApplication uiPortalApp = ctx.getUIApplication();
            TreeNode pageNode = uiPageNodeForm.getPageNode();
            if (pageNode == null || pageNode.getVisibility() != Visibility.SYSTEM && uiPageNodeForm.getUIFormCheckBoxInput(UIPageNodeForm.SHOW_PUBLICATION_DATE).isChecked()) {
                Date endDate;
                Calendar currentCalendar = Calendar.getInstance();
                currentCalendar.set(currentCalendar.get(1), currentCalendar.get(2), currentCalendar.get(5), 0, 0, 0);
                Date currentDate = currentCalendar.getTime();
                Calendar startCalendar = uiPageNodeForm.getUIFormDateTimeInput(UIPageNodeForm.START_PUBLICATION_DATE).getCalendar();
                Date startDate = startCalendar != null ? startCalendar.getTime() : currentDate;
                Calendar endCalendar = uiPageNodeForm.getUIFormDateTimeInput(UIPageNodeForm.END_PUBLICATION_DATE).getCalendar();
                Date date = endDate = endCalendar != null ? endCalendar.getTime() : null;
                if (currentDate.after(startDate)) {
                    Object[] args = new Object[]{};
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.currentDateBeforeStartDate", args, 1));
                    return;
                }
                if (endCalendar != null && startCalendar != null && startDate.after(endDate)) {
                    Object[] args = new Object[]{};
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.startDateBeforeEndDate", args, 1));
                    return;
                }
                if (endCalendar != null && currentDate.after(endDate)) {
                    Object[] args = new Object[]{};
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.currentDateBeforeEndDate", args, 1));
                    return;
                }
            }
            UIFormStringInput nameInput = uiPageNodeForm.getUIStringInput("name");
            String nodeName = (String)nameInput.getValue();
            TreeNode selectedParent = (TreeNode)uiPageNodeForm.getSelectedParent();
            if (pageNode == null && selectedParent.getChild(nodeName) != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.SameName", null));
                return;
            }
            if (pageNode == null) {
                pageNode = selectedParent.addChild(nodeName);
            }
            if ((pageSelector = (UIPageSelector)uiPageNodeForm.getChild(UIPageSelector.class)).getPage() == null) {
                pageSelector.setValue(null);
            } else {
                Page page = pageSelector.getPage();
                DataStorage storage = (DataStorage)uiPageNodeForm.getApplicationComponent(DataStorage.class);
                if (storage.getPage(page.getPageId()) == null) {
                    storage.create(page);
                    pageSelector.setValue(page.getPageId());
                }
            }
            UIFormInputIconSelector uiIconSelector = (UIFormInputIconSelector)uiPageNodeForm.getChild(UIFormInputIconSelector.class);
            if (uiIconSelector.getSelectedIcon().equals("DefaultPageIcon")) {
                pageNode.setIcon("DefaultPageIcon");
            } else {
                pageNode.setIcon(uiIconSelector.getSelectedIcon());
            }
            if (pageNode.getLabel() == null) {
                pageNode.setLabel(pageNode.getName());
            }
            uiPageNodeForm.invokeSetBindingBean(pageNode);
            UIPopupWindow uiPopup = (UIPopupWindow)uiPageNodeForm.getParent();
            UISpaceNavigationManagement uiSpaceNav = (UISpaceNavigationManagement)uiPopup.getParent();
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)uiSpaceNav.getChild(UISpaceNavigationNodeSelector.class);
            uiNodeSelector.save();
            uiPageNodeForm.createEvent("Back", Event.Phase.DECODE, ctx).broadcast();
        }
    }
}

