/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.jbosscache;

import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedAction;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.IndexerCacheLoader;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.LocalIndexCacheLoader;
import org.exoplatform.services.jcr.jbosscache.ExoJBossCacheFactory;
import org.exoplatform.services.jcr.jbosscache.PrivilegedJBossCacheHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.jmx.JmxRegistrationManager;
import org.jboss.cache.loader.CacheLoader;

public class LocalIndexChangesFilter
extends IndexerChangesFilter {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.JBossCacheIndexChangesFilter");
    public static final String PARAM_JBOSSCACHE_CONFIGURATION = "jbosscache-configuration";
    public static final String PARAM_JBOSSCACHE_PUSHSTATE = "jbosscache-sscl-push.state.enabled";
    public static final String PARAM_JBOSSCACHE_PUSHSTATE_TIMEOUT = "jbosscache-sscl-push.state.timeout";
    public static final String PARAM_JBOSSCACHE_SHAREABLE = "jbosscache-shareable";
    public static final Boolean PARAM_JBOSSCACHE_SHAREABLE_DEFAULT = Boolean.FALSE;
    private final Cache<Serializable, Object> cache;
    private final Fqn<String> rootFqn;
    private final JmxRegistrationManager jmxManager;
    public static final String LISTWRAPPER = "$lists".intern();

    public LocalIndexChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm) throws IOException, RepositoryException, RepositoryConfigurationException {
        super(searchManager, parentSearchManager, config, indexingTree, parentIndexingTree, handler, parentHandler, cfm);
        ExoJBossCacheFactory factory = new ExoJBossCacheFactory(cfm);
        Cache initCache = factory.createCache(config);
        IndexerCacheLoader indexerCacheLoader = new LocalIndexCacheLoader();
        CacheLoaderConfig.IndividualCacheLoaderConfig individualCacheLoaderConfig = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        individualCacheLoaderConfig.setCacheLoader((CacheLoader)indexerCacheLoader);
        individualCacheLoaderConfig.setFetchPersistentState(false);
        individualCacheLoaderConfig.setAsync(false);
        individualCacheLoaderConfig.setIgnoreModifications(false);
        individualCacheLoaderConfig.setPurgeOnStartup(false);
        CacheLoaderConfig cacheLoaderConfig = new CacheLoaderConfig();
        cacheLoaderConfig.setShared(false);
        cacheLoaderConfig.setPassivation(false);
        cacheLoaderConfig.addIndividualCacheLoaderConfig(individualCacheLoaderConfig);
        initCache.getConfiguration().setCacheLoaderConfig(cacheLoaderConfig);
        this.rootFqn = Fqn.fromElements((Object[])new String[]{searchManager.getWsId()});
        this.cache = ExoJBossCacheFactory.getUniqueInstance(ExoJBossCacheFactory.CacheType.INDEX_CACHE, this.rootFqn, initCache, config.getParameterBoolean(PARAM_JBOSSCACHE_SHAREABLE, PARAM_JBOSSCACHE_SHAREABLE_DEFAULT));
        PrivilegedJBossCacheHelper.create(this.cache);
        PrivilegedJBossCacheHelper.start(this.cache);
        this.jmxManager = ExoJBossCacheFactory.getJmxRegistrationManager(searchManager.getExoContainerContext(), this.cache, ExoJBossCacheFactory.CacheType.INDEX_CACHE);
        if (this.jmxManager != null) {
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    LocalIndexChangesFilter.this.jmxManager.registerAllMBeans();
                    return null;
                }
            });
        }
        indexerCacheLoader = (IndexerCacheLoader)((CacheSPI)this.cache).getCacheLoaderManager().getCacheLoader();
        indexerCacheLoader.register(searchManager, parentSearchManager, handler, parentHandler);
        IndexerIoModeHandler modeHandler = indexerCacheLoader.getModeHandler();
        handler.setIndexerIoModeHandler(modeHandler);
        parentHandler.setIndexerIoModeHandler(modeHandler);
        if (!parentHandler.isInitialized()) {
            parentHandler.init();
        }
        if (!handler.isInitialized()) {
            handler.init();
        }
    }

    protected Log getLogger() {
        return this.log;
    }

    protected void doUpdateIndex(ChangesFilterListsWrapper changes) {
        String id = IdGenerator.generate();
        this.cache.put(Fqn.fromRelativeElements(this.rootFqn, (Object[])new String[]{id}), (Object)LISTWRAPPER, (Object)changes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.jmxManager != null) {
                SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        LocalIndexChangesFilter.this.jmxManager.unregisterAllMBeans();
                        return null;
                    }
                });
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

