/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageManager;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SetDefaultActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIMultiLanguageForm
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIMultiLanguageForm");

    public UIMultiLanguageForm() throws Exception {
        ArrayList languages = new ArrayList();
        this.addUIFormInput((UIFormInput)new UIFormSelectBox("languages", "languages", languages));
    }

    public void doSelect(Node currentNode) throws Exception {
        ArrayList<SelectItemOption> languages = new ArrayList<SelectItemOption>();
        if (!currentNode.hasProperty("exo:language")) {
            currentNode.addMixin("mix:i18n");
            currentNode.save();
        }
        String defaultLang = currentNode.getProperty("exo:language").getString();
        UIMultiLanguageManager uiMultiLanguageManager = (UIMultiLanguageManager)this.getParent();
        List<SelectItemOption<String>> listLang = uiMultiLanguageManager.languages();
        String defaultLangName = "";
        for (SelectItemOption<String> item : listLang) {
            if (!((String)item.getValue()).trim().equals(defaultLang)) continue;
            defaultLangName = item.getLabel();
            break;
        }
        languages.add(new SelectItemOption(defaultLangName + "(default)", (Object)defaultLang));
        if (currentNode.hasNode("languages")) {
            Node languageNode = currentNode.getNode("languages");
            NodeIterator iter = languageNode.getNodes();
            while (iter.hasNext()) {
                Node lang = iter.nextNode();
                if (lang.getName().equals(defaultLang)) continue;
                String label = lang.getName();
                for (SelectItemOption<String> item : listLang) {
                    if (!((String)item.getValue()).trim().equals(lang.getName())) continue;
                    label = item.getLabel();
                    break;
                }
                languages.add(new SelectItemOption(label, (Object)lang.getName()));
            }
        }
        this.getUIFormSelectBox("languages").setOptions(languages);
        this.getUIFormSelectBox("languages").setValue(defaultLang);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewActionListener
    extends EventListener<UIMultiLanguageForm> {
        public void execute(Event<UIMultiLanguageForm> event) throws Exception {
            UIMultiLanguageForm uiForm = (UIMultiLanguageForm)((Object)event.getSource());
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)uiJCRExplorer.findFirstComponentOfType(UIDocumentInfo.class);
            String selectedLanguage = (String)uiForm.getUIFormSelectBox("languages").getValue();
            uiDocumentInfo.setLanguage(selectedLanguage);
            uiJCRExplorer.setIsHidePopup(false);
            uiJCRExplorer.updateAjax(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetDefaultActionListener
    extends EventListener<UIMultiLanguageForm> {
        public void execute(Event<UIMultiLanguageForm> event) throws Exception {
            UIMultiLanguageForm uiForm = (UIMultiLanguageForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            Node node = uiExplorer.getCurrentNode();
            uiExplorer.addLockToken(node);
            if (!PermissionUtil.canAddNode((Node)uiExplorer.getCurrentNode())) {
                throw new MessageException(new ApplicationMessage("UIMultiLanguageForm.msg.access-denied", null, 1));
            }
            MultiLanguageService multiLanguageService = (MultiLanguageService)uiForm.getApplicationComponent(MultiLanguageService.class);
            String selectedLanguage = (String)uiForm.getUIFormSelectBox("languages").getValue();
            try {
                multiLanguageService.setDefault(uiExplorer.getCurrentNode(), selectedLanguage, uiExplorer.getRepositoryName());
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIMultiLanguageForm.msg.access-denied", null, 1));
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            uiExplorer.setLanguage(selectedLanguage);
            uiExplorer.setIsHidePopup(false);
            uiExplorer.updateAjax(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIMultiLanguageForm> {
        public void execute(Event<UIMultiLanguageForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIMultiLanguageForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }
}

