/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.WorkspaceRestoreException;
import org.exoplatform.services.jcr.ext.backup.impl.JobWorkspaceRestore;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.JCRRestore;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JobExistingWorkspaceSameConfigRestore
extends JobWorkspaceRestore {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ext.JobExistingWorkspaceSameConfigRestore");

    public JobExistingWorkspaceSameConfigRestore(RepositoryService repositoryService, BackupManager backupManager, String repositoryName, BackupChainLog log, WorkspaceEntry wEntry) {
        super(repositoryService, backupManager, repositoryName, log, wEntry);
    }

    /*
     * Loose catch block
     */
    protected void restore() throws WorkspaceRestoreException {
        block23: {
            ArrayList<DataRestore> dataRestorer = new ArrayList<DataRestore>();
            this.repositoryService.getRepository(this.repositoryName).getWorkspaceContainer(this.wEntry.getName()).setState(3);
            List backupable = this.repositoryService.getRepository(this.repositoryName).getWorkspaceContainer(this.wEntry.getName()).getComponentInstancesOfType(Backupable.class);
            File storageDir = this.backupChainLog.getBackupConfig().getBackupDir();
            for (Backupable component : backupable) {
                File fullBackupDir = JCRRestore.getFullBackupFile((File)storageDir);
                dataRestorer.add(component.getDataRestorer(fullBackupDir));
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.clean();
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.restore();
            }
            for (DataRestore restorer : dataRestorer) {
                restorer.commit();
            }
            this.repositoryService.getRepository(this.repositoryName).getWorkspaceContainer(this.wEntry.getName()).setState(1);
            WorkspacePersistentDataManager dataManager = (WorkspacePersistentDataManager)this.repositoryService.getRepository(this.repositoryName).getWorkspaceContainer(this.wEntry.getName()).getComponent(WorkspacePersistentDataManager.class);
            FileCleanerHolder fileCleanHolder = (FileCleanerHolder)this.repositoryService.getRepository(this.repositoryName).getWorkspaceContainer(this.wEntry.getName()).getComponent(FileCleanerHolder.class);
            JCRRestore restorer = new JCRRestore((DataManager)dataManager, fileCleanHolder.getFileCleaner());
            for (File incrBackupFile : JCRRestore.getIncrementalFiles((File)storageDir)) {
                restorer.incrementalRestore(incrBackupFile);
            }
            Object var10_13 = null;
            for (DataRestore restorer2 : dataRestorer) {
                try {
                    restorer2.close();
                }
                catch (BackupException e) {
                    log.error((Object)"Can't close restorer", e);
                }
            }
            try {
                this.repositoryService.getRepository(this.repositoryName).getWorkspaceContainer(this.wEntry.getName()).setState(1);
            }
            catch (RepositoryException e) {
                log.error((Object)"Can't resume component", e);
            }
            catch (RepositoryConfigurationException e) {
                log.error((Object)"Can't resume component", e);
            }
            break block23;
            {
                catch (Throwable t) {
                    for (DataRestore restorer3 : dataRestorer) {
                        try {
                            restorer3.rollback();
                        }
                        catch (BackupException e) {
                            log.error((Object)"Can't rollback changes", e);
                        }
                    }
                    throw new WorkspaceRestoreException("Workspace " + this.wEntry.getName() + " was not restored", t);
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                for (DataRestore restorer2 : dataRestorer) {
                    try {
                        restorer2.close();
                    }
                    catch (BackupException e) {
                        log.error((Object)"Can't close restorer", e);
                    }
                }
                try {
                    this.repositoryService.getRepository(this.repositoryName).getWorkspaceContainer(this.wEntry.getName()).setState(1);
                }
                catch (RepositoryException e) {
                    log.error((Object)"Can't resume component", e);
                }
                catch (RepositoryConfigurationException e) {
                    log.error((Object)"Can't resume component", e);
                }
                throw throwable;
            }
        }
    }
}

