/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.SecurityManager;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.IdentityRest;
import org.exoplatform.social.service.rest.api.models.ProfileRest;

@Path(value="api/social/v1-alpha2/{portalContainerName}/identity/")
public class IdentityResources
implements ResourceContainer {
    private static final String[] SUPPORTED_FORMAT = new String[]{"json"};
    private IdentityManager identityManager;

    @GET
    @Path(value="{identityId}.{format}")
    public Response getIdentityById(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="format") String format) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        try {
            this.identityManager = Util.getIdentityManager(portalContainerName);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (identityId == null || identityId.equals("")) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (SecurityManager.getAuthenticatedUserIdentity() == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        try {
            Identity identity = this.identityManager.getIdentity(identityId, true);
            IdentityRest resultIdentity = new IdentityRest(identity);
            String restBaseURI = uriInfo.getBaseUri().toString();
            String restPathURI = uriInfo.getBaseUri().getPath();
            this.buildAbsoluteAvatarURL(restBaseURI.substring(0, restBaseURI.length() - restPathURI.length()), resultIdentity);
            return Util.getResponse(resultIdentity, uriInfo, mediaType, Response.Status.OK);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="{providerId}/{remoteId}.{format}")
    public Response getIdentityProviderIdAndRemoteId(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="providerId") String providerId, @PathParam(value="remoteId") String remoteId, @PathParam(value="format") String format) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        try {
            this.identityManager = Util.getIdentityManager(portalContainerName);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (providerId == null || providerId.equals("") || remoteId == null || remoteId.equals("")) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (SecurityManager.getAuthenticatedUserIdentity() == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        try {
            Identity identity = this.identityManager.getOrCreateIdentity(providerId, remoteId, true);
            IdentityRest resultIdentity = new IdentityRest(identity);
            String restBaseURI = uriInfo.getBaseUri().toString();
            String restPathURI = uriInfo.getBaseUri().getPath();
            this.buildAbsoluteAvatarURL(restBaseURI.substring(0, restBaseURI.length() - restPathURI.length()), resultIdentity);
            return Util.getResponse(resultIdentity, uriInfo, mediaType, Response.Status.OK);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }

    private void buildAbsoluteAvatarURL(String baseURL, IdentityRest resultIdentity) {
        if (resultIdentity.containsKey("profile") && resultIdentity.containsKey("providerId")) {
            ProfileRest resultProfile = (ProfileRest)resultIdentity.get("profile");
            if (!resultProfile.containsKey("avatarUrl")) {
                if (resultIdentity.get("providerId").equals("space")) {
                    resultProfile.put("avatarUrl", baseURL + "/social-resources/skin/ShareImages/SpaceImages/SpaceLogoDefault_61x61.gif");
                } else {
                    resultProfile.put("avatarUrl", baseURL + "/social-resources/skin/ShareImages/Avatar.gif");
                }
            } else if (!((String)resultProfile.get("avatarUrl")).startsWith("http://") && !((String)resultProfile.get("avatarUrl")).startsWith("https://")) {
                resultProfile.put("avatarUrl", baseURL + (String)resultProfile.get("avatarUrl"));
            }
        }
    }
}

