/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api_v1alpha1;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api_v1alpha1.models.Activity;
import org.exoplatform.social.service.rest.api_v1alpha1.models.ActivityList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="api/social/v1-alpha1/{portalContainerName}/activity_stream")
public class ActivityStreamResources
implements ResourceContainer {
    private static final String[] SUPPORTED_FORMAT = new String[]{"json"};

    @GET
    @Path(value="{identityId}/user/default.{format}")
    public Response getActivityStreamUserDefault(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        RealtimeListAccess listAccess = activityManager.getActivitiesWithListAccess(identity);
        List activities = listAccess.loadAsList(0, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{identityId}/user/newer/{activityBaseId}.{format}")
    public Response getActivityStreamUserNewer(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="activityBaseId") String activityBaseId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        ExoSocialActivity activity = activityManager.getActivity(activityBaseId);
        RealtimeListAccess listAccess = activityManager.getActivitiesWithListAccess(identity);
        List activities = listAccess.loadNewer((Object)activity, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{identityId}/user/older/{activityBaseId}.{format}")
    public Response getActivityStreamUserOlder(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="activityBaseId") String activityBaseId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        ExoSocialActivity activity = activityManager.getActivity(activityBaseId);
        RealtimeListAccess listAccess = activityManager.getActivitiesWithListAccess(identity);
        List activities = listAccess.loadOlder((Object)activity, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{identityId}/feed/default.{format}")
    public Response getActivityStreamFeedDefault(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        RealtimeListAccess listAccess = activityManager.getActivityFeedWithListAccess(identity);
        List activities = listAccess.loadAsList(0, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{identityId}/feed/newer/{activityBaseId}.{format}")
    public Response getActivityStreamFeedNewer(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="activityBaseId") String activityBaseId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        ExoSocialActivity activity = activityManager.getActivity(activityBaseId);
        RealtimeListAccess listAccess = activityManager.getActivityFeedWithListAccess(identity);
        List activities = listAccess.loadNewer((Object)activity, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{identityId}/feed/older/{activityBaseId}.{format}")
    public Response getActivityStreamFeedOlder(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="activityBaseId") String activityBaseId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        ExoSocialActivity activity = activityManager.getActivity(activityBaseId);
        RealtimeListAccess listAccess = activityManager.getActivityFeedWithListAccess(identity);
        List activities = listAccess.loadOlder((Object)activity, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{identityId}/connections/default.{format}")
    public Response getActivityStreamConnectionsDefault(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        RealtimeListAccess listAccess = activityManager.getActivitiesOfConnectionsWithListAccess(identity);
        List activities = listAccess.loadAsList(0, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{identityId}/connections/newer/{activityBaseId}.{format}")
    public Response getActivityStreamConnectionsNewer(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="activityBaseId") String activityBaseId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        ExoSocialActivity activity = activityManager.getActivity(activityBaseId);
        RealtimeListAccess listAccess = activityManager.getActivitiesOfConnectionsWithListAccess(identity);
        List activities = listAccess.loadNewer((Object)activity, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{identityId}/connections/older/{activityBaseId}.{format}")
    public Response getActivityStreamConnectionsOlder(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="activityBaseId") String activityBaseId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        ExoSocialActivity activity = activityManager.getActivity(activityBaseId);
        RealtimeListAccess listAccess = activityManager.getActivitiesOfConnectionsWithListAccess(identity);
        List activities = listAccess.loadOlder((Object)activity, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{identityId}/spaces/default.{format}")
    public Response getActivityStreamSpacesDefault(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        RealtimeListAccess listAccess = activityManager.getActivitiesOfUserSpacesWithListAccess(identity);
        List activities = listAccess.loadAsList(0, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{identityId}/spaces/newer/{activityBaseId}.{format}")
    public Response getActivityStreamSpacesNewer(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="activityBaseId") String activityBaseId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        ExoSocialActivity activity = activityManager.getActivity(activityBaseId);
        RealtimeListAccess listAccess = activityManager.getActivitiesOfUserSpacesWithListAccess(identity);
        List activities = listAccess.loadNewer((Object)activity, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{identityId}/spaces/older/{activityBaseId}.{format}")
    public Response getActivityStreamSpacesOlder(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="activityBaseId") String activityBaseId, @PathParam(value="format") String format, @QueryParam(value="limit") String limit) {
        MediaType mediaType = Util.getMediaType(format, SUPPORTED_FORMAT);
        if (!this.authenticated()) {
            return Util.getResponse(null, uriInfo, mediaType, Response.Status.UNAUTHORIZED);
        }
        ActivityManager activityManager = this.getActivityManager(portalContainerName);
        IdentityManager identityManager = this.getIdentityManager(portalContainerName);
        Identity identity = identityManager.getIdentity(identityId, false);
        ExoSocialActivity activity = activityManager.getActivity(activityBaseId);
        RealtimeListAccess listAccess = activityManager.getActivitiesOfUserSpacesWithListAccess(identity);
        List activities = listAccess.loadOlder((Object)activity, this.secureLimit(limit));
        return Util.getResponse(this.build(activities), uriInfo, mediaType, Response.Status.OK);
    }

    private int secureLimit(String limit) {
        if (limit == null) {
            return 100;
        }
        int intLimit = Integer.parseInt(limit);
        if (intLimit > 100) {
            return 100;
        }
        return intLimit;
    }

    private ActivityManager getActivityManager(String name) {
        return (ActivityManager)this.getPortalContainer(name).getComponentInstanceOfType(ActivityManager.class);
    }

    private IdentityManager getIdentityManager(String name) {
        return (IdentityManager)this.getPortalContainer(name).getComponentInstanceOfType(IdentityManager.class);
    }

    private PortalContainer getPortalContainer(String name) {
        return (PortalContainer)ExoContainerContext.getContainerByName((String)name);
    }

    private ActivityList build(List<ExoSocialActivity> activities) {
        ActivityList activityList = new ActivityList();
        for (ExoSocialActivity current : activities) {
            activityList.addActivity(new Activity(current));
        }
        return activityList;
    }

    private boolean authenticated() {
        return ConversationState.getCurrent() != null;
    }
}

