/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class GUIHelper {
    public static final ImageIcon DEFAULT_ICON_FRAME_16 = GUIHelper.loadIcon("install4j_icon_16.png");
    public static final ImageIcon DEFAULT_ICON_FRAME_32 = GUIHelper.loadIcon("install4j_icon_32.png");
    private static final String ICONS_DIRECTORY = "icons/";
    private static boolean lafSet = false;
    private static String browserExecutable;
    public static final Icon ICON_FOLDER_OPEN;
    public static final Icon ICON_FOLDER_CLOSED;
    static /* synthetic */ Class class$com$install4j$runtime$installer$frontend$GUIHelper;
    static /* synthetic */ Class class$java$lang$String;

    public static void setLanguage(String string) {
        Object object;
        if (string != null) {
            try {
                Locale.setDefault(new Locale(string, ""));
            }
            catch (Exception exception) {}
        } else {
            string = Locale.getDefault().getLanguage();
        }
        GUIHelper.setSystemLaF();
        if (string.equals("ja") || string.equals("ko") || string.startsWith("zh")) {
            object = UIManager.getFont("Label.font");
            UIManager.put("OptionPane.font", object);
            UIManager.put("OptionPane.messageFont", object);
            UIManager.put("OptionPane.buttonFont", object);
        }
        object = System.getProperty("install4j.font.offset");
        String string2 = System.getProperty("java.version");
        if (object != null) {
            GUIHelper.adjustFontSize(Integer.parseInt((String)object));
        } else if (string.equals("zh_TW") && (string2.startsWith("1.3") || string2.startsWith("1.4"))) {
            GUIHelper.adjustFontSize(2);
        }
    }

    private static boolean isSystemLafFailed() {
        if (Util.isWindows9X()) {
            Object object = WinRegistry.getValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf");
            if (object != null && object instanceof Integer && (Integer)object == 1) {
                WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf", new Integer(0));
                return true;
            }
            WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf", new Integer(1));
            return false;
        }
        return false;
    }

    private static void setSystemLafSucceded() {
        if (Util.isWindows9X()) {
            WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf", new Integer(0));
        }
    }

    public static void setSystemLaF() {
        if (!lafSet) {
            lafSet = true;
            if (!(GUIHelper.isSystemLafFailed() || Boolean.getBoolean("install4j.nolaf") || InstallerUtil.isConsole() || InstallerUtil.isUnattended())) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    if (GUIHelper.isGtkLaF() && GUIHelper.isUpToJava15()) {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    }
                    GUIHelper.setSystemLafSucceded();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean isUpToJava15() {
        String string = System.getProperty("java.version");
        return string.startsWith("1.2") || string.startsWith("1.3") || string.startsWith("1.4") || string.startsWith("1.5");
    }

    public static boolean isWindowsLaF() {
        return UIManager.getLookAndFeel().getID().equals("Windows");
    }

    public static boolean isWindowsXpLaF() {
        return GUIHelper.isWindowsLaF() && Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive") != null && !Boolean.getBoolean("swing.noxp");
    }

    public static boolean isGtkLaF() {
        return UIManager.getLookAndFeel().getID().equals("GTK");
    }

    public static boolean isAlloyLaF() {
        return UIManager.getLookAndFeel().getID().equals("Alloy");
    }

    private static void adjustFontSize(int n) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<Font, Font> hashMap = new HashMap<Font, Font>();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = uIDefaults.get(k);
            if (!(object instanceof Font)) continue;
            Font font = (Font)object;
            Font font2 = (Font)hashMap.get(font);
            if (font2 == null) {
                font2 = new Font(font.getName(), font.getStyle(), font.getSize() + n);
                hashMap.put(font, font2);
            }
            linkedList.add(k);
            linkedList.add(font2);
        }
        uIDefaults.putDefaults(linkedList.toArray());
    }

    public static ImageIcon loadIcon(String string) {
        return new ImageIcon((class$com$install4j$runtime$installer$frontend$GUIHelper == null ? (class$com$install4j$runtime$installer$frontend$GUIHelper = GUIHelper.class$("com.install4j.runtime.installer.frontend.GUIHelper")) : class$com$install4j$runtime$installer$frontend$GUIHelper).getResource(ICONS_DIRECTORY + string));
    }

    public static int showOptionDialog(Component component, final String string, final String[] stringArray, final int n) throws UserCanceledException {
        if (InstallerUtil.isUnattended()) {
            return -1;
        }
        if (InstallerUtil.isConsole()) {
            return ConsoleImpl.getInstance().askOption(string, stringArray, null);
        }
        GUIHelper.setSystemLaF();
        final Component component2 = component == null ? GUIHelper.getParentWindow() : component;
        final int[] nArray = new int[1];
        if (SwingUtilities.isEventDispatchThread()) {
            GUIHelper.showOptionDialogInternal(component, string, n, stringArray, nArray);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        GUIHelper.showOptionDialogInternal(component2, string, n, stringArray, nArray);
                    }
                });
            }
            catch (Exception exception) {
                InstallerUtil.reportException(exception);
            }
        }
        return nArray[0];
    }

    private static void showOptionDialogInternal(Component component, String string, int n, String[] stringArray, int[] nArray) {
        nArray[0] = JOptionPane.showOptionDialog(component, string, Messages.getMessages().getString("SetupAppTitle"), 0, n, null, stringArray, stringArray[0]);
    }

    public static Window getParentWindow() {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return null;
        }
        Frame[] frameArray = JFrame.getFrames();
        if (frameArray != null && frameArray.length > 0) {
            return frameArray[0];
        }
        return null;
    }

    public static void showMessage(Component component, final String string, final int n) {
        if (InstallerUtil.isUnattended()) {
            System.err.println(string);
        } else if (InstallerUtil.isConsole()) {
            ConsoleImpl.getInstance().println(string);
        } else {
            Component component2;
            GUIHelper.setSystemLaF();
            Component component3 = component2 = component == null ? GUIHelper.getParentWindow() : component;
            if (SwingUtilities.isEventDispatchThread()) {
                GUIHelper.showMessageInternal(component2, string, n);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            GUIHelper.showMessageInternal(component2, string, n);
                        }
                    });
                }
                catch (Exception exception) {
                    InstallerUtil.reportException(exception);
                }
            }
        }
    }

    private static void showMessageInternal(Component component, String string, int n) {
        JOptionPane.showOptionDialog(component, string, Messages.getMessages().getString("SetupAppTitle"), -1, n, null, new Object[]{Messages.getMessages().getString("ButtonOK")}, null);
    }

    public static void showURL(String string) {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return;
        }
        Window window = GUIHelper.getParentWindow();
        if (InstallerUtil.isWindows()) {
            try {
                Runtime.getRuntime().exec("rundll32.exe url.dll,FileProtocolHandler " + string);
            }
            catch (IOException iOException) {
                GUIHelper.showBrowserError(window);
            }
        } else if (InstallerUtil.isMacOS()) {
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = GUIHelper.class$("java.lang.String")) : class$java$lang$String};
            Object[] objectArray = new Object[]{string};
            try {
                Class.forName("com.apple.mrj.MRJFileUtils").getDeclaredMethod("openURL", classArray).invoke(null, objectArray);
            }
            catch (Exception exception) {
                GUIHelper.showBrowserError(window);
            }
        } else {
            String[] stringArray;
            if (browserExecutable == null) {
                stringArray = new JFileChooser();
                stringArray.setFileSelectionMode(0);
                stringArray.setDialogTitle(Messages.getMessages().getString("LocateBrowerExecutable"));
                if (stringArray.showOpenDialog(window) != 0) {
                    return;
                }
                browserExecutable = stringArray.getSelectedFile().getPath();
            }
            stringArray = new String[]{browserExecutable, string};
            try {
                Runtime.getRuntime().exec(stringArray);
            }
            catch (IOException iOException) {
                browserExecutable = null;
                GUIHelper.showBrowserError(window);
            }
        }
    }

    private static void showBrowserError(Window window) {
        GUIHelper.showMessage(window, Messages.getMessages().getString("ErrorStartingBrowser"), 0);
    }

    public static ImageIcon getFrameIcon() {
        ImageIcon imageIcon = DEFAULT_ICON_FRAME_16;
        try {
            imageIcon = new ImageIcon(InstallerUtil.getInstallerFile("installer.png").getPath());
            if (imageIcon.getIconWidth() <= 0) {
                return DEFAULT_ICON_FRAME_16;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageIcon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ICON_FOLDER_OPEN = GUIHelper.loadIcon("folder_open.png");
        ICON_FOLDER_CLOSED = GUIHelper.loadIcon("folder_closed.png");
    }
}

