/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.ldap.CacheHandler;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDAO {
    public static final int DEFAULT_MAX_CONNECTION_ERROR = 1;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.ldap.BaseAO");
    protected LDAPAttributeMapping ldapAttrMapping;
    protected LDAPService ldapService;
    private NameParser parser;
    private static int maxConnectionError = -1;
    protected final CacheHandler cacheHandler;

    public BaseDAO(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, CacheHandler cacheHandler) throws Exception {
        this.ldapAttrMapping = ldapAttrMapping;
        this.ldapService = ldapService;
        this.cacheHandler = cacheHandler;
        this.initializeNameParser();
    }

    public static int getMaxConnectionError() {
        return maxConnectionError >= 0 ? maxConnectionError : 1;
    }

    public static void setMaxConnectionError(int connectionError) {
        maxConnectionError = connectionError;
    }

    public static boolean isConnectionError(Exception e) {
        return e instanceof CommunicationException || e instanceof ServiceUnavailableException;
    }

    protected String getGroupDNFromGroupId(String groupId) {
        StringBuilder buffer = new StringBuilder();
        String[] groupParts = groupId.split("/");
        for (int x = groupParts.length - 1; x > 0; --x) {
            buffer.append(this.ldapAttrMapping.groupDNKey + "=" + groupParts[x] + ", ");
        }
        buffer.append(this.ldapAttrMapping.groupsURL);
        return buffer.toString();
    }

    protected String getGroupIdFromGroupDN(String groupDN) throws NamingException {
        StringBuffer buffer = new StringBuffer();
        String[] baseParts = this.explodeDN(this.ldapAttrMapping.groupsURL, true);
        String[] membershipParts = this.explodeDN(groupDN, true);
        for (int x = membershipParts.length - baseParts.length - 1; x > -1; --x) {
            buffer.append("/" + membershipParts[x]);
        }
        return buffer.toString();
    }

    protected List<Object> getAttributes(Attributes attributes, String attribute) {
        ArrayList<Object> results;
        block4: {
            results = new ArrayList<Object>();
            try {
                if (attributes == null) {
                    return results;
                }
                Attribute attr = attributes.get(attribute);
                for (int x = 0; x < attr.size(); ++x) {
                    results.add(attr.get(x));
                }
            }
            catch (NamingException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return results;
    }

    @Deprecated
    protected Group getGroupFromMembershipDN(String membershipDN) throws Exception {
        String[] membershipParts = this.explodeDN(membershipDN, false);
        StringBuffer buffer = new StringBuffer();
        for (int x = 1; x < membershipParts.length; ++x) {
            if (x == membershipParts.length - 1) {
                buffer.append(membershipParts[x]);
                continue;
            }
            buffer.append(membershipParts[x] + ",");
        }
        Group group = this.getGroupByDN(buffer.toString());
        return group;
    }

    protected Group getGroupFromMembershipDN(LdapContext ctx, String membershipDN) throws NamingException {
        String groupDN = this.getGroupDNFromMembershipDN(membershipDN);
        Group group = this.getGroupByDN(ctx, groupDN);
        return group;
    }

    protected String getGroupDNFromMembershipDN(String membershipDN) throws NamingException {
        String[] membershipParts = this.explodeDN(membershipDN, false);
        StringBuffer buffer = new StringBuffer();
        for (int x = 1; x < membershipParts.length; ++x) {
            if (x == membershipParts.length - 1) {
                buffer.append(membershipParts[x]);
                continue;
            }
            buffer.append(membershipParts[x] + ",");
        }
        return buffer.toString();
    }

    @Deprecated
    protected Group getGroupByDN(String groupDN) throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    Group group = this.getGroupByDN(ctx, groupDN);
                    return group;
                }
                catch (NamingException e) {
                    ctx = this.reloadCtx(ctx, err, e);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    protected LdapContext reloadCtx(LdapContext ctx, int err, NamingException e) throws NamingException {
        if (!BaseDAO.isConnectionError(e) || err >= BaseDAO.getMaxConnectionError()) {
            throw e;
        }
        this.ldapService.release(ctx);
        ctx = this.ldapService.getLdapContext(true);
        return ctx;
    }

    protected Group getGroupByDN(LdapContext ctx, String groupDN) throws NamingException {
        try {
            Attributes attrs = ctx.getAttributes(groupDN);
            return this.buildGroup(groupDN, attrs);
        }
        catch (NameNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    protected Group buildGroup(String groupDN, Attributes attrs) throws NamingException {
        GroupImpl group = new GroupImpl();
        StringBuffer idBuffer = new StringBuffer();
        String parentId = null;
        String[] baseParts = this.explodeDN(this.ldapAttrMapping.groupsURL, true);
        String[] membershipParts = this.explodeDN(groupDN, true);
        for (int x = membershipParts.length - baseParts.length - 1; x > -1; --x) {
            idBuffer.append("/" + membershipParts[x]);
            if (x != 1) continue;
            parentId = idBuffer.toString();
        }
        group.setGroupName(membershipParts[0]);
        group.setId(idBuffer.toString());
        if (attrs != null) {
            group.setDescription(this.ldapAttrMapping.getAttributeValueAsString(attrs, this.ldapAttrMapping.ldapDescriptionAttr));
            group.setLabel(this.ldapAttrMapping.getAttributeValueAsString(attrs, this.ldapAttrMapping.groupLabelAttr));
        }
        group.setParentId(parentId);
        return group;
    }

    protected String[] explodeDN(String nameDN, boolean removeTypes) throws NamingException {
        Name dn = this.parser.parse(nameDN);
        Enumeration<String> enumeration = dn.getAll();
        ArrayList<String> list = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            String ldap = enumeration.nextElement();
            if (removeTypes) {
                int position = ldap.indexOf("=");
                String value = ldap.substring(position + 1);
                list.add(0, value);
                continue;
            }
            list.add(0, ldap);
        }
        String[] explodedDN = new String[list.size()];
        list.toArray(explodedDN);
        return explodedDN;
    }

    @Deprecated
    protected User getUserFromUsername(String username) throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    User user = this.getUserFromUsername(ctx, username);
                    return user;
                }
                catch (NamingException e) {
                    ctx = this.reloadCtx(ctx, err, e);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User getUserFromUsername(LdapContext ctx, String username) throws Exception {
        NamingEnumeration<SearchResult> answer = null;
        try {
            answer = this.findUser(ctx, username, true);
            if (answer.hasMoreElements()) {
                User user = this.ldapAttrMapping.attributesToUser(answer.next().getAttributes());
                return user;
            }
            User user = null;
            return user;
        }
        finally {
            if (answer != null) {
                answer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDNFromUsername(String username) throws NamingException {
        NamingEnumeration<SearchResult> answer = null;
        try {
            answer = this.findUser(username, false);
            if (answer.hasMoreElements()) {
                String string = answer.next().getNameInNamespace();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (answer != null) {
                answer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDNFromUsername(LdapContext ctx, String username) throws NamingException {
        NamingEnumeration<SearchResult> answer = null;
        try {
            answer = this.findUser(ctx, username, false);
            if (answer.hasMoreElements()) {
                String string = answer.next().getNameInNamespace();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (answer != null) {
                answer.close();
            }
        }
    }

    private NamingEnumeration<SearchResult> findUser(String username, boolean hasAttribute) throws NamingException {
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    NamingEnumeration<SearchResult> namingEnumeration = this.findUser(ctx, username, hasAttribute);
                    return namingEnumeration;
                }
                catch (NamingException e) {
                    ctx = this.reloadCtx(ctx, err, e);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    private NamingEnumeration<SearchResult> findUser(LdapContext ctx, String username, boolean hasAttribute) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        if (!hasAttribute) {
            constraints.setReturningAttributes(new String[]{""});
            constraints.setDerefLinkFlag(true);
        }
        String filter = "(&(" + this.ldapAttrMapping.userUsernameAttr + "=" + username + ")" + "(" + this.ldapAttrMapping.userObjectClassFilter + "))";
        return ctx.search(this.ldapAttrMapping.userURL, filter, constraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllSubtree(LdapContext ctx, String dn) throws NamingException {
        NamingEnumeration<SearchResult> answer = null;
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(1);
            answer = ctx.search(dn, "(objectclass=*)", constraints);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                this.removeAllSubtree(ctx, sr.getNameInNamespace());
            }
            ctx.destroySubcontext(dn);
            String groupId = this.buildGroup(dn, null).getId();
            this.cacheHandler.remove((Serializable)((Object)groupId), CacheHandler.CacheType.GROUP);
            this.cacheHandler.remove((Serializable)((Object)("g=" + groupId)), CacheHandler.CacheType.MEMBERSHIP);
        }
        finally {
            if (answer != null) {
                answer.close();
            }
        }
    }

    public static String escapeDN(String dn) {
        if (dn == null) {
            return dn;
        }
        StringBuilder buf = new StringBuilder(dn.length());
        block7: for (int i = 0; i < dn.length(); ++i) {
            char c = dn.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected User findUserByDN(LdapContext ctx, String userDN) throws Exception {
        if (userDN == null) {
            return null;
        }
        try {
            Attributes attrs = ctx.getAttributes(userDN);
            User user = this.ldapAttrMapping.attributesToUser(attrs);
            user.setFullName(user.getFirstName() + " " + user.getLastName());
            return user;
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    protected boolean haveUser(Attributes attrs, String userDN) throws NamingException {
        if (attrs == null || userDN == null) {
            return false;
        }
        List<Object> members = this.getAttributes(attrs, this.ldapAttrMapping.membershipTypeMemberValue);
        for (int i = 0; i < members.size(); ++i) {
            if (!String.valueOf(members.get(i)).trim().equalsIgnoreCase(userDN)) continue;
            return true;
        }
        return false;
    }

    protected String membershipClassFilter() {
        String mbfilter = this.ldapAttrMapping.membershipObjectClassFilter;
        if (mbfilter == null) {
            return null;
        }
        if (!mbfilter.startsWith("(")) {
            mbfilter = "(" + mbfilter;
        }
        if (!mbfilter.endsWith(")")) {
            mbfilter = mbfilter + ")";
        }
        return mbfilter;
    }

    private void initializeNameParser() throws NamingException {
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    this.parser = ctx.getNameParser("");
                    return;
                }
                catch (NamingException e) {
                    ctx = this.reloadCtx(ctx, err, e);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }
}

