/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.wikimodel.xwiki;

import java.util.Map;
import org.xwiki.rendering.internal.parser.wikimodel.DefaultXWikiGeneratorListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWiki21XWikiGeneratorListener
extends DefaultXWikiGeneratorListener {
    private static final String QUERY_STRING = "queryString";
    private static final String ANCHOR = "anchor";

    public XWiki21XWikiGeneratorListener(StreamParser parser, Listener listener, ResourceReferenceParser linkReferenceParser, ResourceReferenceParser imageReferenceParser, PrintRendererFactory plainRendererFactory, IdGenerator idGenerator) {
        super(parser, listener, linkReferenceParser, imageReferenceParser, plainRendererFactory, idGenerator);
    }

    @Override
    protected void onReference(ResourceReference reference, String label, boolean isFreeStandingURI, Map<String, String> parameters) {
        if (reference.getType().equals((Object)ResourceType.DOCUMENT)) {
            String anchor;
            String queryString = parameters.remove(QUERY_STRING);
            if (queryString != null) {
                reference.setParameter(QUERY_STRING, queryString);
            }
            if ((anchor = parameters.remove(ANCHOR)) != null) {
                reference.setParameter(ANCHOR, anchor);
            }
        }
        super.onReference(reference, label, isFreeStandingURI, parameters);
    }

    @Override
    protected void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        String queryString;
        if (reference.getType().equals((Object)ResourceType.ATTACHMENT) && (queryString = parameters.remove(QUERY_STRING)) != null) {
            reference.setParameter(QUERY_STRING, queryString);
        }
        super.onImage(reference, isFreeStandingURI, parameters);
    }
}

