/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeList;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeManager;
import org.exoplatform.ecm.webui.nodetype.selector.UINodeTypeSearch;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SearchNodeTypeActionListener.class})})
public class UINodeTypeSearchForm
extends UIForm {
    public UINodeTypeSearchForm() throws Exception {
        ((UINodeTypeSearch)this.addChild(UINodeTypeSearch.class, null, "NodeTypeSearch")).init();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchNodeTypeActionListener
    extends EventListener<UINodeTypeSearchForm> {
        public void execute(Event<UINodeTypeSearchForm> event) throws Exception {
            UINodeTypeSearchForm uiForm = (UINodeTypeSearchForm)((Object)event.getSource());
            UINodeTypeManager uiNodeTypeManager = (UINodeTypeManager)uiForm.getAncestorOfType(UINodeTypeManager.class);
            UINodeTypeList uiNodeTypeList = (UINodeTypeList)uiNodeTypeManager.getChild(UINodeTypeList.class);
            try {
                UIFormStringInput uiInputNodeType = (UIFormStringInput)uiForm.findComponentById("NodeTypeText");
                String nodeTypeName = (String)uiInputNodeType.getValue();
                if (nodeTypeName == null || nodeTypeName.length() == 0) {
                    return;
                }
                nodeTypeName = nodeTypeName.contains("*") && !nodeTypeName.contains(".*") ? nodeTypeName.replace("*", ".*") : nodeTypeName;
                Pattern p = Pattern.compile(".*".concat(nodeTypeName.trim()).concat(".*"), 2);
                List lstAllNodetype = uiNodeTypeList.getAllNodeTypes();
                ArrayList<UINodeTypeList.NodeTypeBean> lstNodetype = new ArrayList<UINodeTypeList.NodeTypeBean>();
                for (Object nodeType : lstAllNodetype) {
                    if (nodeType instanceof UINodeTypeList.NodeTypeBean) {
                        if (!p.matcher(((UINodeTypeList.NodeTypeBean)nodeType).getName()).find()) continue;
                        lstNodetype.add((UINodeTypeList.NodeTypeBean)nodeType);
                        continue;
                    }
                    if (!(nodeType instanceof Node) || !p.matcher(((Node)nodeType).getName()).find()) continue;
                    lstNodetype.add((UINodeTypeList.NodeTypeBean)nodeType);
                }
                uiNodeTypeList.refresh(null, 1, lstNodetype);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNodeTypeManager);
            }
            catch (PatternSyntaxException pSyntaxException) {
                uiNodeTypeList.refresh(null, 1, new ArrayList<UINodeTypeList.NodeTypeBean>());
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNodeTypeManager);
            }
        }
    }
}

