/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.thumbnail.impl;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;

public final class ThumbnailUtils {
    static Node getThumbnailFolder(Node parentNode) throws RepositoryException {
        if (!parentNode.hasNode(ThumbnailService.EXO_THUMBNAILS_FOLDER)) {
            try {
                Node thumbnailFolder = parentNode.addNode(ThumbnailService.EXO_THUMBNAILS_FOLDER, ThumbnailService.EXO_THUMBNAILS);
                parentNode.getSession().save();
                if (thumbnailFolder.canAddMixin("exo:hiddenable")) {
                    thumbnailFolder.addMixin("exo:hiddenable");
                }
                parentNode.getSession().save();
                return thumbnailFolder;
            }
            catch (ItemExistsException itemExistsException) {
                // empty catch block
            }
        }
        return parentNode.getNode(ThumbnailService.EXO_THUMBNAILS_FOLDER);
    }

    static Node getThumbnailNode(Node thumbnailFolder, String identifier) throws RepositoryException {
        if (!thumbnailFolder.hasNode(identifier)) {
            try {
                Node thumbnailNode = thumbnailFolder.addNode(identifier, ThumbnailService.EXO_THUMBNAIL);
                thumbnailFolder.getSession().save();
                return thumbnailNode;
            }
            catch (ItemExistsException itemExistsException) {
                // empty catch block
            }
        }
        return thumbnailFolder.getNode(identifier);
    }
}

