/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.sessions.impl;

import java.util.List;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.sessions.ACLSessionProviderService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLSessionProviderServiceThreadLocalImpl
implements ACLSessionProviderService {
    private static ThreadLocal<SessionProvider> aclSessionProviderKeepers = new ThreadLocal();

    @Override
    public SessionProvider getACLSessionProvider(List<AccessControlEntry> accessList) {
        SessionProvider provider = aclSessionProviderKeepers.get();
        if (provider == null) {
            provider = SessionProvider.createProvider(accessList);
            aclSessionProviderKeepers.set(provider);
        }
        return provider;
    }

    @Override
    public void clearSessionProviders() {
        SessionProvider provider = aclSessionProviderKeepers.get();
        if (provider != null) {
            provider.close();
            aclSessionProviderKeepers.remove();
        }
    }
}

